import { ag as ensure_array_like, a1 as store_get, ad as attr_class, ae as stringify, aa as escape_html, a3 as unsubscribe_stores, a9 as bind_props } from "./index2.js";
import "clsx";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { B as Button } from "./Button.js";
import { M as Modal, a as ModalBody } from "./Modal.js";
import { M as ModalFooter } from "./ModalFooter.js";
import { w as writable } from "./index.js";
function NoteList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let notes = $$props["notes"];
    $$renderer2.push(`<div class="note-grid"><!--[-->`);
    const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$notes", notes));
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let note = each_array[$$index];
      $$renderer2.push(`<div class="note-single"><div${attr_class(`note-card note-${stringify(note.label)}`)}>`);
      Card($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          CardBody($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h4 class="note-title">${escape_html(note.title)} <span class="note-status"></span></h4> <p class="note-excerpt">${escape_html(note.description)}</p> <div class="note-action"><div class="note-action__left"><a href="#">`);
              if (note.starred) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/star-solid.svg"/>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/star.svg"/>`);
              }
              $$renderer4.push(`<!--]--></a> <a href="#"><img class="svg" alt="" src="/img/svg/trash-2.svg"/></a></div> <div class="note-action__right"><div class="label-dropdown dropdown dropdown-hover"><a class="btn-link" href="#"><img class="svg" alt="" src="/img/svg/more-vertical.svg"/></a> <div class="dropdown-default"><a class="nl-personal dropdown-item" href="#">Personal</a> <a class="nl-work dropdown-item" href="#">Work</a> <a class="nl-social dropdown-item" href="#">Socail</a> <a class="nl-important dropdown-item" href="#">Important</a></div></div></div></div>`);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div></div>`);
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { notes });
  });
}
function AddNote($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let open = false;
    const toggle = () => open = !open;
    let addNote = $$props["addNote"];
    $$renderer2.push(`<div class="px-3">`);
    Button($$renderer2, {
      color: "primary",
      size: "default",
      class: "btn-rounded btn-block",
      children: ($$renderer3) => {
        $$renderer3.push(`<img class="svg" alt="" src="/img/svg/plus.svg"/> Add Note`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div> `);
    Modal($$renderer2, {
      isOpen: open,
      toggle,
      class: "noteModal",
      children: ($$renderer3) => {
        ModalBody($$renderer3, {
          class: "pb-0",
          children: ($$renderer4) => {
            Button($$renderer4, {
              color: "transparent",
              class: "close",
              children: ($$renderer5) => {
                $$renderer5.push(`<span aria-hidden="true">×</span>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> <form action="/"><div class="form-group mb-25"><label class="mb-2" for="text">Title</label> <input type="text" class="form-control" placeholder="Note Title" id="text"/></div> <div class="form-group mb-25"><label class="mb-2" for="textarea">Description</label> <textarea id="textarea" class="form-control" placeholder="Note Description"></textarea></div> <div class="form-group"><label class="mb-2" for="select-search">Note Label</label> <select class="form-control" id="noteType">`);
            $$renderer4.option({}, ($$renderer5) => {
              $$renderer5.push(`Social`);
            });
            $$renderer4.option({}, ($$renderer5) => {
              $$renderer5.push(`Work`);
            });
            $$renderer4.option({}, ($$renderer5) => {
              $$renderer5.push(`Personal`);
            });
            $$renderer4.option({}, ($$renderer5) => {
              $$renderer5.push(`Important`);
            });
            $$renderer4.push(`</select></div></form>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        ModalFooter($$renderer3, {
          class: "note-submit-btn d-flex justify-content-start border-top-0 m-n1 px-30 pt-25 pb-25",
          children: ($$renderer4) => {
            Button($$renderer4, {
              color: "primary",
              size: "sm",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->Add New Note`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!---->`);
    bind_props($$props, { addNote });
  });
}
function createNotes(initialValue = []) {
  const { subscribe, update } = writable(initialValue);
  return {
    subscribe,
    add(input, textarea, select, id) {
      const note = {
        key: id,
        title: input.value,
        description: textarea.value,
        trash: false,
        starred: true,
        label: select.value
      };
      update((prev) => {
        return [note, ...prev];
      });
    },
    remove(note) {
      update((prev) => {
        return prev.filter((item) => item !== note);
      });
    },
    toggle(note) {
      note.completed = !note.completed;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.completed !== item);
        });
      }, 0);
    },
    trash(note) {
      note.trash = !note.trash;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.trash !== item);
        });
      }, 0);
    },
    favorite(note) {
      note.starred = !note.starred;
      setTimeout(() => {
        update((prev) => {
          return prev.filter((item) => item.starred !== item);
        });
      }, 0);
    }
  };
}
const noteData = [
  {
    key: 1,
    title: "Landing Page Design",
    time: 1601453813448,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: false,
    trash: false,
    label: "personal"
  },
  {
    key: 2,
    title: "Add New Components",
    time: 1601453813450,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: true,
    trash: false,
    label: "work"
  },
  {
    key: 3,
    title: "Shop Page Design",
    time: 1601453813470,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: false,
    trash: false,
    label: "social"
  },
  {
    key: 4,
    title: "New Features to Extension",
    time: 1601453813548,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: true,
    trash: false,
    label: "work"
  },
  {
    key: 5,
    title: "Marketing App Redesign",
    time: 1601453813550,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: true,
    trash: false,
    label: "social"
  },
  {
    key: 6,
    title: "Check Support Tickets",
    time: 1601453813470,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: false,
    trash: false,
    label: "important"
  },
  {
    key: 7,
    title: "Feeback Newly Launched Product",
    time: 1601453813470,
    description: "Lorem Ipsum is simply dummy text of the printing",
    starred: false,
    trash: false,
    label: "personal"
  }
];
export {
  AddNote as A,
  NoteList as N,
  createNotes as c,
  noteData as n
};
