import { ad as attr_class, a8 as clsx, ag as ensure_array_like, ae as stringify, aa as escape_html } from "./index2.js";
import { C as Chartjs } from "./Chartjs.js";
import { d as doughnutData } from "./dashboardChartContent.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
function UserOverview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let userOverviewDataset;
    let { userOverviewData } = doughnutData;
    let currentTab = "today";
    let colorPrimaryRGB;
    let colorInfoRGB;
    const tooltip = {
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    const scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#E3E6EF",
          borderDash: [3, 3],
          zeroLineColor: "#E3E6EF",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...userOverviewData[currentTab].gained),
          padding: 15,
          stepSize: Math.floor(Math.max(...userOverviewData[currentTab].gained) / 5),
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#E3E6EF",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    userOverviewDataset = [
      {
        data: userOverviewData[currentTab].target,
        backgroundColor: `rgba(${colorPrimaryRGB}, 0.5)`,
        hoverBackgroundColor: `rgb(${colorPrimaryRGB})`,
        label: "Target",
        maxBarThickness: 10,
        barThickness: 12,
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        borderRadius: 2,
        labelType: "primary"
      },
      {
        data: userOverviewData[currentTab].gained,
        backgroundColor: `rgba(${colorInfoRGB}, 0.5)`,
        hoverBackgroundColor: `rgb(${colorInfoRGB})`,
        label: "Gained",
        maxBarThickness: 10,
        barThickness: 12,
        total: "5,550",
        prefix: "$",
        growthRate: "15",
        growthStatus: "down",
        borderRadius: 2,
        labelType: "info"
      }
    ];
    Card($$renderer2, {
      class: "border-0 user-overview h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-bottom-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Users Overview</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="cashflow-chart"><div class="label-detailed"><!--[-->`);
            const each_array = ensure_array_like(userOverviewDataset);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              $$renderer4.push(`<div class="label-detailed__single"><span${attr_class(`label-detailed__type label-detailed__type--${stringify(item.labelType)}`)}>${escape_html(item.label)}</span> <strong class="label-detailed__total">${escape_html(item.prefix + item.total)}</strong> <span${attr_class(`label-detailed__status ${stringify(item.growthStatus === "up" ? "color-success" : "color-danger")}`)}>`);
              if (item.growthStatus === "up") {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/arrow-success-up.svg"/>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/arrow-danger-down.svg"/>`);
              }
              $$renderer4.push(`<!--]--> <strong>${escape_html(item.growthRate)}%</strong></span></div>`);
            }
            $$renderer4.push(`<!--]--></div> `);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                className: "userChart",
                id: "userCharts",
                labels: userOverviewData[currentTab].labels,
                datasets: userOverviewDataset,
                type: "bar",
                tooltip,
                scales,
                height: 104
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
export {
  UserOverview as U
};
