import { ag as ensure_array_like, ad as attr_class, ae as stringify, aa as escape_html } from "./index2.js";
import "clsx";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as CardExtra } from "./CardExtra.js";
function Timeline($$renderer) {
  let timelineContent = [
    {
      type: "primary",
      title: "Create a services site",
      date: "2015-09-01",
      posted: "17 mins ago"
    },
    {
      type: "secondary",
      title: "Solve initial network problems",
      date: "2015-09-05",
      posted: "2 hours ago"
    },
    {
      type: "success",
      title: "Technical testing",
      date: "2015-05-02",
      posted: "3 hours ago"
    },
    {
      type: "info",
      title: "Network problems being solved",
      date: "2016-03-12",
      posted: "4 hours ago"
    },
    {
      type: "warning",
      title: "Technical testing",
      date: "2015-03-07",
      posted: "5 hours ago"
    },
    {
      type: "danger",
      title: "Network problems being solved",
      date: "2022-06-25",
      posted: "7 hours ago"
    }
  ];
  Card($$renderer, {
    class: "border-0 card-timeline h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Timeline</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "pb-30 pt-1 mt-n10",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="card-timeline-body"><ul><!--[-->`);
          const each_array = ensure_array_like(timelineContent);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let item = each_array[$$index];
            $$renderer3.push(`<li><div class="card-timeline-body__left"><div class="card-timeline-body__title"><span class="timeline-line"></span> <span${attr_class(`badge-dot badge-dot--big dot-${stringify(item.type)}`)}></span> <p>${escape_html(item.title)}<span>${escape_html(item.date)}</span></p></div></div> <div class="card-timeline-body__right"><div class="card-timeline-body__time"><span>${escape_html(item.posted)}</span></div></div></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
export {
  Timeline as T
};
