import { ad as attr_class, a8 as clsx, ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html } from "./index2.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { M as MarketingCampaigns, t as teamList } from "./teamList2.js";
import { C as CardExtra } from "./CardExtra.js";
function MarketingCampaigns_1($$renderer) {
  const campaignData = {
    today: [
      {
        id: 1,
        title: "Microsoft Company",
        amount: "1045,520",
        percent: 84,
        icon: "internet-explorer.png"
      },
      {
        id: 2,
        title: "WordPress",
        amount: "2000,520",
        percent: 62,
        icon: "wordpress.png"
      },
      {
        id: 3,
        title: "Adidas Brand",
        amount: "1520,950",
        percent: 47,
        icon: "adidas.png"
      },
      {
        id: 4,
        title: "Slack",
        amount: "7045,154",
        percent: 69,
        icon: "slack.png"
      },
      {
        id: 5,
        title: "Adobe CC",
        amount: "1252,220",
        percent: 54,
        icon: "adobe.png"
      }
    ],
    week: [
      {
        id: 2,
        title: "WordPress",
        amount: "2000,520",
        percent: 90,
        icon: "wordpress.png"
      },
      {
        id: 1,
        title: "Microsoft Company",
        amount: "1045,520",
        percent: 80,
        icon: "internet-explorer.png"
      },
      {
        id: 4,
        title: "Slack",
        amount: "7045,154",
        percent: 60,
        icon: "slack.png"
      },
      {
        id: 3,
        title: "Adidas Brand",
        amount: "1520,950",
        percent: 50,
        icon: "adidas.png"
      },
      {
        id: 5,
        title: "Adobe CC",
        amount: "1252,220",
        percent: 60,
        icon: "adobe.png"
      }
    ],
    month: [
      {
        id: 4,
        title: "Slack",
        amount: "7045,154",
        percent: 80,
        icon: "slack.png"
      },
      {
        id: 5,
        title: "Adobe CC",
        amount: "1252,220",
        percent: 70,
        icon: "adobe.png"
      },
      {
        id: 2,
        title: "WordPress",
        amount: "2000,520",
        percent: 60,
        icon: "wordpress.png"
      },
      {
        id: 1,
        title: "Microsoft Company",
        amount: "1045,520",
        percent: 80,
        icon: "internet-explorer.png"
      },
      {
        id: 3,
        title: "Adidas Brand",
        amount: "1520,950",
        percent: 50,
        icon: "adidas.png"
      }
    ]
  };
  let period = "today";
  let dataPeriod = campaignData[period];
  Card($$renderer, {
    class: "border-0 px-25 merketing-campaigns h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Marketing Campaigns</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          MarketingCampaigns($$renderer3, { dataPeriod });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
function TeamList($$renderer) {
  const data = teamList;
  Card($$renderer, {
    class: "border-0 teams h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "border-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Team Members</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="team-members svelte-o2g4fn"><ul class="svelte-o2g4fn"><!--[-->`);
          const each_array = ensure_array_like(data);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let team = each_array[$$index];
            $$renderer3.push(`<li class="svelte-o2g4fn"><div class="team-members__left svelte-o2g4fn"><img${attr("src", `/img/team/${stringify(team.avatar)}`)} alt="" class="svelte-o2g4fn"/> <div class="team-members__title svelte-o2g4fn"><h6 class="svelte-o2g4fn">${escape_html(team.title)}</h6></div></div> <div class="team-members__middle svelte-o2g4fn"><div class="team-members__title--online d-flex align-items-center svelte-o2g4fn"><span class="badge-dot dot-success svelte-o2g4fn"></span>Online</div></div> <div class="team-member__right svelte-o2g4fn"><div class="team-member__add svelte-o2g4fn"><button type="button" class="svelte-o2g4fn">add</button></div></div></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
export {
  MarketingCampaigns_1 as M,
  TeamList as T
};
