import { a6 as fallback, ad as attr_class, a1 as store_get, ag as ensure_array_like, a3 as unsubscribe_stores, a9 as bind_props, ae as stringify, aa as escape_html } from "./index2.js";
import "clsx";
import { B as Button } from "./Button.js";
import { I as Input } from "./Input.js";
import { M as Modal, a as ModalBody } from "./Modal.js";
import { M as ModalHeader } from "./ModalHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { t as taskData, c as createTasks } from "./task.js";
function TaskApp($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let tasks;
    let taskLimit = fallback($$props["taskLimit"], 5);
    let header = $$props["header"];
    let taskStatus = $$props["taskStatus"];
    let description = $$props["description"];
    let actionBtn = fallback($$props["actionBtn"], false);
    let open = false;
    const toggle = () => open = !open;
    let slicedData = taskData.slice(0, taskLimit);
    let taskDataSorted = slicedData;
    let favorite = taskDataSorted.filter((item) => item.favorite);
    let completed = taskDataSorted.filter((item) => item.completed);
    tasks = createTasks(taskDataSorted);
    $$renderer2.push(`<div${attr_class(`task-list-style ${stringify(actionBtn ? "task-list-style--action" : "")}`, "svelte-98mm2i")}><div class="ninjadash-tassklist-wrap svelte-98mm2i">`);
    if (header !== "") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="ninjadash-tasklist-head svelte-98mm2i"><h2 class="ninjadash-tasklist-head__title svelte-98mm2i">${escape_html(header)}</h2></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="ninjadash-tasklist-body svelte-98mm2i">`);
    if (taskStatus === "favorite") {
      $$renderer2.push("<!--[-->");
      if (favorite.length) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<ul class="ninjadash-tasklist svelte-98mm2i"><!--[-->`);
        const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$tasks", tasks).filter((item) => item.favorite));
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let task = each_array[$$index];
          $$renderer2.push(`<li class="ninjadash-tasklist-item svelte-98mm2i"><div class="ninjadash-tasklist-item__content"><div class="ninjadash-tasklist-item__title svelte-98mm2i">`);
          Input($$renderer2, {
            type: "checkbox",
            checked: !!task.completed,
            label: task.title,
            id: task.id,
            class: "checkbox-theme-default custom-checkbox custom-checkbox--success checkbox-group__single d-flex p-0"
          });
          $$renderer2.push(`<!----></div> `);
          if (description) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<div class="ninjadash-tasklist-item__text svelte-98mm2i"><p class="svelte-98mm2i">${escape_html(task.description)}</p></div>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]--></div> <div class="ninjadash-tasklist-item__action svelte-98mm2i"><a class="ninjadash-edit svelte-98mm2i" href="#"><i class="uil uil-edit svelte-98mm2i"></i></a> <a href="#"${attr_class(
            `${task.favorite ? "task-favourite task-favorite--active" : "task-favourite"}`,
            "svelte-98mm2i"
          )}><i class="uil uil-star svelte-98mm2i"></i></a> <a class="ninjadash-delete svelte-98mm2i" href="#"><i class="uil uil-times svelte-98mm2i"></i></a></div></li>`);
        }
        $$renderer2.push(`<!--]--></ul>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="ninjadash-tasklist-empty svelte-98mm2i"><span class="svelte-98mm2i">Sorry !! No Favorite Task Found :(</span></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else if (taskStatus === "completed") {
      $$renderer2.push("<!--[1-->");
      if (completed.length) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<ul class="ninjadash-tasklist svelte-98mm2i"><!--[-->`);
        const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$tasks", tasks).filter((item) => item.completed));
        for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
          let task = each_array_1[$$index_1];
          $$renderer2.push(`<li class="ninjadash-tasklist-item svelte-98mm2i"><div class="ninjadash-tasklist-item__content"><div class="ninjadash-tasklist-item__title svelte-98mm2i">`);
          Input($$renderer2, {
            type: "checkbox",
            checked: !!task.completed,
            label: task.title,
            id: task.id,
            class: "checkbox-theme-default custom-checkbox custom-checkbox--success checkbox-group__single d-flex p-0"
          });
          $$renderer2.push(`<!----></div> `);
          if (description) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<div class="ninjadash-tasklist-item__text svelte-98mm2i"><p class="svelte-98mm2i">${escape_html(task.description)}</p></div>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]--></div> <div class="ninjadash-tasklist-item__action svelte-98mm2i"><a class="ninjadash-edit svelte-98mm2i" href="#"><i class="uil uil-edit svelte-98mm2i"></i></a> <a href="#"${attr_class(
            `${task.favorite ? "task-favourite task-favorite--active" : "task-favourite"}`,
            "svelte-98mm2i"
          )}><i class="uil uil-star svelte-98mm2i"></i></a> <a class="ninjadash-delete svelte-98mm2i" href="#"><i class="uil uil-times svelte-98mm2i"></i></a></div></li>`);
        }
        $$renderer2.push(`<!--]--></ul>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="ninjadash-tasklist-empty svelte-98mm2i"><span class="svelte-98mm2i">Sorry !! No Completed Task Found.</span></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div>`);
      if (store_get($$store_subs ??= {}, "$tasks", tasks).length) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<ul class="ninjadash-tasklist svelte-98mm2i"><!--[-->`);
        const each_array_2 = ensure_array_like(store_get($$store_subs ??= {}, "$tasks", tasks));
        for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
          let task = each_array_2[$$index_2];
          $$renderer2.push(`<li class="ninjadash-tasklist-item svelte-98mm2i"><div class="ninjadash-tasklist-item__content"><div class="ninjadash-tasklist-item__title svelte-98mm2i">`);
          Input($$renderer2, {
            type: "checkbox",
            checked: !!task.completed,
            label: task.title,
            id: task.id,
            class: "checkbox-theme-default custom-checkbox custom-checkbox--success checkbox-group__single d-flex p-0"
          });
          $$renderer2.push(`<!----></div> `);
          if (description) {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<div class="ninjadash-tasklist-item__text svelte-98mm2i"><p class="svelte-98mm2i">${escape_html(task.description)}</p></div>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]--></div> <div class="ninjadash-tasklist-item__action svelte-98mm2i"><a class="ninjadash-edit svelte-98mm2i" href="#"><i class="uil uil-edit svelte-98mm2i"></i></a> <a href="#"${attr_class(
            `${task.favorite ? "task-favourite task-favorite--active" : "task-favourite"}`,
            "svelte-98mm2i"
          )}><i class="uil uil-star svelte-98mm2i"></i></a> <a class="ninjadash-delete svelte-98mm2i" href="#"><i class="uil uil-times svelte-98mm2i"></i></a></div></li>`);
        }
        $$renderer2.push(`<!--]--></ul> `);
        if (actionBtn) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="task-list-btn px-25 mb-25">`);
          Button($$renderer2, {
            color: "primary",
            class: "btn-default btn-squared btn-transparent-primary radius-xs fs-15 fw-400 text-capitalize",
            children: ($$renderer3) => {
              $$renderer3.push(`<i class="uil uil-plus me-1 fs-16"></i> Add New Task`);
            },
            $$slots: { default: true }
          });
          $$renderer2.push(`<!----></div> <div class="add-todo-modal">`);
          Modal($$renderer2, {
            isOpen: open,
            toggle,
            children: ($$renderer3) => {
              ModalHeader($$renderer3, {
                toggle,
                class: "add-todo-header",
                children: ($$renderer4) => {
                  $$renderer4.push(`<h6 class="modal-title add-todo-title">Add New Todo</h6>`);
                },
                $$slots: { default: true }
              });
              $$renderer3.push(`<!----> `);
              ModalBody($$renderer3, {
                children: ($$renderer4) => {
                  $$renderer4.push(`<div class="add-todo-form"><form action="/"><div class="form-group"><input type="text" class="form-control form-control-lg" id="add-task-input" name="todo-text" placeholder="Write your task"/></div> <div class="form-group mb-0 mt-15">`);
                  Button($$renderer4, {
                    color: "primary",
                    size: "lg",
                    children: ($$renderer5) => {
                      $$renderer5.push(`<!---->Add Task`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer4.push(`<!----></div></form></div>`);
                },
                $$slots: { default: true }
              });
              $$renderer3.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer2.push(`<!----></div>`);
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div class="ninjadash-tasklist-empty svelte-98mm2i"><span class="svelte-98mm2i">Sorry! No Task Found.</span></div>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]--></div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { taskLimit, header, taskStatus, description, actionBtn });
  });
}
export {
  TaskApp as T
};
