import { aa as escape_html, a9 as bind_props } from "./index2.js";
import "clsx";
import { I as Input } from "./Input.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { S as SearchIcon } from "./SearchIcon.js";
function TableToolbox($$renderer, $$props) {
  let filtering = $$props["filtering"];
  let buttonText = $$props["buttonText"];
  $$renderer.push(`<div class="table-top-toolbox-wrap d-flex justify-content-between flex-wrap mb-25 mt-n10"><div class="toolbox-search global-shadow"><div class="toolbox-search__left"><div class="toolbox-search__form">`);
  SearchIcon($$renderer, {});
  $$renderer.push(`<!----> `);
  Input($$renderer, {
    class: "me-sm-2 border-0 box-shadow-none",
    type: "text",
    placeholder: "Filter by keyword",
    value: ""
  });
  $$renderer.push(`<!----></div> `);
  if (filtering === true) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<div class="order-tab"><p>Status :</p> <div class="data-filter-wrap"><ul class="nav px-1 data-filter-box"><li><a class="active" href="#all">All</a></li> <li><a href="#shipped">Shipped</a></li> <li><a href="#awaiting-shipment">Awaiting Shipment</a></li> <li><a href="#canceled">Canceled</a></li></ul></div></div>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--></div> <div class="content-center mt-10"><div class="button-group m-0 mt-xl-0 mt-sm-10 order-button-group"><button class="order-bg-opacity-secondary radius-md btn btn-sm color-secondary">Export</button> <button class="btn-primary radius-md btn btn-sm"><i class="la la-plus"></i> Add ${escape_html(buttonText)}</button></div></div></div></div>`);
  bind_props($$props, { filtering, buttonText });
}
export {
  TableToolbox as T
};
