import { $ as setContext, a0 as slot, a6 as fallback, ad as attr_class, a8 as clsx, a9 as bind_props, a4 as sanitize_props, a5 as rest_props, a7 as attributes, ag as ensure_array_like } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Colgroup($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    setContext("colgroup", true);
    $$renderer2.push(`<colgroup><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></colgroup>`);
  });
}
function ResponsiveContainer($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let responsiveClassName;
    let className = fallback($$props["class"], "");
    let responsive = fallback($$props["responsive"], false);
    responsiveClassName = classnames(className, {
      "table-responsive": responsive === true,
      [`table-responsive-${responsive}`]: typeof responsive === "string"
    });
    if (responsive) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(clsx(responsiveClassName))}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { class: className, responsive });
  });
}
function TableFooter($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, []);
  $$renderer.component(($$renderer2) => {
    setContext("footer", true);
    $$renderer2.push(`<tfoot${attributes({ ...$$restProps })}><tr><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></tr></tfoot>`);
  });
}
function TableHeader($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, []);
  $$renderer.component(($$renderer2) => {
    setContext("header", true);
    $$renderer2.push(`<thead${attributes({ ...$$restProps })}><tr><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></tr></thead>`);
  });
}
function Table($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "size",
    "bordered",
    "borderless",
    "striped",
    "hover",
    "responsive",
    "rows"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let size = fallback($$props["size"], "");
    let bordered = fallback($$props["bordered"], false);
    let borderless = fallback($$props["borderless"], false);
    let striped = fallback($$props["striped"], false);
    let hover = fallback($$props["hover"], false);
    let responsive = fallback($$props["responsive"], false);
    let rows = fallback($$props["rows"], void 0);
    classes = classnames(className, "table", size ? "table-" + size : false, bordered ? "table-bordered" : false, borderless ? "table-borderless" : false, striped ? "table-striped" : false, hover ? "table-hover" : false);
    ResponsiveContainer($$renderer2, {
      responsive,
      children: ($$renderer3) => {
        $$renderer3.push(`<table${attributes({ ...$$restProps, class: clsx(classes) })}>`);
        if (rows) {
          $$renderer3.push("<!--[-->");
          Colgroup($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<!--[-->`);
              slot($$renderer4, $$props, "default", {}, null);
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          TableHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<!--[-->`);
              slot($$renderer4, $$props, "default", {}, null);
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <tbody><!--[-->`);
          const each_array = ensure_array_like(rows);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let row = each_array[$$index];
            $$renderer3.push(`<tr><!--[-->`);
            slot($$renderer3, $$props, "default", { row }, null);
            $$renderer3.push(`<!--]--></tr>`);
          }
          $$renderer3.push(`<!--]--></tbody> `);
          TableFooter($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<!--[-->`);
              slot($$renderer4, $$props, "default", {}, null);
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<!--[-->`);
          slot($$renderer3, $$props, "default", {}, null);
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--></table>`);
      },
      $$slots: { default: true }
    });
    bind_props($$props, {
      class: className,
      size,
      bordered,
      borderless,
      striped,
      hover,
      responsive,
      rows
    });
  });
}
export {
  Table as T
};
