import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props, $ as setContext, af as spread_props, am as getContext, a1 as store_get, aa as escape_html, a3 as unsubscribe_stores } from "./index2.js";
import { w as writable } from "./index.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Nav($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "tabs",
    "pills",
    "vertical",
    "horizontal",
    "justified",
    "fill",
    "navbar",
    "card",
    "theme",
    "underline"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let tabs = fallback($$props["tabs"], false);
    let pills = fallback($$props["pills"], false);
    let vertical = fallback($$props["vertical"], "");
    let horizontal = fallback($$props["horizontal"], "");
    let justified = fallback($$props["justified"], false);
    let fill = fallback($$props["fill"], false);
    let navbar = fallback($$props["navbar"], false);
    let card = fallback($$props["card"], false);
    let theme = fallback($$props["theme"], null);
    let underline = fallback($$props["underline"], false);
    function getVerticalClass(vertical2) {
      if (!vertical2) {
        return false;
      }
      if (vertical2 === true || vertical2 === "xs") {
        return "flex-column";
      }
      return `flex-${vertical2}-column`;
    }
    classes = classnames(className, navbar ? "navbar-nav" : "nav", horizontal ? `justify-content-${horizontal}` : false, getVerticalClass(vertical), {
      "nav-tabs": tabs,
      "card-header-tabs": card && tabs,
      "nav-pills": pills,
      "card-header-pills": card && pills,
      "nav-justified": justified,
      "nav-fill": fill,
      "nav-underline": underline
    });
    $$renderer2.push(`<ul${attributes({
      ...$$restProps,
      class: clsx(classes),
      "data-bs-theme": theme
    })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></ul>`);
    bind_props($$props, {
      class: className,
      tabs,
      pills,
      vertical,
      horizontal,
      justified,
      fill,
      navbar,
      card,
      theme,
      underline
    });
  });
}
function NavItem($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "active"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    classes = classnames(className, "nav-item", active ? "active" : false);
    $$renderer2.push(`<li${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></li>`);
    bind_props($$props, { class: className, active });
  });
}
function NavLink($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "disabled", "active", "href"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let disabled = fallback($$props["disabled"], false);
    let active = fallback($$props["active"], false);
    let href = fallback($$props["href"], "#");
    classes = classnames(className, "nav-link", { disabled, active });
    $$renderer2.push(`<a${attributes({ ...$$restProps, href, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></a>`);
    bind_props($$props, { class: className, disabled, active, href });
  });
}
function TabHeader($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, []);
  $$renderer.component(($$renderer2) => {
    setContext("tabs", true);
    Nav($$renderer2, spread_props([
      $$restProps,
      {
        children: ($$renderer3) => {
          $$renderer3.push(`<!--[-->`);
          slot($$renderer3, $$props, "default", {}, null);
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      }
    ]));
  });
}
function TabContent($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "pills", "vertical"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let pills = fallback($$props["pills"], false);
    let vertical = fallback($$props["vertical"], false);
    const activeTabId = writable();
    setContext("tabContent", {
      activeTabId,
      setActiveTab: (tabId) => {
        activeTabId.set(tabId);
      }
    });
    classes = classnames("tab-content", className, { "d-flex align-items-start": vertical });
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}>`);
    TabHeader($$renderer2, {
      class: classnames({ "me-3": vertical }),
      pills,
      tabs: !pills,
      vertical,
      children: ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        slot($$renderer3, $$props, "default", {}, null);
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, pills, vertical });
  });
}
function TabPane($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "active", "disabled", "tab", "tabId"]);
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let classes;
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    let disabled = fallback($$props["disabled"], false);
    let tab = fallback($$props["tab"], void 0);
    let tabId = fallback($$props["tabId"], void 0);
    const tabs = getContext("tabs");
    const { activeTabId, setActiveTab } = getContext("tabContent");
    let tabOpen = active;
    if (store_get($$store_subs ??= {}, "$activeTabId", activeTabId) !== void 0) tabOpen = store_get($$store_subs ??= {}, "$activeTabId", activeTabId) === tabId;
    classes = classnames("tab-pane", className, { active: tabOpen, show: tabOpen });
    if (tabs) {
      $$renderer2.push("<!--[-->");
      NavItem($$renderer2, {
        children: ($$renderer3) => {
          NavLink($$renderer3, {
            active: tabOpen,
            disabled,
            children: ($$renderer4) => {
              if (tab) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`${escape_html(tab)}`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> <!--[-->`);
              slot($$renderer4, $$props, "tab", {}, null);
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          });
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { class: className, active, disabled, tab, tabId });
  });
}
export {
  TabContent as T,
  TabPane as a
};
