import { a6 as fallback, ad as attr_class, al as attr_style, a9 as bind_props, ae as stringify, a0 as slot } from "./index2.js";
import { o as onDestroy } from "./index-server.js";
const linear = (x) => x;
function fade(node, { delay = 0, duration = 400, easing = linear } = {}) {
  const o = +getComputedStyle(node).opacity;
  return {
    delay,
    duration,
    easing,
    css: (t) => `opacity: ${t * o}`
  };
}
function Svrollbar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let teardownViewport, teardownContents, teardownTrack, teardownThumb, marginTop, marginBottom, marginRight, marginLeft, wholeHeight, scrollTop, trackHeight, thumbHeight, thumbTop, scrollable, visible;
    let viewport = $$props["viewport"];
    let contents = $$props["contents"];
    let hideAfter = fallback($$props["hideAfter"], 1e3);
    let alwaysVisible = fallback($$props["alwaysVisible"], false);
    let initiallyVisible = fallback($$props["initiallyVisible"], false);
    let margin = fallback($$props["margin"], () => ({}), true);
    let vTrackIn = fallback($$props["vTrackIn"], (node) => fade(node, { duration: 100 }));
    let vTrackOut = fallback($$props["vTrackOut"], (node) => fade(node, { duration: 300 }));
    let vThumbIn = fallback($$props["vThumbIn"], (node) => fade(node, { duration: 100 }));
    let vThumbOut = fallback($$props["vThumbOut"], (node) => fade(node, { duration: 300 }));
    let timer = 0;
    let windowScrollEnabled = false;
    let interacted = false;
    function setupViewport(viewport2) {
      if (!viewport2) return;
      teardownViewport?.();
      if (typeof window.ResizeObserver === "undefined") {
        throw new Error("window.ResizeObserver is missing.");
      }
      windowScrollEnabled = document.scrollingElement === viewport2;
      const element = windowScrollEnabled ? document : viewport2;
      element.addEventListener("scroll", onScroll, { passive: true });
      const observer = new ResizeObserver((entries) => {
        for (const _entry of entries) {
          wholeHeight = viewport2?.scrollHeight ?? 0;
          trackHeight = viewport2?.clientHeight - (marginTop + marginBottom);
        }
      });
      observer.observe(viewport2);
      return () => {
        element.removeEventListener("scroll", onScroll);
        observer.unobserve(contents);
        observer.disconnect();
      };
    }
    function setupTrack(track) {
      return;
    }
    function setupThumb(thumb) {
      return;
    }
    function setupContents(contents2) {
      if (!contents2) return;
      teardownContents?.();
      if (typeof window.ResizeObserver === "undefined") {
        throw new Error("window.ResizeObserver is missing.");
      }
      const observer = new ResizeObserver((entries) => {
        for (const _entry of entries) {
          wholeHeight = viewport?.scrollHeight ?? 0;
        }
      });
      observer.observe(contents2);
      return () => {
        observer.unobserve(contents2);
        observer.disconnect();
      };
    }
    function setupTimer() {
      timer = window.setTimeout(
        () => {
          visible = scrollable && (alwaysVisible || initiallyVisible && !interacted) || false;
        },
        hideAfter
      );
    }
    function clearTimer() {
      if (timer) {
        window.clearTimeout(timer);
        timer = 0;
      }
    }
    function onScroll() {
      if (!scrollable) return;
      clearTimer();
      setupTimer();
      visible = alwaysVisible || initiallyVisible && !interacted || true;
      scrollTop = viewport?.scrollTop ?? 0;
      interacted = true;
    }
    onDestroy(() => {
      teardownViewport?.();
      teardownContents?.();
      teardownTrack?.();
      teardownThumb?.();
    });
    teardownViewport = setupViewport(viewport);
    teardownContents = setupContents(contents);
    teardownTrack = setupTrack();
    teardownThumb = setupThumb();
    marginTop = margin.top ?? 0;
    marginBottom = margin.bottom ?? 0;
    marginRight = margin.right ?? 0;
    marginLeft = margin.left ?? 0;
    wholeHeight = viewport?.scrollHeight ?? 0;
    scrollTop = viewport?.scrollTop ?? 0;
    trackHeight = viewport?.clientHeight ?? 0 - (marginTop + marginBottom);
    thumbHeight = wholeHeight > 0 ? trackHeight / wholeHeight * trackHeight : 0;
    thumbTop = wholeHeight > 0 ? scrollTop / wholeHeight * trackHeight : 0;
    scrollable = wholeHeight > trackHeight;
    visible = scrollable && (alwaysVisible || initiallyVisible);
    if (visible) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class("v-scrollbar svelte-1u3nuoj", void 0, { "fixed": windowScrollEnabled })}${attr_style(`height: ${stringify(trackHeight)}px; margin: ${stringify(marginTop)}px ${stringify(marginRight)}px ${stringify(marginBottom)}px ${stringify(marginLeft)}px`)}><div class="v-track svelte-1u3nuoj"${attr_style(`height: ${stringify(trackHeight)}px`)}></div> <div class="v-thumb svelte-1u3nuoj"${attr_style(`height: ${stringify(thumbHeight)}px; top: ${stringify(thumbTop)}px`)}></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      viewport,
      contents,
      hideAfter,
      alwaysVisible,
      initiallyVisible,
      margin,
      vTrackIn,
      vTrackOut,
      vThumbIn,
      vThumbOut
    });
  });
}
function Svroller($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let width = fallback($$props["width"], "10rem");
    let height = fallback($$props["height"], "10rem");
    let hideAfter = fallback($$props["hideAfter"], 1e3);
    let alwaysVisible = fallback($$props["alwaysVisible"], false);
    let initiallyVisible = fallback($$props["initiallyVisible"], false);
    let margin = fallback($$props["margin"], () => ({}), true);
    let vTrackIn = fallback($$props["vTrackIn"], (node) => fade(node, { duration: 100 }));
    let vTrackOut = fallback($$props["vTrackOut"], (node) => fade(node, { duration: 300 }));
    let vThumbIn = fallback($$props["vThumbIn"], (node) => fade(node, { duration: 100 }));
    let vThumbOut = fallback($$props["vThumbOut"], (node) => fade(node, { duration: 300 }));
    let viewport;
    let contents;
    $$renderer2.push(`<div class="svlr-wrapper svelte-qaimor"${attr_style(`width: ${stringify(width)}; height: ${stringify(height)}`)}><div class="svlr-viewport svelte-qaimor"${attr_style(`width: ${stringify(width)}; height: ${stringify(height)}`)}><div class="svlr-contents"><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div></div> `);
    Svrollbar($$renderer2, {
      viewport,
      contents,
      hideAfter,
      alwaysVisible,
      initiallyVisible,
      margin,
      vTrackIn,
      vTrackOut,
      vThumbIn,
      vThumbOut
    });
    $$renderer2.push(`<!----></div>`);
    bind_props($$props, {
      width,
      height,
      hideAfter,
      alwaysVisible,
      initiallyVisible,
      margin,
      vTrackIn,
      vTrackOut,
      vThumbIn,
      vThumbOut
    });
  });
}
export {
  Svroller as S
};
