import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Spinner($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "type", "size", "color"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let type = fallback($$props["type"], "border");
    let size = fallback($$props["size"], "");
    let color = fallback($$props["color"], "");
    classes = classnames(className, size ? `spinner-${type}-${size}` : false, `spinner-${type}`, color ? `text-${color}` : false);
    $$renderer2.push(`<div${attributes({ ...$$restProps, role: "status", class: clsx(classes) })}><span class="visually-hidden"><!--[-->`);
    slot($$renderer2, $$props, "default", {}, () => {
      $$renderer2.push(`Loading...`);
    });
    $$renderer2.push(`<!--]--></span></div>`);
    bind_props($$props, { class: className, type, size, color });
  });
}
export {
  Spinner as S
};
