import { al as attr_style, ad as attr_class, a0 as slot, a9 as bind_props, a6 as fallback, ac as attr } from "./index2.js";
function Thumb($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let pos = $$props["pos"];
    let active;
    $$renderer2.push(`<div class="thumb svelte-1a833u9"${attr_style(`left: ${pos * 100}%;`)}><div${attr_class("thumb-content svelte-1a833u9", void 0, { "active": active })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div></div>`);
    bind_props($$props, { pos });
  });
}
function Slider($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let progress;
    let name = fallback($$props["name"], () => [], true);
    let range = fallback($$props["range"], false);
    let min = fallback($$props["min"], 0);
    let max = fallback($$props["max"], 100);
    let step = fallback($$props["step"], 1);
    let value = fallback($$props["value"], () => [min, max], true);
    let pos;
    let order = fallback($$props["order"], false);
    function setValue(pos2) {
      const offset = min % step;
      const width = max - min;
      value = pos2.map((v) => min + v * width).map((v) => Math.round((v - offset) / step) * step + offset);
    }
    function setPos(value2) {
      pos = value2.map((v) => Math.min(Math.max(v, min), max)).map((v) => (v - min) / (max - min));
    }
    function clamp() {
      setPos(value);
      setValue(pos);
    }
    setPos(value);
    clamp();
    progress = `
    left: ${range ? Math.min(pos[0], pos[1]) * 100 : 0}%;
    right: ${100 - Math.max(pos[0], range ? pos[1] : pos[0]) * 100}%;
  `;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<input type="number"${attr("value", value[0])}${attr("name", name[0])} class="svelte-1ss4npm"/> `);
      if (range) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<input type="number"${attr("value", value[1])}${attr("name", name[1])} class="svelte-1ss4npm"/>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <div class="track svelte-1ss4npm"><div class="progress svelte-1ss4npm"${attr_style(progress)}></div> `);
      Thumb($$renderer3, {
        get pos() {
          return pos[0];
        },
        set pos($$value) {
          pos[0] = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<!--[-->`);
          slot($$renderer4, $$props, "left", {}, () => {
            $$renderer4.push(`<!--[-->`);
            slot($$renderer4, $$props, "default", {}, () => {
              $$renderer4.push(`<div class="thumb svelte-1ss4npm"></div>`);
            });
            $$renderer4.push(`<!--]-->`);
          });
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (range) {
        $$renderer3.push("<!--[-->");
        Thumb($$renderer3, {
          get pos() {
            return pos[1];
          },
          set pos($$value) {
            pos[1] = $$value;
            $$settled = false;
          },
          children: ($$renderer4) => {
            $$renderer4.push(`<!--[-->`);
            slot($$renderer4, $$props, "right", {}, () => {
              $$renderer4.push(`<!--[-->`);
              slot($$renderer4, $$props, "default", {}, () => {
                $$renderer4.push(`<div class="thumb svelte-1ss4npm"></div>`);
              });
              $$renderer4.push(`<!--]-->`);
            });
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { name, range, min, max, step, value, order });
  });
}
export {
  Slider as S
};
