import { a6 as fallback, aa as escape_html, ag as ensure_array_like, ad as attr_class, ae as stringify, ac as attr, a8 as clsx, a9 as bind_props } from "./index2.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { S as Svroller } from "./Svroller.js";
import { C as CardExtra } from "./CardExtra.js";
import moment from "moment";
function SingleChat($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const author = "author@mail.com";
    let singleContent = $$props["singleContent"];
    let userNames = $$props["userNames"];
    let singleComponent = fallback($$props["singleComponent"], false);
    let groupChat = fallback($$props["groupChat"], false);
    Card($$renderer2, {
      class: "border-0",
      children: ($$renderer3) => {
        if (!singleComponent) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div class="chat-header"><div class="media chat-name align-items-center"><div class="media-body align-self-center"><h5 class="mb-0 fw-500 mb-2">${escape_html(userNames)}</h5> `);
          if (!groupChat) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="media-body__content d-flex align-items-center"><span class="badge-dot dot-success me-1"></span> <small class="d-flex color-light fs-12 text-capitalize">active now</small></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div></div> `);
          if (groupChat) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="image-group"><ul class="d-flex"><li><img src="/img/author/1.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/2.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/3.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/4.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><img src="/img/author/1.jpg" alt="img" class="wh-30 rounded-circle"/></li> <li><a href="#" class="bg-primary rounded-circle wh-30 color-white content-center fs-10 fw-500">20+</a></li> <li><a href="#" class="border rounded-circle wh-30 color-extra-light content-center"><img class="svg" alt="" src="/img/svg/plus.svg"/></a></li></ul></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!----></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
          CardHeader($$renderer3, {
            class: "border-0",
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Chat</h6> `);
              CardExtra($$renderer4);
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
        }
        $$renderer3.push(`<!--]--> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chat mini-chat"><div class="chat-body bg-white radius-xl">`);
            Svroller($$renderer4, {
              width: "100%",
              height: "100%",
              initiallyVisible: true,
              children: ($$renderer5) => {
                $$renderer5.push(`<div class="chat-box chat-box--big"><!--[-->`);
                const each_array = ensure_array_like(singleContent);
                for (let i = 0, $$length = each_array.length; i < $$length; i++) {
                  let item = each_array[i];
                  $$renderer5.push(`<div${attr_class(`flex-1 mb-15 ${stringify(author !== item.email ? "incoming-chat" : "justify-content-end d-flex outgoing-chat")}`)}><div class="chat-text-box"><div class="media">`);
                  if (author !== item.email) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`<div class="chat-text-box__photo"><img${attr("src", `/img/${stringify(item.img)}`)} class="align-self-start me-15 wh-46" alt="img"/></div>`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                  }
                  $$renderer5.push(`<!--]--> <div class="media-body"><div class="chat-text-box__content"><div${attr_class(`chat-text-box__title d-flex align-items-center ${stringify(author === item.email ? "justify-content-end" : "")}`)}>`);
                  if (author !== item.email) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`<h6 class="fs-14 fw-500">${escape_html(typeof item.userName === "undefined" ? userNames : item.userName)}</h6>`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                  }
                  $$renderer5.push(`<!--]--> <span${attr_class(`chat-text-box__time fs-12 color-light fw-400 ${stringify(author !== item.email ? "ms-sm-25 " : "")}`)}>${escape_html(moment(item.time).format("MM-DD-YYYY") === moment().format("MM-DD-YYYY") ? moment(i).format("hh:mm A") : moment(i).format("LL"))}</span></div> <div${attr_class(`d-flex align-items-center ${stringify(author !== item.email ? "mt-10" : "justify-content-end")}`)}><div${attr_class(`chat-text-box__subtitle p-20 ${stringify(author !== item.email ? "bg-secondary" : "bg-deep")}`)}><p${attr_class(clsx(author !== item.email ? "color-white" : "color-dark"))}>${escape_html(item.content)}</p></div></div></div></div></div></div></div>`);
                }
                $$renderer5.push(`<!--]--></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> <div class="chat-footer"><div class="chat-type-text"><div class="pt-0 outline-0 pb-0 pe-0 ps-0 rounded-0 position-relative d-flex align-items-center" tabindex="-1"><div class="d-flex justify-content-between align-items-center w-100 flex-wrap"><div class="bg-lighters flex-1 d-flex align-items-center chat-type-text__write ms-0"><a href="#"><img class="svg" src="/img/svg/smile.svg" alt="smile"/></a> <input class="form-control border-0 bg-transparent box-shadow-none" placeholder="Type your message..."/></div> <div class="chat-type-text__btn">`);
            if (!singleComponent) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<button type="button" class="border-0 btn-deep color-light wh-50 p-10 rounded-circle"><img class="svg" alt="" src="/img/svg/image.svg"/></button> <button type="button" class="border-0 btn-deep color-light wh-50 p-10 rounded-circle"><img class="svg" alt="" src="/img/svg/paperclip.svg"/></button>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> <button type="button" class="border-0 bg-secondary wh-50 p-10 rounded-circle color-svgDF-white"><img class="svg" alt="" src="/img/svg/send.svg"/></button></div></div></div></div></div></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    bind_props($$props, { singleContent, userNames, singleComponent, groupChat });
  });
}
export {
  SingleChat as S
};
