import { a6 as fallback, ag as ensure_array_like, ac as attr, ae as stringify, aa as escape_html, a9 as bind_props } from "./index2.js";
function Sellers($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  let tableHead = fallback($$props["tableHead"], true);
  $$renderer.push(`<div class="selling-table-wrap selling-table-wrap--source table-responsive svelte-qaslba"><table class="table table--default table-borderless svelte-qaslba">`);
  if (tableHead) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<thead class="svelte-qaslba"><tr class="svelte-qaslba"><th class="svelte-qaslba">Seller name</th><th class="svelte-qaslba">Company</th><th class="svelte-qaslba">Product</th><th class="svelte-qaslba">Revenue</th><th class="svelte-qaslba">Status</th></tr></thead>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--><tbody class="svelte-qaslba"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-qaslba"><td class="svelte-qaslba"><div class="selling-product-img d-flex align-items-center svelte-qaslba"><div class="selling-product-img-wrapper order-bg-opacity-primary align-items-end svelte-qaslba"><img class="img-fluid svelte-qaslba"${attr("src", `/img/sellers/${stringify(data.img)}`)} alt="img"/></div> <span class="svelte-qaslba">${escape_html(data.name)}</span></div></td><td class="svelte-qaslba">${escape_html(data.company)}</td><td class="svelte-qaslba">${escape_html(data.product)}</td><td class="svelte-qaslba">${escape_html(data.revenue)}</td><td class="svelte-qaslba">${escape_html(data.status)}</td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod, tableHead });
}
export {
  Sellers as S
};
