import { a6 as fallback, ac as attr, ad as attr_class, a9 as bind_props, ae as stringify } from "./index2.js";
function SearchIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-search ${stringify(customClass)}`)}><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
export {
  SearchIcon as S
};
