import "clsx";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as Chartjs } from "./Chartjs.js";
import { d as doughnutData } from "./dashboardChartContent.js";
/* empty css                                            */
function ProfitGrowth($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let profitGrowthDataset;
    let profitGrowthData = doughnutData.profitGrowth;
    let primaryColor;
    let primaryColorRGB;
    let infoColor;
    let infoColorRGB;
    const tooltip = {
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    const scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#E3E6EF",
          borderDash: [3, 3],
          zeroLineColor: "#E3E6EF",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...profitGrowthData.orders),
          stepSize: 20,
          min: 0,
          padding: 20,
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          zeroLineColor: "#E3E6EF",
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    profitGrowthDataset = [
      {
        data: profitGrowthData.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        label: "Orders",
        average: "50.8",
        maxBarThickness: 10,
        barThickness: 16,
        percent: 49
      },
      {
        data: profitGrowthData.sales,
        backgroundColor: `rgba(${infoColorRGB},0.5)`,
        hoverBackgroundColor: infoColor,
        label: "Sales",
        average: "$28k",
        maxBarThickness: 10,
        barThickness: 16,
        percent: 60
      }
    ];
    Card($$renderer2, {
      class: "border-0 profit-growth h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="chartLine-po-details__overview-content w-100"><div class="chartLine-po-details__content d-flex flex-wrap justify-content-between"><div class="chartLine-po-details__titlebar"><h1>Profit Growth</h1></div></div> <div class="chartLine-po-details__time"><h5>$8,550</h5> <span class="color-success"><i class="uil uil-arrow-up"></i> <strong>25.36%</strong></span></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="cashflow-chart"><ul class="legend-static mt-1 d-flex justify-content-center"><li class="custom-label"><span class="bg-secondary"></span>Order</li> <li class="custom-label"><span class="bg-info"></span>Sale</li></ul> `);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                className: "ninjadash-profit-growth",
                id: "ninjadash-profit-growth",
                labels: profitGrowthData.labels,
                datasets: profitGrowthDataset,
                type: "bar",
                tooltip,
                scales,
                height: 150
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function SalesOverview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    Card($$renderer2, {
      class: "border-0 h-100",
      children: ($$renderer3) => {
        {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
  });
}
export {
  ProfitGrowth as P,
  SalesOverview as S
};
