import { ag as ensure_array_like, ad as attr_class, ae as stringify, aa as escape_html, a8 as clsx } from "./index2.js";
import { t as totalChartData } from "./totalSaleChart.js";
import { C as Chartjs } from "./Chartjs.js";
import "clsx";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as CardExtra } from "./CardExtra.js";
function TotalLineChart($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let totalChartDataset, scales, layout;
    let primaryColor;
    let primaryColorRGB;
    let infoColor;
    let infoColorRGB;
    const tooltip = {
      usePointStyle: true,
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    totalChartDataset = [
      {
        data: totalChartData.orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        borderColor: primaryColor,
        label: "Orders",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        maxBarThickness: 10,
        barThickness: 12
      },
      {
        data: totalChartData.sales,
        backgroundColor: `rgba(${infoColorRGB},0.5)`,
        hoverBackgroundColor: infoColor,
        borderColor: infoColor,
        label: "Sales",
        total: "5,550",
        prefix: "$",
        growthRate: "15",
        growthStatus: "down",
        labelType: "info",
        maxBarThickness: 10,
        barThickness: 12
      }
    ];
    scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          stepSize: 20,
          padding: 15,
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        border: { display: false },
        offset: true,
        grid: {
          display: false,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    layout = { padding: { left: 0, right: 0, top: 0, bottom: 0 } };
    Card($$renderer2, {
      class: "border-0 chartLine-po-details",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 pb-md-0 pb-20",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales Reports</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="label-detailed"><!--[-->`);
            const each_array = ensure_array_like(totalChartDataset);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              $$renderer4.push(`<div class="label-detailed__single"><span${attr_class(`label-detailed__type label-detailed__type--${stringify(item.labelType)}`)}>${escape_html(item.label)}</span> <strong class="label-detailed__total">${escape_html(item.prefix + item.total)}</strong> <span${attr_class(`label-detailed__status ${stringify(item.growthStatus === "up" ? "color-success" : "color-danger")}`)}>`);
              if (item.growthStatus === "up") {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/arrow-success-up.svg"/>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<img class="svg" alt="" src="/img/svg/arrow-danger-down.svg"/>`);
              }
              $$renderer4.push(`<!--]--> <strong>${escape_html(item.growthRate)}%</strong></span></div>`);
            }
            $$renderer4.push(`<!--]--></div> <div class="wp-chart"><div class="parentContainer">`);
            Chartjs($$renderer4, {
              className: "totalLineCharts",
              id: "totalLineCharts",
              labels: totalChartData.labels,
              datasets: totalChartDataset,
              type: "line",
              tooltip,
              scales,
              layout,
              height: 105
            });
            $$renderer4.push(`<!----></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function SalesGrowth($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesGrowthset, scales, responsive;
    let currentTab = "today";
    let primaryColor;
    let primaryColorRGB;
    let infoColor;
    let infoColorRGB;
    const tooltip = {
      callbacks: {
        label(t) {
          const dstLabel = t.dataset.label;
          const { formattedValue } = t;
          return `  ${formattedValue} ${dstLabel}`;
        },
        labelColor(t) {
          return {
            backgroundColor: t.dataset.hoverBackgroundColor,
            borderColor: "transparent"
          };
        }
      }
    };
    let salesGrowths = {
      today: {
        labels: ["Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri"],
        orders: [35, 55, 25, 60, 42, 80, 35],
        sales: [10, 30, 8, 30, 22, 38, 45]
      },
      week: {
        labels: ["1-2", "2-3", "3-4", "4-5", "5-6", "6-7", "7-8"],
        orders: [12, 34, 76, 23, 48, 34, 78],
        sales: [34, 25, 34, 8, 45, 65, 18]
      },
      month: {
        labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul"],
        orders: [53, 55, 52, 6, 24, 8, 56],
        sales: [16, 54, 80, 37, 76, 78, 54]
      }
    };
    salesGrowthset = [
      {
        data: salesGrowths[currentTab].orders,
        backgroundColor: `rgba(${primaryColorRGB},0.5)`,
        hoverBackgroundColor: primaryColor,
        label: "Target",
        total: "8,550",
        prefix: "$",
        growthRate: "25",
        growthStatus: "up",
        labelType: "primary",
        maxBarThickness: 10,
        barThickness: 12
      },
      {
        data: salesGrowths[currentTab].sales,
        backgroundColor: `rgba(${infoColorRGB},0.5)`,
        hoverBackgroundColor: infoColor,
        label: "Total Sales",
        total: "5,550",
        prefix: "$",
        growthRate: "15",
        growthStatus: "down",
        labelType: "info",
        maxBarThickness: 10,
        barThickness: 12
      }
    ];
    scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          borderWidth: 0.5
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          max: Math.max(...salesGrowths[currentTab].sales),
          stepSize: 20,
          padding: 15,
          callback(value, index, ticks) {
            return value + "k";
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: false,
          zeroLineWidth: 0,
          drawTicks: true,
          drawBorder: false,
          color: "transparent",
          z: 1
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    responsive = [];
    Card($$renderer2, {
      class: "border-0 cashflowChart2",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 px-25",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales Growth</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="cashflow-chart"><div class="label-detailed label-detailed--two svelte-1afx7rr"><!--[-->`);
            const each_array = ensure_array_like(salesGrowthset);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let item = each_array[$$index];
              $$renderer4.push(`<div class="label-detailed__single svelte-1afx7rr"><strong class="label-detailed__total svelte-1afx7rr">${escape_html(item.prefix + item.total)}</strong> <span${attr_class(`label-detailed__status ${stringify(item.growthStatus === "up" ? "color-success" : "color-danger")}`, "svelte-1afx7rr")}>`);
              if (item.growthStatus === "up") {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<img class="svg svelte-1afx7rr" alt="" src="/img/svg/arrow-success-up.svg"/>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<img class="svg svelte-1afx7rr" alt="" src="/img/svg/arrow-danger-down.svg"/>`);
              }
              $$renderer4.push(`<!--]--> <strong class="svelte-1afx7rr">${escape_html(item.growthRate)}%</strong></span></div>`);
            }
            $$renderer4.push(`<!--]--></div> `);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                className: "salesChart",
                id: "salesCharts",
                labels: salesGrowths[currentTab].labels,
                datasets: salesGrowthset,
                type: "bar",
                tooltip,
                scales,
                responsive,
                height: 188
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
export {
  SalesGrowth as S,
  TotalLineChart as T
};
