import { a6 as fallback, ag as ensure_array_like, aa as escape_html, a9 as bind_props, ad as attr_class, a8 as clsx } from "./index2.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import { R as Row, a as Col } from "./Row.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as CardExtra } from "./CardExtra.js";
import { V as VectorMap } from "./VectorMap.js";
import { s as salesData } from "./salesByLocation2.js";
function SalesByLocation($$renderer, $$props) {
  let salesData2;
  let period = "today";
  let dataPeriod = fallback($$props["dataPeriod"], () => salesData2[period], true);
  $$renderer.push(`<div class="table-responsive table-top-regions svelte-1o47rt0"><table class="table table--default table-borderless svelte-1o47rt0"><thead class="svelte-1o47rt0"><tr><th class="svelte-1o47rt0">Top region</th><th class="svelte-1o47rt0">order</th><th class="svelte-1o47rt0">Revenue</th></tr></thead><tbody class="svelte-1o47rt0"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-1o47rt0"><td class="svelte-1o47rt0">${escape_html(data.location)}</td><td class="svelte-1o47rt0">${escape_html(data.order)}</td><td class="svelte-1o47rt0">${escape_html(data.revenue)}</td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
function SalesByLocation_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let dataPeriod;
    let currentTab = "today";
    function changeData(data) {
      dataPeriod = salesData[data];
      currentTab = data;
    }
    changeData("today");
    Card($$renderer2, {
      class: "border-0 sales-location h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales by Location</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx(currentTab === "today" ? "active" : ""))}>Today</a></li> <li><a href="#"${attr_class(clsx(currentTab === "week" ? "active" : ""))}>Week</a></li> <li><a href="#"${attr_class(clsx(currentTab === "month" ? "active" : ""))}>Month</a></li> <li><a href="#"${attr_class(clsx(currentTab === "year" ? "active" : ""))}>Year</a></li></ul> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!----></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            Row($$renderer4, {
              children: ($$renderer5) => {
                Col($$renderer5, {
                  md: 6,
                  children: ($$renderer6) => {
                    SalesByLocation($$renderer6, { dataPeriod });
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----> `);
                Col($$renderer5, {
                  md: 6,
                  class: "d-flex align-items-center justify-content-center",
                  children: ($$renderer6) => {
                    $$renderer6.push(`<div class="regions-svg">`);
                    VectorMap($$renderer6, {});
                    $$renderer6.push(`<!----></div>`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
export {
  SalesByLocation_1 as S
};
