import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { i as isObject, g as getColumnSizeClass, c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Col($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "xs", "sm", "md", "lg", "xl", "xxl"]);
  $$renderer.component(($$renderer2) => {
    let className = fallback($$props["class"], "");
    let xs = fallback($$props["xs"], void 0);
    let sm = fallback($$props["sm"], void 0);
    let md = fallback($$props["md"], void 0);
    let lg = fallback($$props["lg"], void 0);
    let xl = fallback($$props["xl"], void 0);
    let xxl = fallback($$props["xxl"], void 0);
    const colClasses = [];
    const lookup = { xs, sm, md, lg, xl, xxl };
    Object.keys(lookup).forEach((colWidth) => {
      const columnProp = lookup[colWidth];
      if (!columnProp && columnProp !== "") {
        return;
      }
      const isXs = colWidth === "xs";
      if (isObject(columnProp)) {
        const colSizeInterfix = isXs ? "-" : `-${colWidth}-`;
        const colClass = getColumnSizeClass(isXs, colWidth, columnProp.size);
        if (columnProp.size || columnProp.size === "") {
          colClasses.push(colClass);
        }
        if (columnProp.push) {
          colClasses.push(`push${colSizeInterfix}${columnProp.push}`);
        }
        if (columnProp.pull) {
          colClasses.push(`pull${colSizeInterfix}${columnProp.pull}`);
        }
        if (columnProp.offset) {
          colClasses.push(`offset${colSizeInterfix}${columnProp.offset}`);
        }
        if (columnProp.order) {
          colClasses.push(`order${colSizeInterfix}${columnProp.order}`);
        }
      } else {
        colClasses.push(getColumnSizeClass(isXs, colWidth, columnProp));
      }
    });
    if (!colClasses.length) {
      colClasses.push("col");
    }
    if (className) {
      colClasses.push(className);
    }
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(colClasses.join(" ")) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, xs, sm, md, lg, xl, xxl });
  });
}
function Container($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "sm", "md", "lg", "xl", "xxl", "fluid"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let sm = fallback($$props["sm"], void 0);
    let md = fallback($$props["md"], void 0);
    let lg = fallback($$props["lg"], void 0);
    let xl = fallback($$props["xl"], void 0);
    let xxl = fallback($$props["xxl"], void 0);
    let fluid = fallback($$props["fluid"], false);
    classes = classnames(className, {
      "container-sm": sm,
      "container-md": md,
      "container-lg": lg,
      "container-xl": xl,
      "container-xxl": xxl,
      "container-fluid": fluid,
      container: !sm && !md && !lg && !xl && !xxl && !fluid
    });
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, sm, md, lg, xl, xxl, fluid });
  });
}
function Row($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "noGutters", "form", "cols", "inner"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let noGutters = fallback($$props["noGutters"], false);
    let form = fallback($$props["form"], false);
    let cols = fallback($$props["cols"], 0);
    let inner = fallback($$props["inner"], void 0);
    function getCols(cols2) {
      const colsValue = parseInt(cols2);
      if (!isNaN(colsValue)) {
        if (colsValue > 0) {
          return [`row-cols-${colsValue}`];
        }
      } else if (typeof cols2 === "object") {
        return ["xs", "sm", "md", "lg", "xl"].map((colWidth) => {
          const isXs = colWidth === "xs";
          const colSizeInterfix = isXs ? "-" : `-${colWidth}-`;
          const value = cols2[colWidth];
          if (typeof value === "number" && value > 0) {
            return `row-cols${colSizeInterfix}${value}`;
          }
          return null;
        }).filter((value) => !!value);
      }
      return [];
    }
    classes = classnames(className, noGutters ? "gx-0" : null, form ? "form-row" : "row", ...getCols(cols));
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, noGutters, form, cols, inner });
  });
}
export {
  Container as C,
  Row as R,
  Col as a
};
