import { ad as attr_class, a8 as clsx, ag as ensure_array_like, aa as escape_html, ae as stringify } from "./index2.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as Chartjs } from "./Chartjs.js";
import { c as chartLinearGradient } from "./utilities.js";
import { C as CardExtra } from "./CardExtra.js";
import "clsx";
function SalesRevenue($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let salesRevenueDatasets;
    let revenue = "today";
    let primaryColor;
    let primaryColorRGB;
    let salesRevenue = {
      today: {
        users: [20, 36, 25, 50, 40, 55, 40, 75, 35, 40, 35, 58],
        labels: [
          "2h",
          "4h",
          "6h",
          "8h",
          "10h",
          "12h",
          "14h",
          "16h",
          "18h",
          "20h",
          "22h",
          "24h"
        ]
      },
      week: {
        users: [40, 30, 35, 20, 25, 40, 35],
        labels: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
      },
      months: {
        users: [45, 20, 35, 32, 50, 45, 55, 71, 36, 65, 55, 75],
        labels: [
          "Jan",
          "Feb",
          "Mar",
          "App",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep",
          "Nov",
          "Oct",
          "Dec"
        ]
      }
    };
    const scales = {
      y: {
        border: { display: false },
        grid: {
          color: "#485e9029",
          borderDash: [3, 3],
          zeroLineColor: "#485e9029",
          zeroLineWidth: 1,
          zeroLineBorderDash: [3, 3],
          drawTicks: false,
          drawBorder: false,
          zeroLineWidth: 3,
          borderWidth: 0
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474",
          Min: 0,
          Max: 80,
          stepSize: 20,
          padding: 15,
          callback(label) {
            return `${label}k`;
          }
        }
      },
      x: {
        border: { display: false },
        grid: {
          display: true,
          zeroLineWidth: 2,
          zeroLineColor: "transparent",
          color: "transparent",
          z: 1,
          tickMarkLength: 10,
          drawTicks: true,
          drawBorder: false
        },
        ticks: {
          beginAtZero: true,
          font: { size: 14, family: "'Jost', sans-serif" },
          color: "#747474"
        }
      }
    };
    salesRevenueDatasets = [
      {
        data: salesRevenue[revenue].users,
        borderColor: primaryColor,
        borderWidth: 3,
        fill: true,
        backgroundColor: () => chartLinearGradient(document.getElementById("ninjadash-sales-revenue"), 300, {
          start: `rgba(${primaryColorRGB},0.4)`,
          end: "rgba(255,255,255,0.05)"
        }),
        label: "Current period",
        pointStyle: "circle",
        pointRadius: "0",
        hoverRadius: "6",
        pointBorderColor: "#fff",
        pointBackgroundColor: primaryColor,
        hoverBorderWidth: 2,
        amount: "$7,596",
        amountClass: "current-amount",
        lineTension: 0.5
      }
    ];
    Card($$renderer2, {
      class: "sales-revenue border-0",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Sales Revenue</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>Month</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="wp-chart">`);
            {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="parentContainer">`);
              Chartjs($$renderer4, {
                type: "line",
                id: "ninjadash-sales-revenue",
                className: "ninjadash-sales-revenue",
                labels: salesRevenue[revenue].labels,
                datasets: salesRevenueDatasets,
                scales,
                height: 120
              });
              $$renderer4.push(`<!----></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
function RevenueGenerated($$renderer) {
  let height = 250;
  let scales = { y: { display: false }, x: { display: false } };
  let options = {
    hoverOffset: 3,
    maintainAspectRatio: false,
    responsive: false,
    borderColor: "#fff",
    plugins: { legend: { display: false }, labels: { display: false } },
    animation: { animateScale: true, animateRotate: true }
  };
  let dataStats = [
    {
      icons: ["facebook"],
      labels: ["Facebook"],
      revenue: [4621],
      color: "#8231D3"
    },
    {
      icons: ["twitter"],
      labels: ["Twitter"],
      revenue: [4245],
      color: "#00AAFF"
    },
    {
      icons: ["google"],
      labels: ["Google"],
      revenue: [12112],
      color: "#5840FF"
    }
  ];
  let labels = [];
  let revenues = [];
  let colors = [];
  dataStats.forEach((elm) => {
    labels.push(elm.labels);
    revenues.push(elm.revenue);
    colors.push(elm.color);
  });
  let chartData = [
    {
      label: "Revenue Generated",
      data: revenues,
      backgroundColor: colors
    }
  ];
  let tooltip = {
    backgroundColor: "#FFF",
    titleFontSize: 16,
    titleFontColor: "#0066ff",
    bodyFontColor: "#000",
    bodyFontSize: 14,
    displayColors: false,
    callbacks: {
      title(t) {
        console.log(t);
      }
    }
  };
  Card($$renderer, {
    class: "border-0 h-100",
    children: ($$renderer2) => {
      CardHeader($$renderer2, {
        class: "px-0 border-0 pb-md-10 pt-md-10 pb-0 px-25",
        children: ($$renderer3) => {
          $$renderer3.push(`<h6>Source Of Revenue Generated</h6> `);
          CardExtra($$renderer3);
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      CardBody($$renderer2, {
        class: "p-0 px-25",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="chart-content revenuePieChart--wrapper px-0">`);
          Chartjs($$renderer3, {
            type: "pie",
            className: "revenuePieChart",
            id: "revenuePieChart",
            labels,
            options,
            scales,
            datasets: chartData,
            tooltip,
            height
          });
          $$renderer3.push(`<!----> <div class="chart-content__details"><!--[-->`);
          const each_array = ensure_array_like(dataStats);
          for (let $$index_3 = 0, $$length = each_array.length; $$index_3 < $$length; $$index_3++) {
            let { icons, labels: labels2, revenue } = each_array[$$index_3];
            $$renderer3.push(`<div class="chart-content__single"><!--[-->`);
            const each_array_1 = ensure_array_like(icons);
            for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
              let icon = each_array_1[$$index];
              $$renderer3.push(`<span${attr_class(`icon color-${stringify(icon)}`)}>`);
              if (icon === "facebook") {
                $$renderer3.push("<!--[-->");
                $$renderer3.push(`<span class="uil uil-facebook-f"></span>`);
              } else if (icon === "twitter") {
                $$renderer3.push("<!--[1-->");
                $$renderer3.push(`<span class="uil uil-twitter"></span>`);
              } else if (icon === "google") {
                $$renderer3.push("<!--[2-->");
                $$renderer3.push(`<img class="svg" alt="" src="/img/svg/google-customIcon.svg"/>`);
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]--></span>`);
            }
            $$renderer3.push(`<!--]--> <!--[-->`);
            const each_array_2 = ensure_array_like(labels2);
            for (let $$index_1 = 0, $$length2 = each_array_2.length; $$index_1 < $$length2; $$index_1++) {
              let label = each_array_2[$$index_1];
              $$renderer3.push(`<span class="label">${escape_html(label)}</span>`);
            }
            $$renderer3.push(`<!--]--> <!--[-->`);
            const each_array_3 = ensure_array_like(revenue);
            for (let $$index_2 = 0, $$length2 = each_array_3.length; $$index_2 < $$length2; $$index_2++) {
              let data = each_array_3[$$index_2];
              $$renderer3.push(`<span class="data">$${escape_html(data)}</span>`);
            }
            $$renderer3.push(`<!--]--></div>`);
          }
          $$renderer3.push(`<!--]--></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
}
export {
  RevenueGenerated as R,
  SalesRevenue as S
};
