import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a0 as slot, a7 as attributes, ae as stringify, a8 as clsx, ad as attr_class, al as attr_style, ac as attr, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Progress($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "animated",
    "bar",
    "barClassName",
    "class",
    "color",
    "max",
    "multi",
    "striped",
    "theme",
    "value"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes, progressBarClasses, percent;
    let animated = fallback($$props["animated"], false);
    let bar = fallback($$props["bar"], false);
    let barClassName = fallback($$props["barClassName"], "");
    let className = fallback($$props["class"], "");
    let color = fallback($$props["color"], "");
    let max = fallback($$props["max"], 100);
    let multi = fallback($$props["multi"], false);
    let striped = fallback($$props["striped"], false);
    let theme = fallback($$props["theme"], null);
    let value = fallback($$props["value"], 0);
    classes = classnames(className, "progress");
    progressBarClasses = classnames("progress-bar", bar ? className || barClassName : barClassName, animated ? "progress-bar-animated" : null, color ? `text-bg-${color}` : null, striped || animated ? "progress-bar-striped" : null);
    percent = parseInt(value, 10) / parseInt(max, 10) * 100;
    if (bar) {
      $$renderer2.push("<!--[-->");
      if (multi) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div${attributes({
          ...$$restProps,
          class: clsx(progressBarClasses),
          style: `width: ${stringify(percent)}%`,
          "data-bs-theme": theme,
          role: "progressbar",
          "aria-valuenow": value,
          "aria-valuemin": "0",
          "aria-valuemax": max
        })}><!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]--></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div${attributes({
        ...$$restProps,
        "data-bs-theme": theme,
        class: clsx(classes)
      })}>`);
      if (multi) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<div${attr_class(clsx(progressBarClasses))}${attr_style(`width: ${stringify(percent)}%`)}${attr("data-bs-theme", theme)} role="progressbar"${attr("aria-valuenow", value)} aria-valuemin="0"${attr("aria-valuemax", max)}><!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]--></div>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      animated,
      bar,
      barClassName,
      class: className,
      color,
      max,
      multi,
      striped,
      theme,
      value
    });
  });
}
export {
  Progress as P
};
