import { ag as ensure_array_like, ad as attr_class, ae as stringify, aa as escape_html } from "./index2.js";
import "clsx";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as CardExtra } from "./CardExtra.js";
function PerformanceOverview($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const labels = ["Target", "Completed", "In Progress"];
    Card($$renderer2, {
      class: "border-0 h-100 perfomance-o",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "border-0 pb-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Performance Overview</h6> `);
            CardExtra($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "pt-sm-25 pb-25 pt-15",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="performance-chart-wrap svelte-18tk3gl"><div class="performance-chart svelte-18tk3gl"><div></div></div> <div class="performance-chart-labels svelte-18tk3gl"><ul class="svelte-18tk3gl"><!--[-->`);
            const each_array = ensure_array_like(labels);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let label = each_array[$$index];
              $$renderer4.push(`<li${attr_class(`label-${stringify(label.replace(/\s+/g, "-").toLowerCase())}`, "svelte-18tk3gl")}>${escape_html(label)}</li>`);
            }
            $$renderer4.push(`<!--]--></ul></div></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
export {
  PerformanceOverview as P
};
