import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, ad as attr_class, a0 as slot, a9 as bind_props, aa as escape_html } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Pagination($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["ariaLabel", "class", "listClassName", "size", "theme"]);
  $$renderer.component(($$renderer2) => {
    let classes, listClasses;
    let ariaLabel = fallback($$props["ariaLabel"], "pagination");
    let className = fallback($$props["class"], "");
    let listClassName = fallback($$props["listClassName"], "");
    let size = fallback($$props["size"], "");
    let theme = fallback($$props["theme"], null);
    classes = classnames(className);
    listClasses = classnames(listClassName, "pagination", { [`pagination-${size}`]: !!size });
    $$renderer2.push(`<nav${attributes({
      ...$$restProps,
      class: clsx(classes),
      "aria-label": ariaLabel,
      "data-bs-theme": theme
    })}><ul${attr_class(clsx(listClasses))}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></ul></nav>`);
    bind_props($$props, { ariaLabel, class: className, listClassName, size, theme });
  });
}
function PaginationItem($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "active", "disabled"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    let disabled = fallback($$props["disabled"], false);
    classes = classnames(className, "page-item", { active, disabled });
    $$renderer2.push(`<li${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></li>`);
    bind_props($$props, { class: className, active, disabled });
  });
}
function PaginationLink($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "next",
    "previous",
    "first",
    "last",
    "ariaLabel",
    "href"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes, realLabel;
    let className = fallback($$props["class"], "");
    let next = fallback($$props["next"], false);
    let previous = fallback($$props["previous"], false);
    let first = fallback($$props["first"], false);
    let last = fallback($$props["last"], false);
    let ariaLabel = fallback($$props["ariaLabel"], "");
    let href = fallback($$props["href"], "");
    let defaultAriaLabel;
    let defaultCaret;
    classes = classnames(className, "page-link");
    if (previous) {
      defaultAriaLabel = "Previous";
    } else if (next) {
      defaultAriaLabel = "Next";
    } else if (first) {
      defaultAriaLabel = "First";
    } else if (last) {
      defaultAriaLabel = "Last";
    }
    realLabel = ariaLabel || defaultAriaLabel;
    if (previous) {
      defaultCaret = "‹";
    } else if (next) {
      defaultCaret = "›";
    } else if (first) {
      defaultCaret = "«";
    } else if (last) {
      defaultCaret = "»";
    }
    $$renderer2.push(`<a${attributes({ ...$$restProps, class: clsx(classes), href })}>`);
    if (previous || next || first || last) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<span aria-hidden="true"><!--[-->`);
      slot($$renderer2, $$props, "default", {}, () => {
        $$renderer2.push(`${escape_html(defaultCaret)}`);
      });
      $$renderer2.push(`<!--]--></span> <span class="visually-hidden">${escape_html(realLabel)}</span>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></a>`);
    bind_props($$props, {
      class: className,
      next,
      previous,
      first,
      last,
      ariaLabel,
      href
    });
  });
}
export {
  Pagination as P,
  PaginationItem as a,
  PaginationLink as b
};
