import { ad as attr_class, aa as escape_html, a9 as bind_props, ae as stringify } from "./index2.js";
function OverviewCards($$renderer, $$props) {
  let type = $$props["type"];
  let icon = $$props["icon"];
  let total = $$props["total"];
  let prefix = $$props["prefix"];
  let suffix = $$props["suffix"];
  let label = $$props["label"];
  let growth = $$props["growth"];
  let growthRate = $$props["growthRate"];
  let dataPeriod = $$props["dataPeriod"];
  let cardStyle = $$props["cardStyle"];
  $$renderer.push(`<div${attr_class(`ap-po-details ap-po-details--2 radius-xl d-flex justify-content-between ${cardStyle} ${cardStyle !== "overview-card-shape" ? "" : ""}`, "svelte-105mdsm")}>`);
  if (cardStyle === "overview-card-shape") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<div class="overview-content w-100 svelte-105mdsm"><div class="overview-content__left svelte-105mdsm"><p class="svelte-105mdsm">${escape_html(label)}</p> `);
    if (prefix) {
      $$renderer.push("<!--[-->");
      $$renderer.push(`<h1>${escape_html(prefix + total)}</h1>`);
    } else if (suffix) {
      $$renderer.push("<!--[1-->");
      $$renderer.push(`<h1>${escape_html(total + suffix)}</h1>`);
    } else {
      $$renderer.push("<!--[!-->");
      $$renderer.push(`<h1>${escape_html(total)}</h1>`);
    }
    $$renderer.push(`<!--]--> <span${attr_class(`growth-status ${stringify(growth === "upward" ? "color-success" : "color-danger")}`, "svelte-105mdsm")}>`);
    if (growth === "upward") {
      $$renderer.push("<!--[-->");
      $$renderer.push(`<span class="uil uil-arrow-up svelte-105mdsm"></span>`);
    } else {
      $$renderer.push("<!--[!-->");
      $$renderer.push(`<span class="uil uil-arrow-down svelte-105mdsm"></span>`);
    }
    $$renderer.push(`<!--]--> <strong class="svelte-105mdsm">${escape_html(growthRate)}%</strong> <small class="svelte-105mdsm">${escape_html(dataPeriod)}</small></span></div> <div${attr_class("overview-content__right color-" + type, "svelte-105mdsm")}><div class="overview-content__icon svelte-105mdsm"><i${attr_class("uil uil-" + icon, "svelte-105mdsm")}></i></div></div></div>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<div class="overview-content w-100 svelte-105mdsm"><div class="ap-po-details-content d-flex flex-wrap justify-content-between svelte-105mdsm"><div class="ap-po-details__icon-area svelte-105mdsm"><div${attr_class("svg-icon order-bg-opacity-" + type + " color-" + type, "svelte-105mdsm")}><i${attr_class("uil uil-" + icon, "svelte-105mdsm")}></i></div></div> <div class="ap-po-details__titlebar svelte-105mdsm">`);
    if (prefix) {
      $$renderer.push("<!--[-->");
      $$renderer.push(`<h1>${escape_html(prefix + total)}</h1>`);
    } else if (suffix) {
      $$renderer.push("<!--[1-->");
      $$renderer.push(`<h1>${escape_html(total + suffix)}</h1>`);
    } else {
      $$renderer.push("<!--[!-->");
      $$renderer.push(`<h1>${escape_html(total)}</h1>`);
    }
    $$renderer.push(`<!--]--> <p class="svelte-105mdsm">${escape_html(label)}</p></div></div> <div class="ap-po-details-time svelte-105mdsm"><span${attr_class(`growth-status ${stringify(growth === "upward" ? "color-success" : "color-danger")}`, "svelte-105mdsm")}>`);
    if (growth === "upward") {
      $$renderer.push("<!--[-->");
      $$renderer.push(`<span class="uil uil-arrow-up svelte-105mdsm"></span>`);
    } else {
      $$renderer.push("<!--[!-->");
      $$renderer.push(`<span class="uil uil-arrow-down svelte-105mdsm"></span>`);
    }
    $$renderer.push(`<!--]--> <strong class="svelte-105mdsm">${escape_html(growthRate)}%</strong></span> <small class="svelte-105mdsm">${escape_html(dataPeriod)}</small></div></div>`);
  }
  $$renderer.push(`<!--]--></div>`);
  bind_props($$props, {
    type,
    icon,
    total,
    prefix,
    suffix,
    label,
    growth,
    growthRate,
    dataPeriod,
    cardStyle
  });
}
export {
  OverviewCards as O
};
