import { am as getContext, a6 as fallback, a9 as bind_props, ad as attr_class, a8 as clsx, a0 as slot, aa as escape_html, $ as setContext, ag as ensure_array_like, al as attr_style, a1 as store_get, a3 as unsubscribe_stores } from "./index2.js";
import { o as onDestroy } from "./index-server.js";
import "clsx";
import { w as writable } from "./index.js";
const context = {
  subscribe: null,
  addNotification: null,
  removeNotification: null,
  clearNotifications: null
};
const getNotificationsContext = () => getContext(context);
function Notification($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let item = $$props["item"];
    let notification = fallback($$props["notification"], () => ({}), true);
    let withoutStyles = fallback($$props["withoutStyles"], false);
    const { removeNotification: removeNotification2 } = getNotificationsContext();
    const { id, removeAfter } = notification;
    const removeNotificationHandler = () => removeNotification2(id);
    let timeout = null;
    if (removeAfter) {
      timeout = setTimeout(removeNotificationHandler, removeAfter);
    }
    onDestroy(() => {
      if (removeAfter && timeout) clearTimeout(timeout);
    });
    $$renderer2.push("<!---->");
    item?.($$renderer2, {
      notification,
      withoutStyles,
      onRemove: removeNotificationHandler
    });
    $$renderer2.push(`<!---->`);
    bind_props($$props, { item, notification, withoutStyles });
  });
}
function DefaultNotification($$renderer, $$props) {
  let notification = fallback($$props["notification"], () => ({}), true);
  let withoutStyles = fallback($$props["withoutStyles"], false);
  let onRemove = fallback($$props["onRemove"], null);
  const { text, type } = notification;
  const getClass = (suffix) => {
    const defaultSuffix = suffix ? `-${suffix}` : "";
    const defaultNotificationClass = ` default-notification-style${defaultSuffix}`;
    const defaultNotificationType = type && !suffix ? ` default-notification-${type}` : "";
    return `notification${defaultSuffix}${withoutStyles ? "" : defaultNotificationClass}${defaultNotificationType}`;
  };
  if (text) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<div${attr_class(clsx(getClass()), "svelte-oocfh4")} role="status" aria-live="polite"><div${attr_class(clsx(getClass("content")), "svelte-oocfh4")}><!--[-->`);
    slot($$renderer, $$props, "default", {}, () => {
      $$renderer.push(`${escape_html(text)}`);
    });
    $$renderer.push(`<!--]--></div> <button${attr_class(clsx(getClass("button")), "svelte-oocfh4")} aria-label="delete notification">×</button></div>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]-->`);
  bind_props($$props, { notification, withoutStyles, onRemove });
}
const positions = [
  "top-left",
  "top-center",
  "top-right",
  "bottom-left",
  "bottom-center",
  "bottom-right"
];
const addNotification = (notification, store2) => {
  if (!notification) return;
  const { update } = store2;
  const safeNotification = {
    id: `${(/* @__PURE__ */ new Date()).getTime()}-${Math.floor(Math.random() * 9999)}`,
    position: "bottom-center",
    text: "",
    ...notification
  };
  if (!positions.includes(notification.position)) return;
  update((notifications) => {
    if (safeNotification.position.includes("top-")) {
      return [safeNotification, ...notifications];
    }
    return [...notifications, safeNotification];
  });
};
const removeNotification = (notificationId, { update }) => {
  if (!notificationId) return;
  update((notifications) => notifications.filter(({ id }) => id !== notificationId));
};
const clearNotifications = (store2) => store2.set([]);
const createStore = () => {
  const store2 = writable([]);
  return {
    subscribe: store2.subscribe,
    addNotification: (notification) => addNotification(notification, store2),
    removeNotification: (notificationId) => removeNotification(notificationId, store2),
    clearNotifications: () => clearNotifications(store2)
  };
};
const store = createStore();
function Notifications($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let item = fallback($$props["item"], null);
    let withoutStyles = fallback($$props["withoutStyles"], false);
    let zIndex = fallback($$props["zIndex"], null);
    const getClass = (position = "") => {
      const defaultPositionClass = ` default-position-style-${position}`;
      return `position-${position}${withoutStyles ? "" : defaultPositionClass}`;
    };
    setContext(context, store);
    $$renderer2.push(`<!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--> <div class="notifications"><!--[-->`);
    const each_array = ensure_array_like(positions);
    for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
      let position = each_array[$$index_1];
      $$renderer2.push(`<div${attr_class(clsx(getClass(position)), "svelte-1p7wfti")}${attr_style("", { "z-index": zIndex })}><!--[-->`);
      const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$store", store));
      for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
        let notification = each_array_1[$$index];
        if (notification.position === position) {
          $$renderer2.push("<!--[-->");
          Notification($$renderer2, {
            notification,
            withoutStyles,
            item: item || DefaultNotification
          });
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { item, withoutStyles, zIndex });
  });
}
export {
  Notifications as N,
  getNotificationsContext as g
};
