import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, ac as attr, aa as escape_html, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function ModalHeader($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "toggle", "closeAriaLabel", "id", "content"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let toggle = fallback($$props["toggle"], void 0);
    let closeAriaLabel = fallback($$props["closeAriaLabel"], "Close");
    let id = fallback($$props["id"], void 0);
    let content = fallback($$props["content"], void 0);
    classes = classnames(className, "modal-header");
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><h5 class="modal-title"${attr("id", id)}>`);
    if (content) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`${escape_html(content)}`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></h5> <!--[-->`);
    slot($$renderer2, $$props, "close", {}, () => {
      if (typeof toggle === "function") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button type="button" class="btn-close"${attr("aria-label", closeAriaLabel)}></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    });
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, toggle, closeAriaLabel, id, content });
  });
}
export {
  ModalHeader as M
};
