import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a9 as bind_props, a7 as attributes, a8 as clsx, a0 as slot } from "./index2.js";
import { c as classnames, u as uuid } from "./Theme.svelte_svelte_type_style_lang.js";
import { o as onDestroy } from "./index-server.js";
import { I as InlineContainer, P as Portal } from "./Portal.js";
function ModalBackdrop($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  rest_props($$sanitized_props, ["class", "isOpen", "fade"]);
  $$renderer.component(($$renderer2) => {
    let className = fallback($$props["class"], "");
    let isOpen = fallback($$props["isOpen"], false);
    let fade = fallback($$props["fade"], true);
    classnames(className, "modal-backdrop");
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { class: className, isOpen, fade });
  });
}
function ModalBody($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    classes = classnames(className, "modal-body");
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className });
  });
}
function Modal($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  rest_props($$sanitized_props, [
    "class",
    "static",
    "autoFocus",
    "body",
    "centered",
    "container",
    "fullscreen",
    "header",
    "isOpen",
    "keyboard",
    "backdrop",
    "contentClassName",
    "fade",
    "labelledBy",
    "modalClassName",
    "modalStyle",
    "returnFocusAfterClose",
    "scrollable",
    "size",
    "theme",
    "toggle",
    "unmountOnClose",
    "wrapClassName"
  ]);
  $$renderer.component(($$renderer2) => {
    let outer;
    let className = fallback($$props["class"], "");
    let staticModal = fallback($$props["static"], false);
    let autoFocus = fallback($$props["autoFocus"], true);
    let body = fallback($$props["body"], false);
    let centered = fallback($$props["centered"], false);
    let container = fallback($$props["container"], void 0);
    let fullscreen = fallback($$props["fullscreen"], false);
    let header = fallback($$props["header"], void 0);
    let isOpen = fallback($$props["isOpen"], false);
    let keyboard = fallback($$props["keyboard"], true);
    let backdrop = fallback($$props["backdrop"], true);
    let contentClassName = fallback($$props["contentClassName"], "");
    let fade = fallback($$props["fade"], true);
    let labelledBy = fallback($$props["labelledBy"], () => header ? `modal-${uuid()}` : void 0, true);
    let modalClassName = fallback($$props["modalClassName"], "");
    let modalStyle = fallback($$props["modalStyle"], null);
    let returnFocusAfterClose = fallback($$props["returnFocusAfterClose"], true);
    let scrollable = fallback($$props["scrollable"], false);
    let size = fallback($$props["size"], "");
    let theme = fallback($$props["theme"], null);
    let toggle = fallback($$props["toggle"], void 0);
    let unmountOnClose = fallback($$props["unmountOnClose"], true);
    let wrapClassName = fallback($$props["wrapClassName"], "");
    onDestroy(() => {
    });
    const dialogBaseClass = "modal-dialog";
    classnames(dialogBaseClass, className, {
      [`modal-${size}`]: size,
      "modal-fullscreen": fullscreen === true,
      [`modal-fullscreen-${fullscreen}-down`]: fullscreen && typeof fullscreen === "string",
      [`${dialogBaseClass}-centered`]: centered,
      [`${dialogBaseClass}-scrollable`]: scrollable
    });
    outer = container === "inline" || staticModal ? InlineContainer : Portal;
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (backdrop && !staticModal) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push("<!---->");
      outer?.($$renderer2, {
        children: ($$renderer3) => {
          ModalBackdrop($$renderer3, { fade, isOpen });
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      class: className,
      static: staticModal,
      autoFocus,
      body,
      centered,
      container,
      fullscreen,
      header,
      isOpen,
      keyboard,
      backdrop,
      contentClassName,
      fade,
      labelledBy,
      modalClassName,
      modalStyle,
      returnFocusAfterClose,
      scrollable,
      size,
      theme,
      toggle,
      unmountOnClose,
      wrapClassName
    });
  });
}
export {
  Modal as M,
  ModalBody as a
};
