import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, aa as escape_html, a0 as slot, a9 as bind_props, ad as attr_class, a1 as store_get, ac as attr, a3 as unsubscribe_stores } from "./index2.js";
import { E as EmailNav, a as EmailLabel, A as AddLabel } from "./AddLabel.js";
import "clsx";
import { B as Button } from "./Button.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { u as uuid, c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
import { E as Editor } from "./Editor.js";
import { w as writable } from "./index.js";
import { D as Dropdown, a as DropdownToggle, b as DropdownMenu } from "./DropdownToggle.js";
import { D as DropdownItem } from "./DropdownItem.js";
import { I as Input } from "./Input.js";
import { I as InputGroup } from "./InputGroup.js";
import { o as onDestroy } from "./index-server.js";
import { createPopper } from "@popperjs/core";
import { I as InlineContainer, P as Portal } from "./Portal.js";
function Tooltip($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "animation",
    "content",
    "container",
    "id",
    "isOpen",
    "placement",
    "target",
    "theme",
    "delay"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes, outer;
    let className = fallback($$props["class"], "");
    let animation = fallback($$props["animation"], true);
    let content = fallback($$props["content"], "");
    let container = fallback($$props["container"], void 0);
    let id = fallback($$props["id"], () => `tooltip_${uuid()}`, true);
    let isOpen = fallback($$props["isOpen"], false);
    let placement = fallback($$props["placement"], "top");
    let target = fallback($$props["target"], "");
    let theme = fallback($$props["theme"], null);
    let delay = fallback($$props["delay"], 0);
    let bsPlacement;
    let popperInstance;
    let popperPlacement = placement;
    let targetEl;
    let tooltipEl;
    let showTimer;
    const checkPopperPlacement = {
      name: "checkPopperPlacement",
      enabled: true,
      phase: "main",
      fn({ state }) {
        popperPlacement = state.placement;
      }
    };
    const open = () => {
      clearTimeout(showTimer);
      showTimer = setTimeout(() => isOpen = true, delay);
    };
    const close = () => {
      clearTimeout(showTimer);
      isOpen = false;
    };
    onDestroy(() => {
      unregisterEventListeners();
      clearTimeout(showTimer);
    });
    function registerEventListeners() {
      if (target == null || !target) {
        targetEl = null;
        return;
      }
      try {
        if (target instanceof HTMLElement) {
          targetEl = target;
        }
      } catch (e) {
      }
      if (targetEl == null) {
        try {
          targetEl = document.querySelector(`#${target}`);
        } catch (e) {
        }
      }
      if (targetEl) {
        targetEl.addEventListener("mouseover", open);
        targetEl.addEventListener("mouseleave", close);
        targetEl.addEventListener("focus", open);
        targetEl.addEventListener("blur", close);
      }
    }
    function unregisterEventListeners() {
      if (targetEl) {
        targetEl.removeEventListener("mouseover", open);
        targetEl.removeEventListener("mouseleave", close);
        targetEl.removeEventListener("focus", open);
        targetEl.removeEventListener("blur", close);
        targetEl.removeAttribute("aria-describedby");
      }
    }
    {
      if (isOpen && tooltipEl) {
        popperInstance = createPopper(targetEl, tooltipEl, { placement, modifiers: [checkPopperPlacement] });
      } else if (popperInstance) {
        popperInstance.destroy();
        popperInstance = void 0;
      }
    }
    if (target) {
      unregisterEventListeners();
      registerEventListeners();
    }
    if (targetEl) {
      if (isOpen) {
        targetEl.setAttribute("aria-describedby", id);
      } else {
        targetEl.removeAttribute("aria-describedby");
      }
    }
    {
      if (popperPlacement === "left") {
        bsPlacement = "start";
      } else if (popperPlacement === "right") {
        bsPlacement = "end";
      } else {
        bsPlacement = popperPlacement;
      }
    }
    classes = classnames(className, "tooltip", `bs-tooltip-${bsPlacement}`, animation ? "fade" : false, isOpen ? "show" : false);
    outer = container === "inline" ? InlineContainer : Portal;
    if (isOpen) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push("<!---->");
      outer?.($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<div${attributes({
            ...$$restProps,
            class: clsx(classes),
            id,
            role: "tooltip",
            "data-bs-theme": theme,
            "data-bs-delay": delay,
            "x-placement": popperPlacement
          })}><div class="tooltip-arrow" data-popper-arrow=""></div> <div class="tooltip-inner">`);
          if (content) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`${escape_html(content)}`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<!--[-->`);
            slot($$renderer3, $$props, "default", {}, null);
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]--></div></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      class: className,
      animation,
      content,
      container,
      id,
      isOpen,
      placement,
      target,
      theme,
      delay
    });
  });
}
const allMails = /* @__PURE__ */ JSON.parse(`[{"username":"Tanjim Hasan","email":"hasan@gmail.com","status":"unread","type":"inbox","stared":false,"from":"name@example.com","to":"me","img":"t1.jpg","id":1585118055048,"subject":"Email subject lorem ipsum","attach":[],"unread":true,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Mohammad Delower Hossain","email":"deloar@gmail.com","status":"read","type":"sent","from":"me","to":"name@example.com","stared":false,"img":"t2.jpg","id":1585118175550,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Mohammad Atik","email":"atik@gmail.com","status":"read","type":"inbox","from":"name@example.com","to":"me","stared":true,"img":"t3.jpg","id":1585118261699,"subject":"Email subject lorem ipsum","attach":[],"unread":true,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Alice Freeman","email":"azim@gmail.com","status":"read","type":"inbox","from":"name@example.com","to":"me","stared":false,"img":"t4.jpg","id":1585118306947,"subject":"Email subject lorem ipsum","attach":["1.png","2.png"],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Hileri Makr","email":"abdullah@gmail.com","status":"read","type":"sent","from":"me","to":"name@example.com","stared":false,"img":"t5.png","id":1585118306999,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Vincent Porter","email":"sorif@gmail.com","status":"read","type":"inbox","from":"name@example.com","to":"me","stared":false,"img":"t6.png","id":1593052811353,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Sam Porter","email":"tanvir@gmail.com","status":"read","type":"inbox","from":"name@example.com","to":"me","stared":false,"img":"t7.png","id":1593052915496,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Jenisha Trivedi","email":"tanvir@gmail.com","status":"read","type":"draft","from":"name@example.com","to":"me","stared":false,"img":"t8.png","id":1593052915497,"subject":"Email subject lorem ipsum","attach":[],"unread":true,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Sarah Graves","email":"tanvir@gmail.com","status":"read","type":"draft","from":"name@example.com","to":"me","stared":false,"img":"t9.png","id":1593052915498,"subject":"Email subject lorem ipsum","attach":[],"unread":true,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"AI Could Uber","email":"tanvir@gmail.com","status":"read","type":"inbox","from":"name@example.com","to":"me","stared":false,"img":"t10.png","id":1593052915499,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Robert Ilsa","email":"tanvir@gmail.com","status":"read","type":"trash","from":"name@example.com","to":"me","stared":false,"img":"t1.jpg","id":1593052915499,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Ishaq","email":"ishaq@gmail.com","status":"read","type":"spam","from":"name@example.com","to":"me","stared":false,"img":"t12.png","id":1593052915499,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Sam Porter","email":"tanvir@gmail.com","status":"read","type":"draft","from":"name@example.com","to":"me","stared":false,"img":"t3.jpg","id":1593052915596,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."},{"username":"Michel Porter","email":"tanvir@gmail.com","status":"read","type":"spam","from":"name@example.com","to":"me","stared":false,"img":"t4.jpg","id":1593052915596,"subject":"Email subject lorem ipsum","attach":[],"unread":false,"body":"Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum."}]`);
const allMails$1 = {
  allMails
};
const mailList = writable(allMails$1);
const mailBoxVisibility = writable(false);
function EmailSidebar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let navList = $$props["navList"];
    let labelList = $$props["labelList"];
    $$renderer2.push(`<aside class="mailbox-sidebar-container"><div class="dm-mail-sidebar show mb-30">`);
    Card($$renderer2, {
      children: ($$renderer3) => {
        $$renderer3.push(`<a href="#" class="mailbar-cross d-md-none"><i class="uil uil-times"></i></a> `);
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="d-flex align-content-center content-center px-15">`);
            Button($$renderer4, {
              class: "btn-compose btn-shadow-primary",
              color: "primary",
              block: true,
              children: ($$renderer5) => {
                $$renderer5.push(`<i class="uil uil-plus"></i> Compose`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div> <div class="mail-sidebar-bottom">`);
            EmailNav($$renderer4, { navList });
            $$renderer4.push(`<!----></div> <span class="dm-mail-label mt-35">Label</span> `);
            EmailLabel($$renderer4, { labelList });
            $$renderer4.push(`<!----> `);
            AddLabel($$renderer4);
            $$renderer4.push(`<!---->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></aside>`);
    bind_props($$props, { navList, labelList });
  });
}
function MailBox($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const miximizeIcon = "/img/svg/maximize.svg";
    const xIcon = "/img/svg/x.svg";
    const paperClipIcon = "/img/svg/paperclip.svg";
    const smileIcon = "/img/svg/smile.svg";
    const trashIcon = "/img/svg/trash-2.svg";
    $$renderer2.push(`<div${attr_class(clsx(store_get($$store_subs ??= {}, "$mailBoxVisibility", mailBoxVisibility) ? "custom-mailCompose custom-mailCompose--position show" : "custom-mailCompose custom-mailCompose--position"))}><form action="#"><div class="custom-mailCompose__header d-flex justify-content-between align-items-center"><h6 class="mailCompose-title">New Message</h6> <div class="custom-mailCompose__action"><a href="#"><img class="svg" alt=""${attr("src", miximizeIcon)}/></a> <a href="#" class="compose-close"><img class="svg" alt=""${attr("src", xIcon)}/></a></div></div> <div class="custom-mailCompose__body"><div class="mailCompose-form-content"><div class="form-group positon-relative"><div class="form-group positon-relative"><input type="email" class="form-control-lg" name="email-to" placeholder="To"/></div> <span class="mail-cc">Cc</span></div> <div class="form-group positon-relative"><input type="text" class="form-control-lg" name="mail-to" placeholder="Subject"/></div> <div class="form-group">`);
    Editor($$renderer2, {});
    $$renderer2.push(`<!----></div></div></div> <div class="custom-mailCompose__footer d-flex justify-content-between align-items-center"><div class="footer-left d-flex align-items-center">`);
    Button($$renderer2, {
      type: "button",
      color: "primary",
      size: "md",
      children: ($$renderer3) => {
        $$renderer3.push(`<!---->Send`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> <a href="#"><img class="svg" alt=""${attr("src", paperClipIcon)}/></a> <a href="#"><img class="svg" alt=""${attr("src", smileIcon)}/></a></div> <div class="footer-right"><a href="#" class="btn-remove"><img class="svg" alt=""${attr("src", trashIcon)}/></a></div></div></form></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function MailTop($$renderer) {
  const searchIcon = "/img/svg/search.svg";
  const archiveIcon = "/img/svg/archive.svg";
  const alertIcon = "/img/svg/alert-octagon.svg";
  const trashIcon = "/img/svg/trash-2.svg";
  const bookOpenIcon = "/img/svg/book-open.svg";
  const folderIcon = "/img/svg/folder.svg";
  const sliderIcon = "/img/svg/sliders.svg";
  $$renderer.push(`<div class="mailbox-top d-flex justify-content-between align-items-center"><div class="mailbox-top__left"><ul class="mailbox-top__actions d-flex align-items-center"><li class="mail-selection checkbox-theme-default custom-checkbox"><input type="checkbox" class="checkbox" id="mail-select"/> <label for="mail-select"><i class="uil uil-angle-down"></i></label> <ul class="mail-selection__dropdown"><li><a href="#">All</a></li> <li><a href="#">Read</a></li> <li><a href="#">Unread</a></li> <li><a href="#">Stared</a></li> <li><a href="#">Unstared</a></li></ul></li> <li><a class="icon-action active" id="wpwax-vm-mail-refresh" href="#"><i class="las la-redo-alt"></i></a> `);
  Tooltip($$renderer, {
    placement: "bottom",
    target: "wpwax-vm-mail-refresh",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Refresh`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></li> <li><a class="icon-action" id="wpwax-vm-mail-archive" href="#"><img class="svg" alt=""${attr("src", archiveIcon)}/></a> `);
  Tooltip($$renderer, {
    placement: "bottom",
    target: "wpwax-vm-mail-archive",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Archive`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></li> <li><a class="icon-action" id="wpwax-vm-mail-info" href="#"><img class="svg" alt=""${attr("src", alertIcon)}/></a> `);
  Tooltip($$renderer, {
    placement: "bottom",
    target: "wpwax-vm-mail-info",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Info`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></li> <li><a class="icon-action" id="wpwax-vm-mail-delete" href="#"><img class="svg" alt=""${attr("src", trashIcon)}/></a> `);
  Tooltip($$renderer, {
    placement: "bottom",
    target: "wpwax-vm-mail-delete",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Delete`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></li> <li><a class="icon-action" id="wpwax-vm-mail-read" href="#"><img class="svg" alt=""${attr("src", bookOpenIcon)}/></a> `);
  Tooltip($$renderer, {
    placement: "bottom",
    target: "wpwax-vm-mail-read",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Read`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></li> <li><a class="icon-action" id="wpwax-vm-mail-folder" href="#"><img class="svg" alt=""${attr("src", folderIcon)}/></a> `);
  Tooltip($$renderer, {
    placement: "bottom",
    target: "wpwax-vm-mail-folder",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->Folder`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></li></ul></div> <div class="mailbox-top__right d-flex align-items-center"><div class="mailbox-top__search"><div class="input-container icon-left position-relative"><span class="input-icon icon-left"><img class="svg" alt=""${attr("src", searchIcon)}/></span> `);
  InputGroup($$renderer, {
    size: "lg",
    children: ($$renderer2) => {
      Input($$renderer2, { placeholder: "Search Mail" });
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div></div> <div class="mailbox-top__extra d-flex align-items-center"><span class="result-perpage">1 - 50 of 235</span> <div class="mail-sliding-control"><a href="#" class="icon-action"><i class="la la-angle-left"></i></a> <a href="#" class="icon-action active"><i class="la la-angle-right"></i></a></div> <a href="#" class="icon-action mail-sliding-control-slider"><img class="svg" alt=""${attr("src", sliderIcon)}/></a> `);
  Dropdown($$renderer, {
    children: ($$renderer2) => {
      DropdownToggle($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<i class="uil uil-ellipsis-v m-0"></i>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      DropdownMenu($$renderer2, {
        children: ($$renderer3) => {
          DropdownItem($$renderer3, {
            href: "#",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->More One`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          DropdownItem($$renderer3, {
            href: "#",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->More Two`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          DropdownItem($$renderer3, {
            href: "#",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->More Three`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div></div></div>`);
}
export {
  EmailSidebar as E,
  MailTop as M,
  MailBox as a,
  mailList as m
};
