import { a6 as fallback, ac as attr, ad as attr_class, a9 as bind_props, ae as stringify } from "./index2.js";
function GridIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-grid ${stringify(customClass)}`)}><rect x="3" y="3" width="7" height="7"></rect><rect x="14" y="3" width="7" height="7"></rect><rect x="14" y="14" width="7" height="7"></rect><rect x="3" y="14" width="7" height="7"></rect></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
function ListIcon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let size = fallback($$props["size"], "24");
    let strokeWidth = fallback($$props["strokeWidth"], 2);
    let customClass = fallback($$props["class"], "");
    if (size !== "100%") {
      size = size.slice(-1) === "x" ? size.slice(0, size.length - 1) + "em" : parseInt(size) + "px";
    }
    $$renderer2.push(`<svg xmlns="http://www.w3.org/2000/svg"${attr("width", size)}${attr("height", size)} fill="none" viewBox="0 0 24 24" stroke="currentColor"${attr("stroke-width", strokeWidth)} stroke-linecap="round" stroke-linejoin="round"${attr_class(`feather feather-list ${stringify(customClass)}`)}><line x1="8" y1="6" x2="21" y2="6"></line><line x1="8" y1="12" x2="21" y2="12"></line><line x1="8" y1="18" x2="21" y2="18"></line><line x1="3" y1="6" x2="3.01" y2="6"></line><line x1="3" y1="12" x2="3.01" y2="12"></line><line x1="3" y1="18" x2="3.01" y2="18"></line></svg>`);
    bind_props($$props, { size, strokeWidth, class: customClass });
  });
}
export {
  GridIcon as G,
  ListIcon as L
};
