import { ad as attr_class, a8 as clsx, ag as ensure_array_like, ae as stringify, aa as escape_html } from "./index2.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import { C as CardHeader } from "./CardHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { b as bestSellersData } from "./table-data.js";
import { T as TopProducts } from "./TopProducts.js";
function TopProducts_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const products = bestSellersData.topProduct;
    let period = "today";
    let dataPeriod = products[period];
    Card($$renderer2, {
      class: "border-0 px-25 pb-15 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          class: "px-0 border-0",
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Top Products</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "p-0",
          children: ($$renderer4) => {
            TopProducts($$renderer4, { dataPeriod });
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
const today = [{ "paymentMethod": "Bank Transfer", "duration": "10 mins ago", "amount": "$578", "icon": "university", "style": "primary", "paymentType": "credit" }, { "paymentMethod": "Paypal", "duration": "21 mins ago", "amount": "$145", "icon": "paypal", "style": "info", "paymentType": "credit" }, { "paymentMethod": "Wallet", "duration": "31 mins ago", "amount": "$956", "icon": "wallet", "style": "success", "paymentType": "debit" }, { "paymentMethod": "Credit Card", "duration": "45 mins ago", "amount": "$758", "icon": "credit-card", "style": "warning", "paymentType": "credit" }, { "paymentMethod": "Transfer", "duration": "50 mins ago", "amount": "$358", "icon": "money-bill", "style": "secondary", "paymentType": "debit" }];
const week = [{ "paymentMethod": "Bank Transfer", "duration": "50 mins ago", "amount": "$748", "icon": "university", "style": "primary", "paymentType": "credit" }, { "paymentMethod": "Paypal", "duration": "15 mins ago", "amount": "$584", "icon": "paypal", "style": "info", "paymentType": "debit" }, { "paymentMethod": "Wallet", "duration": "45 mins ago", "amount": "$695", "icon": "wallet", "style": "success", "paymentType": "credit" }, { "paymentMethod": "Credit Card", "duration": "25 mins ago", "amount": "$159", "icon": "credit-card", "style": "warning", "paymentType": "credit" }, { "paymentMethod": "Transfer", "duration": "56 mins ago", "amount": "$357", "icon": "money-bill", "style": "secondary", "paymentType": "debit" }];
const month = [{ "paymentMethod": "Bank Transfer", "duration": "1 hour ago", "amount": "$753", "icon": "university", "style": "primary", "paymentType": "debit" }, { "paymentMethod": "Paypal", "duration": "45 mins ago", "amount": "$852", "icon": "paypal", "style": "info", "paymentType": "debit" }, { "paymentMethod": "Wallet", "duration": "54 mins ago", "amount": "$456", "icon": "wallet", "style": "success", "paymentType": "credit" }, { "paymentMethod": "Credit Card", "duration": "35 mins ago", "amount": "$789", "icon": "credit-card", "style": "warning", "paymentType": "debit" }, { "paymentMethod": "Transfer", "duration": "12 mins ago", "amount": "$369", "icon": "money-bill", "style": "secondary", "paymentType": "credit" }];
const transecData = {
  today,
  week,
  month
};
function LatestTransection($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let period = "today";
    let dataPeriod = transecData[period];
    Card($$renderer2, {
      class: "border-0 h-100",
      children: ($$renderer3) => {
        CardHeader($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<h6>Latest Transections</h6> <div class="card-extra"><ul class="card-tab-links nav"><li><a href="#"${attr_class(clsx("active"))}>Today</a></li> <li><a href="#"${attr_class(clsx(""))}>Week</a></li> <li><a href="#"${attr_class(clsx(""))}>year</a></li></ul></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        CardBody($$renderer3, {
          class: "py-30",
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="transection-list svelte-1866rnt"><!--[-->`);
            const each_array = ensure_array_like(dataPeriod);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let data = each_array[$$index];
              $$renderer4.push(`<div class="transection-single svelte-1866rnt"><div class="transection-single__details svelte-1866rnt"><span${attr_class(`transection-single__icon transection-single__icon--${stringify(data.style)}`, "svelte-1866rnt")}><i${attr_class(`uil uil-${stringify(data.icon)}`, "svelte-1866rnt")}></i></span> <span class="transection-single__info svelte-1866rnt"><strong class="svelte-1866rnt">${escape_html(data.paymentMethod)}</strong> <span class="svelte-1866rnt">${escape_html(data.duration)}</span></span></div> `);
              if (data.paymentType === "credit") {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div${attr_class(`transection-single__amount transection-single__amount--${stringify(data.paymentType + "ed")}`, "svelte-1866rnt")}><span class="svelte-1866rnt">+${escape_html(data.amount)}</span></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<div${attr_class(`transection-single__amount transection-single__amount--${stringify(data.paymentType + "ed")}`, "svelte-1866rnt")}><span class="svelte-1866rnt">-${escape_html(data.amount)}</span></div>`);
              }
              $$renderer4.push(`<!--]--></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      },
      $$slots: { default: true }
    });
  });
}
export {
  LatestTransection as L,
  TopProducts_1 as T
};
