import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { i as isObject, g as getColumnSizeClass, c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Label($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "hidden",
    "check",
    "size",
    "for",
    "xs",
    "sm",
    "md",
    "lg",
    "xl",
    "xxl",
    "widths"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let hidden = fallback($$props["hidden"], false);
    let check = fallback($$props["check"], false);
    let size = fallback($$props["size"], "");
    let fore = fallback($$props["for"], null);
    let xs = fallback($$props["xs"], "");
    let sm = fallback($$props["sm"], "");
    let md = fallback($$props["md"], "");
    let lg = fallback($$props["lg"], "");
    let xl = fallback($$props["xl"], "");
    let xxl = fallback($$props["xxl"], "");
    const colWidths = { xs, sm, md, lg, xl, xxl };
    let widths = fallback($$props["widths"], () => Object.keys(colWidths), true);
    const colClasses = [];
    widths.forEach((colWidth) => {
      let columnProp = $$sanitized_props[colWidth];
      if (!columnProp && columnProp !== "") {
        return;
      }
      const isXs = colWidth === "xs";
      let colClass;
      if (isObject(columnProp)) {
        const colSizeInterfix = isXs ? "-" : `-${colWidth}-`;
        colClass = getColumnSizeClass(isXs, colWidth, columnProp.size);
        colClasses.push(classnames({
          [colClass]: columnProp.size || columnProp.size === "",
          [`order${colSizeInterfix}${columnProp.order}`]: columnProp.order || columnProp.order === 0,
          [`offset${colSizeInterfix}${columnProp.offset}`]: columnProp.offset || columnProp.offset === 0
        }));
      } else {
        colClass = getColumnSizeClass(isXs, colWidth, columnProp);
        colClasses.push(colClass);
      }
    });
    classes = classnames(className, hidden ? "visually-hidden" : false, check ? "form-check-label" : false, size ? `col-form-label-${size}` : false, colClasses, colClasses.length ? "col-form-label" : "form-label");
    $$renderer2.push(`<label${attributes({ ...$$restProps, class: clsx(classes), for: fore })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></label>`);
    bind_props($$props, {
      class: className,
      hidden,
      check,
      size,
      for: fore,
      xs,
      sm,
      md,
      lg,
      xl,
      xxl,
      widths
    });
  });
}
export {
  Label as L
};
