import { aa as escape_html, ad as attr_class, a9 as bind_props, ae as stringify, a8 as clsx, ac as attr } from "./index2.js";
import "clsx";
import { S as Slider } from "./Slider.js";
import { I as Input } from "./Input.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { G as GridIcon, L as ListIcon } from "./ListIcon.js";
import { w as writable } from "./index.js";
function JobSidebar($$renderer) {
  let range2 = [30, 90];
  let $$settled = true;
  let $$inner_renderer;
  function $$render_inner($$renderer2) {
    $$renderer2.push(`<aside class="dm-product-sidebar mb-lg-30"><div class="dm-product-sidebar__header"><h6 class="d-flex align-content-center fw-500"><i class="uil uil-sliders-v-alt"></i>Filters</h6></div> <div class="dm-product-sidebar__content"><div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse"><h6>Distance</h6> <p class="price-range-text fs-15">Within 30 miles of <strong>New York, NY</strong></p></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><div class="dm-product-price-ranges"><div class="custom-range-slider dm-price-range mb-0"><div class="section price">`);
    Slider($$renderer2, {
      max: "200",
      step: "10",
      range: true,
      order: true,
      get value() {
        return range2;
      },
      set value($$value) {
        range2 = $$value;
        $$settled = false;
      }
    });
    $$renderer2.push(`<!----> <p class="price-range-value fs-15"><span>${escape_html(range2[0])} miles</span> <span>${escape_html(range2[1])} miles</span></p></div></div></div></div></div> <div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse mb-20"><h6>Job Types</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-brands limit-list-item"><li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-1",
      label: "Freelance"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-2",
      label: "Full Time"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-3",
      label: "Part Time"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-4",
      label: "Internship"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-5",
      label: "Contract"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-6",
      label: "Temporary"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li class="mt-2 more">See more</li></ul></div></div> <div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse mb-20"><h6>Industry</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-brands limit-list-item"><li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-7",
      label: "Designer Graphics"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-8",
      label: "Development"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-9",
      label: "Management"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-10",
      label: "Finance"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-11",
      label: "Banking"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-12",
      label: "Customer Support"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li class="mt-2 more">See more</li></ul></div></div> <div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse mb-20"><h6>Salary</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-brands limit-list-item"><li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-13",
      label: "Hourly"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-14",
      label: "Weekly"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-15",
      label: "Monthly"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-16",
      label: "Yearly"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li></ul></div></div> <div class="dm-product-sidebar__widget mb-30"><div class="dm-product-sidebar__widget--title no-collapse mb-20"><h6>Date Posted</h6></div> <div class="dm-product-sidebar__widget-card border-0 shadow-none mt-10"><ul class="product-brands limit-list-item"><li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-17",
      label: "Last Hour"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-18",
      label: "Last 24 hours"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-19",
      label: "7 days"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-20",
      label: "14 days"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-21",
      label: "30 days"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li> <li><div class="checkbox-theme-default custom-checkbox">`);
    Input($$renderer2, {
      class: "checkbox",
      type: "checkbox",
      id: "check-22",
      label: "ALL"
    });
    $$renderer2.push(`<!----></div> <span class="item-numbers">25</span></li></ul></div></div></div></aside>`);
  }
  do {
    $$settled = true;
    $$inner_renderer = $$renderer.copy();
    $$render_inner($$inner_renderer);
  } while (!$$settled);
  $$renderer.subsume($$inner_renderer);
}
function JobToolBox($$renderer, $$props) {
  let cardType = $$props["cardType"];
  $$renderer.push(`<div class="shop_products_top_filter"><div class="project-top-wrapper d-flex flex-wrap align-items-center"><div class="project-top-left d-flex flex-wrap align-items-center"><span class="project-result-showing">Showing <span>1-8</span> of <span>86</span> results</span></div> <div class="project-top-right d-flex flex-wrap align-items-center"><div class="job-category flex-wrap d-flex align-items-center"><p class="mb-0 me-10 fs-14 color-light">sort by:</p> <div class="job__select dm-select"><select class="form-control color-primary">`);
  $$renderer.option({ value: "all" }, ($$renderer2) => {
    $$renderer2.push(`All`);
  });
  $$renderer.option({ value: "latest" }, ($$renderer2) => {
    $$renderer2.push(`Latest`);
  });
  $$renderer.option({ value: "old" }, ($$renderer2) => {
    $$renderer2.push(`Old`);
  });
  $$renderer.push(`</select></div></div> <div class="project-icon-selected content-center"><div class="listing-social-link"><div class="icon-list-social d-flex"><a href="/job/job-grid"${attr_class(`icon-list-social__link rounded-circle icon-list-social__style justify-content-center ${stringify(cardType === "card" ? "active" : "")}`)}>`);
  GridIcon($$renderer, {});
  $$renderer.push(`<!----></a> <a href="/job/job-list"${attr_class(`icon-list-social__link rounded-circle icon-list-social__style justify-content-center ${stringify(cardType === "list" ? "active" : "")}`)}>`);
  ListIcon($$renderer, {});
  $$renderer.push(`<!----></a></div></div></div></div></div></div>`);
  bind_props($$props, { cardType });
}
function JobCard($$renderer, $$props) {
  let type = $$props["type"];
  let img = $$props["img"];
  let name = $$props["name"];
  let subName = $$props["subName"];
  let deadline = $$props["deadline"];
  let jobTime = $$props["jobTime"];
  let salary = $$props["salary"];
  $$renderer.push(`<div${attr_class(clsx(type === "card" ? "card product product--grid" : "card product product--list"))}>`);
  if (type === "card") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<div class="card job job--grid"><div class="h-100"><div class="job-item px-25 pt-30 pb-25"><div class="card-body p-0 d-flex align-items-sm-center align-items-start flex-sm-row flex-column flex-wrap"><div class="job-item__body text-capitalize"><div class="job-item__image d-flex align-items-center"><a href="/job/job-details"><img class="job-item__image-img img-fluid"${attr("src", img)} alt="digital-chair"/></a> <div class="job-item__title"><a href="/job/job-details"><h6 class="card-title">${escape_html(name)}</h6></a> <span>${escape_html(subName)}</span></div></div> <div class="job-item__content d-inline-flex flex-column"><div class="job-deadline"><h6>Deadline:</h6> <span>${escape_html(deadline)}</span></div> <div class="job-type"><h6>Job Type:</h6> <span>${escape_html(jobTime)}</span></div> <div class="job-salery"><h6>Salary:</h6> <span>${escape_html(salary)}</span></div></div></div> <div class="job-item__button d-flex flex-wrap my-sm-0 my-10"><a href="/job/job-details" class="btn btn-default btn-squared color-none btn-outline-none px-20">View details</a></div></div></div></div></div>`);
  } else {
    $$renderer.push("<!--[!-->");
    $$renderer.push(`<div class="card job job--list"><div class="h-100"><div class="job-item px-25 py-30"><div class="card-body p-0 d-flex align-items-sm-center align-items-start flex-wrap"><div class="job-item__body text-capitalize d-flex flex-wrap"><div class="job-item__image d-flex align-items-center"><a href="/job/job-details"><img class="job-item__image-img img-fluid"${attr("src", img)} alt="digital-chair"/></a> <div class="job-item__title"><a href="/job/job-details"><h6 class="card-title">${escape_html(name)}</h6></a> <span>${escape_html(subName)}</span></div></div> <div class="job-item__content d-flex"><div class="job-deadline"><span>Deadline</span> <h6>${escape_html(deadline)}</h6></div> <div class="job-type"><span>Job Type</span> <h6>${escape_html(jobTime)}</h6></div> <div class="job-salery"><span>Salary</span> <h6>${escape_html(salary)}</h6></div></div></div> <div class="job-item__button d-flex flex-wrap my-sm-0 my-10"><a href="/job/job-details" class="btn btn-default btn-squared color-none btn-outline-none px-20">View details</a></div></div></div></div></div>`);
  }
  $$renderer.push(`<!--]--></div>`);
  bind_props($$props, { type, img, name, subName, deadline, jobTime, salary });
}
const products = [
  {
    id: 1,
    img: "/img/job/stats.png",
    name: "WordPress Plugins Developer",
    subName: "New York,USA",
    deadline: "31 May 2021",
    jobTime: "full time",
    salary: "$ 1000 - $ 2000 per month"
  },
  {
    id: 2,
    img: "/img/job/chrome.png",
    name: "JavaScript Developer",
    subName: "New York,USA",
    deadline: "31 May 2021",
    jobTime: "full time",
    salary: "$ 1000 - $ 2000 per month"
  },
  {
    id: 3,
    img: "/img/job/dribbble.png",
    name: "Senior UI/UX Designer",
    subName: "New York,USA",
    deadline: "31 May 2021",
    jobTime: "full time",
    salary: "$ 1000 - $ 2000 per month"
  },
  {
    id: 4,
    img: "/img/job/slack.png",
    name: "Frontend Developer",
    subName: "New York,USA",
    deadline: "31 May 2021",
    jobTime: "full time",
    salary: "$ 1000 - $ 2000 per month"
  },
  {
    id: 5,
    img: "/img/job/tags.png",
    name: "Visual Graphic Designer",
    subName: "New York,USA",
    deadline: "31 May 2021",
    jobTime: "full time",
    salary: "$ 1000 - $ 2000 per month"
  },
  {
    id: 6,
    img: "/img/job/firefox.png",
    name: "Support Engineer",
    subName: "New York,USA",
    deadline: "31 May 2021",
    jobTime: "full time",
    salary: "$ 1000 - $ 2000 per month"
  }
];
const allProducts = writable(products);
export {
  JobSidebar as J,
  allProducts as a,
  JobToolBox as b,
  JobCard as c
};
