import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, ad as attr_class, a8 as clsx, a7 as attributes, ac as attr, a0 as slot, aa as escape_html, a9 as bind_props, af as spread_props, ag as ensure_array_like } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function FormCheck($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "checked",
    "disabled",
    "group",
    "id",
    "inline",
    "inner",
    "invalid",
    "label",
    "name",
    "reverse",
    "size",
    "type",
    "valid",
    "value"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes, inputClasses, idFor;
    let className = fallback($$props["class"], "");
    let checked = fallback($$props["checked"], false);
    let disabled = fallback($$props["disabled"], false);
    let group = fallback($$props["group"], void 0);
    let id = fallback($$props["id"], void 0);
    let inline = fallback($$props["inline"], false);
    let inner = fallback($$props["inner"], void 0);
    let invalid = fallback($$props["invalid"], false);
    let label = fallback($$props["label"], "");
    let name = fallback($$props["name"], "");
    let reverse = fallback($$props["reverse"], false);
    let size = fallback($$props["size"], "");
    let type = fallback($$props["type"], "checkbox");
    let valid = fallback($$props["valid"], false);
    let value = fallback($$props["value"], void 0);
    classes = classnames(className, "form-check", {
      "form-check-reverse": reverse,
      "form-switch": type === "switch",
      "form-check-inline": inline,
      [`form-control-${size}`]: size
    });
    inputClasses = classnames("form-check-input", { "is-invalid": invalid, "is-valid": valid });
    idFor = id || label;
    $$renderer2.push(`<div${attr_class(clsx(classes))}>`);
    if (type === "radio") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<input${attributes(
        {
          ...$$restProps,
          class: clsx(inputClasses),
          id: idFor,
          type: "radio",
          checked: group === value,
          disabled,
          name,
          value
        },
        void 0,
        void 0,
        void 0,
        4
      )}/>`);
    } else if (type === "switch") {
      $$renderer2.push("<!--[1-->");
      $$renderer2.push(`<input${attributes(
        {
          ...$$restProps,
          class: clsx(inputClasses),
          id: idFor,
          type: "checkbox",
          checked,
          disabled,
          name,
          value
        },
        void 0,
        void 0,
        void 0,
        4
      )}/>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<input${attributes(
        {
          ...$$restProps,
          class: clsx(inputClasses),
          id: idFor,
          type: "checkbox",
          checked,
          disabled,
          name,
          value
        },
        void 0,
        void 0,
        void 0,
        4
      )}/>`);
    }
    $$renderer2.push(`<!--]--> `);
    if (label) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<label class="form-check-label"${attr("for", idFor)}><!--[-->`);
      slot($$renderer2, $$props, "label", {}, () => {
        $$renderer2.push(`${escape_html(label)}`);
      });
      $$renderer2.push(`<!--]--></label>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, {
      class: className,
      checked,
      disabled,
      group,
      id,
      inline,
      inner,
      invalid,
      label,
      name,
      reverse,
      size,
      type,
      valid,
      value
    });
  });
}
function FormFeedback($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "valid", "tooltip"]);
  $$renderer.component(($$renderer2) => {
    let className = fallback($$props["class"], "");
    let valid = fallback($$props["valid"], void 0);
    let tooltip = fallback($$props["tooltip"], false);
    let classes;
    {
      const validMode = tooltip ? "tooltip" : "feedback";
      classes = classnames(className, valid ? `valid-${validMode}` : `invalid-${validMode}`);
    }
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, valid, tooltip });
  });
}
function Input($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "bsSize",
    "checked",
    "color",
    "disabled",
    "feedback",
    "files",
    "group",
    "inner",
    "invalid",
    "label",
    "max",
    "min",
    "multiple",
    "name",
    "placeholder",
    "plaintext",
    "readonly",
    "reverse",
    "size",
    "theme",
    "type",
    "valid",
    "value"
  ]);
  $$renderer.component(($$renderer2) => {
    let className = fallback($$props["class"], "");
    let bsSize = fallback($$props["bsSize"], void 0);
    let checked = fallback($$props["checked"], false);
    let color = fallback($$props["color"], void 0);
    let disabled = fallback($$props["disabled"], void 0);
    let feedback = fallback($$props["feedback"], void 0);
    let files = fallback($$props["files"], void 0);
    let group = fallback($$props["group"], void 0);
    let inner = fallback($$props["inner"], void 0);
    let invalid = fallback($$props["invalid"], false);
    let label = fallback($$props["label"], void 0);
    let max = fallback($$props["max"], void 0);
    let min = fallback($$props["min"], void 0);
    let multiple = fallback($$props["multiple"], void 0);
    let name = fallback($$props["name"], "");
    let placeholder = fallback($$props["placeholder"], "");
    let plaintext = fallback($$props["plaintext"], false);
    let readonly = fallback($$props["readonly"], void 0);
    let reverse = fallback($$props["reverse"], false);
    let size = fallback($$props["size"], void 0);
    let theme = fallback($$props["theme"], void 0);
    let type = fallback($$props["type"], "text");
    let valid = fallback($$props["valid"], false);
    let value = fallback($$props["value"], void 0);
    let classes;
    let tag;
    {
      const isNotaNumber = new RegExp("\\D", "g");
      let isBtn = false;
      let formControlClass = "form-control";
      tag = "input";
      switch (type) {
        case "color":
          formControlClass = `form-control form-control-color`;
          break;
        case "range":
          formControlClass = "form-range";
          break;
        case "select":
          formControlClass = `form-select`;
          tag = "select";
          break;
        case "textarea":
          tag = "textarea";
          break;
        case "button":
        case "reset":
        case "submit":
          formControlClass = `btn btn-${color || "secondary"}`;
          isBtn = true;
          break;
        case "hidden":
        case "image":
          formControlClass = void 0;
          break;
        default:
          formControlClass = "form-control";
          tag = "input";
      }
      if (plaintext) {
        formControlClass = `${formControlClass}-plaintext`;
        tag = "input";
      }
      if (size && isNotaNumber.test(size)) {
        console.warn(`Please use the prop "bsSize" instead of the "size" to bootstrap's input sizing.`);
        bsSize = size;
        size = void 0;
      }
      classes = classnames(className, formControlClass, {
        "is-invalid": invalid,
        "is-valid": valid,
        [`form-control-${bsSize}`]: bsSize && !isBtn && tag !== "select",
        [`form-select-${bsSize}`]: bsSize && tag === "select",
        [`btn-${bsSize}`]: bsSize && isBtn
      });
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (tag === "input") {
        $$renderer3.push("<!--[-->");
        if (type === "text" || type === "password" || type === "search" || type === "tel" || type === "url") {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              ...{ type },
              "data-bs-theme": theme,
              class: clsx(classes),
              value,
              disabled,
              name,
              placeholder,
              readonly,
              size
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else if (type === "color") {
          $$renderer3.push("<!--[1-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              "data-bs-theme": theme,
              class: clsx(classes),
              type: "color",
              value,
              disabled,
              name,
              placeholder,
              readonly
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else if (type === "email") {
          $$renderer3.push("<!--[2-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              "data-bs-theme": theme,
              class: clsx(classes),
              type: "email",
              value,
              disabled,
              multiple,
              name,
              placeholder,
              readonly,
              size
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else if (type === "file") {
          $$renderer3.push("<!--[3-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              "data-bs-theme": theme,
              class: clsx(classes),
              type: "file",
              disabled,
              invalid,
              multiple,
              name,
              placeholder,
              readonly,
              valid
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else if (type === "checkbox" || type === "radio" || type === "switch") {
          $$renderer3.push("<!--[4-->");
          FormCheck($$renderer3, spread_props([
            $$restProps,
            {
              "data-bs-theme": theme,
              class: className,
              size: bsSize,
              type,
              disabled,
              invalid,
              label,
              name,
              placeholder,
              reverse,
              readonly,
              valid,
              get checked() {
                return checked;
              },
              set checked($$value) {
                checked = $$value;
                $$settled = false;
              },
              get inner() {
                return inner;
              },
              set inner($$value) {
                inner = $$value;
                $$settled = false;
              },
              get group() {
                return group;
              },
              set group($$value) {
                group = $$value;
                $$settled = false;
              },
              get value() {
                return value;
              },
              set value($$value) {
                value = $$value;
                $$settled = false;
              }
            }
          ]));
        } else if (type === "number") {
          $$renderer3.push("<!--[5-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              type: "number",
              "data-bs-theme": theme,
              class: clsx(classes),
              value,
              disabled,
              max,
              min,
              name,
              placeholder,
              readonly
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else if (type === "range") {
          $$renderer3.push("<!--[6-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              type: "range",
              "data-bs-theme": theme,
              class: clsx(classes),
              value,
              disabled,
              max,
              min,
              name,
              placeholder,
              readonly
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else if (type === "date" || type === "datetime" || type === "datetime-local" || type === "month" || type === "time" || type === "week") {
          $$renderer3.push("<!--[7-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              ...{ type },
              "data-bs-theme": theme,
              class: clsx(classes),
              value,
              disabled,
              max,
              min,
              name,
              placeholder,
              readonly
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`<input${attributes(
            {
              ...$$restProps,
              "data-bs-theme": theme,
              class: clsx(classes),
              ...{ type },
              value,
              name,
              disabled,
              placeholder,
              readonly
            },
            void 0,
            void 0,
            void 0,
            4
          )}/>`);
        }
        $$renderer3.push(`<!--]-->`);
      } else if (tag === "textarea") {
        $$renderer3.push("<!--[1-->");
        $$renderer3.push(`<textarea${attributes({
          ...$$restProps,
          "data-bs-theme": theme,
          class: clsx(classes),
          disabled,
          name,
          placeholder,
          readonly
        })}>`);
        const $$body = escape_html(value);
        if ($$body) {
          $$renderer3.push(`${$$body}`);
        }
        $$renderer3.push(`</textarea>`);
      } else if (tag === "select" && !multiple) {
        $$renderer3.push("<!--[2-->");
        $$renderer3.select(
          {
            ...$$restProps,
            "data-bs-theme": theme,
            class: classes,
            value,
            this: inner,
            name,
            disabled,
            readonly
          },
          ($$renderer4) => {
            $$renderer4.push(`<!--[-->`);
            slot($$renderer4, $$props, "default", {}, null);
            $$renderer4.push(`<!--]-->`);
          },
          void 0,
          void 0,
          void 0,
          void 0,
          true
        );
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (feedback) {
        $$renderer3.push("<!--[-->");
        if (Array.isArray(feedback)) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<!--[-->`);
          const each_array = ensure_array_like(feedback);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let msg = each_array[$$index];
            FormFeedback($$renderer3, {
              valid,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(msg)}`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
          FormFeedback($$renderer3, {
            valid,
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(feedback)}`);
            },
            $$slots: { default: true }
          });
        }
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, {
      class: className,
      bsSize,
      checked,
      color,
      disabled,
      feedback,
      files,
      group,
      inner,
      invalid,
      label,
      max,
      min,
      multiple,
      name,
      placeholder,
      plaintext,
      readonly,
      reverse,
      size,
      theme,
      type,
      valid,
      value
    });
  });
}
export {
  Input as I
};
