import { a6 as fallback, ad as attr_class, a8 as clsx, al as attr_style, a9 as bind_props } from "./index2.js";
import { Calendar } from "@fullcalendar/core";
function FullCalendar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let canBeInitiated;
    let classes = fallback($$props["class"], null);
    let style = fallback($$props["style"], null);
    let options = $$props["options"];
    function getAPI() {
      return calendar;
    }
    let calendarEl;
    let calendar;
    function initCalendar() {
      calendar = new Calendar(calendarEl, options);
      calendar.render();
    }
    function updateCalendarOptions() {
      calendar.pauseRendering();
      calendar.resetOptions(options);
      calendar.resumeRendering();
    }
    canBeInitiated = options && options.plugins && options.plugins.length && calendarEl && !calendar;
    {
      if (calendar && options && options.plugins && options.plugins.length) updateCalendarOptions();
      if (canBeInitiated) {
        initCalendar();
      }
    }
    $$renderer2.push(`<div${attr_class(clsx(classes))}${attr_style(style)}></div>`);
    bind_props($$props, { class: classes, style, options, getAPI });
  });
}
export {
  FullCalendar as F
};
