import { ao as sanitize_slots, a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, aa as escape_html, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function FormGroup($$renderer, $$props) {
  const $$slots = sanitize_slots($$props);
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "check",
    "disabled",
    "floating",
    "inline",
    "label",
    "row",
    "spacing",
    "tag"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let check = fallback($$props["check"], false);
    let disabled = fallback($$props["disabled"], false);
    let floating = fallback($$props["floating"], false);
    let inline = fallback($$props["inline"], false);
    let label = fallback($$props["label"], "");
    let row = fallback($$props["row"], false);
    let spacing = fallback($$props["spacing"], "mb-3");
    let tag = fallback($$props["tag"], null);
    classes = classnames(className, spacing, {
      row,
      "form-check": check,
      "form-check-inline": check && inline,
      "form-floating": floating,
      disabled: check && disabled
    });
    if (tag === "fieldset") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<fieldset${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--> `);
      if (label || $$slots.label) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<label>${escape_html(label)} <!--[-->`);
        slot($$renderer2, $$props, "label", {}, null);
        $$renderer2.push(`<!--]--></label>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></fieldset>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--> `);
      if (label || $$slots.label) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<label>${escape_html(label)} <!--[-->`);
        slot($$renderer2, $$props, "label", {}, null);
        $$renderer2.push(`<!--]--></label>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      class: className,
      check,
      disabled,
      floating,
      inline,
      label,
      row,
      spacing,
      tag
    });
  });
}
export {
  FormGroup as F
};
