import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Form($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "inline", "validated"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let inline = fallback($$props["inline"], false);
    let validated = fallback($$props["validated"], false);
    classes = classnames(className, { "form-inline": inline, "was-validated": validated });
    $$renderer2.push(`<form${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></form>`);
    bind_props($$props, { class: className, inline, validated });
  });
}
export {
  Form as F
};
