import "clsx";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props, a1 as store_get, a3 as unsubscribe_stores } from "./index2.js";
import { B as Badge } from "./Badge.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import "./state.svelte.js";
import "js-cookie";
import { S as Svroller } from "./Svroller.js";
import { p as page } from "./stores.js";
function NavbarBrand($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "href"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let href = fallback($$props["href"], "/");
    classes = classnames(className, "navbar-brand");
    $$renderer2.push(`<a${attributes({ ...$$restProps, class: clsx(classes), href })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></a>`);
    bind_props($$props, { class: className, href });
  });
}
function LogoArea($$renderer) {
  $$renderer.push(`<div class="logo-area">`);
  NavbarBrand($$renderer, {
    href: "/",
    children: ($$renderer2) => {
      $$renderer2.push(`<img class="dark" src="/img/logo-dark.svg" alt="svg"/> <img class="light" src="/img/logo-white.svg" alt="img"/>`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> <a href="#" class="sidebar-toggle"><img class="svg" alt="" src="/img/svg/align-center-alt.svg"/></a></div>`);
}
function NavSearch($$renderer) {
  $$renderer.push(`<a href="#" class="search-toggle"><i class="uil uil-search"></i> <i class="uil uil-times"></i></a> <form action="/" class="search-form-topMenu"><span class="search-icon uil uil-search"></span> <input class="form-control me-sm-2 box-shadow-none" type="search" placeholder="Search..." aria-label="Search"/></form>`);
}
function NavMessage($$renderer) {
  $$renderer.push(`<div class="dropdown-custom"><a href="#" class="nav-item-toggle icon-active"><img class="svg" src="/img/svg/message.svg" alt="img"/></a> <div class="dropdown-parent-wrapper"><div class="dropdown-wrapper"><h2 class="dropdown-wrapper__title">Messages `);
  Badge($$renderer, {
    color: "success",
    class: "badge-circle ms-1",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->2`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></h2> <ul><li class="author-online has-new-message"><div class="user-avater"><img src="/img/team-1.png" alt=""/></div> <div class="user-message"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">Web Design</a> <span class="time-posted">3 hrs ago</span></p> <p><span class="desc text-truncate" style="max-width: 215px;">Lorem ipsum dolor amet cosec Lorem ipsum</span> `);
  Badge($$renderer, {
    color: "success",
    class: "msg-count badge-circle badge-sm",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->1`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></p></div></li> <li class="author-offline has-new-message"><div class="user-avater"><img src="/img/team-1.png" alt=""/></div> <div class="user-message"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">Web Design</a> <span class="time-posted">3 hrs ago</span></p> <p><span class="desc text-truncate" style="max-width: 215px;">Lorem ipsum dolor amet cosec Lorem ipsum</span> `);
  Badge($$renderer, {
    color: "success",
    class: "msg-count badge-circle badge-sm",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->1`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></p></div></li> <li class="author-online has-new-message"><div class="user-avater"><img src="/img/team-1.png" alt=""/></div> <div class="user-message"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">Web Design</a> <span class="time-posted">3 hrs ago</span></p> <p><span class="desc text-truncate" style="max-width: 215px;">Lorem ipsum dolor amet cosec Lorem ipsum</span> `);
  Badge($$renderer, {
    color: "success",
    class: "msg-count badge-circle badge-sm",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->1`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></p></div></li> <li class="author-offline"><div class="user-avater"><img src="/img/team-1.png" alt=""/></div> <div class="user-message"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">Web Design</a> <span class="time-posted">3 hrs ago</span></p> <p><span class="desc text-truncate" style="max-width: 215px;">Lorem ipsum dolor amet cosec Lorem ipsum</span></p></div></li> <li class="author-offline"><div class="user-avater"><img src="/img/team-1.png" alt=""/></div> <div class="user-message"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">Web Design</a> <span class="time-posted">3 hrs ago</span></p> <p><span class="desc text-truncate" style="max-width: 215px;">Lorem ipsum dolor amet cosec Lorem ipsum</span></p></div></li></ul> <a href="#" class="dropdown-wrapper__more">See All Message</a></div></div></div>`);
}
function NavNotification($$renderer) {
  $$renderer.push(`<div class="dropdown-custom"><a href="#" class="nav-item-toggle icon-active"><img class="svg" src="/img/svg/alarm.svg" alt="img"/></a> <div class="dropdown-parent-wrapper"><div class="dropdown-wrapper"><h2 class="dropdown-wrapper__title">Notifications `);
  Badge($$renderer, {
    color: "warning",
    class: "badge-circle ms-1",
    children: ($$renderer2) => {
      $$renderer2.push(`<!---->4`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></h2> <ul><li class="nav-notification__single nav-notification__single--unread d-flex flex-wrap"><div class="nav-notification__type nav-notification__type--primary"><img class="svg" alt="" src="/img/svg/inbox.svg"/></div> <div class="nav-notification__details"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">James</a> <span>sent you a message</span></p> <p><span class="time-posted">5 hours ago</span></p></div></li> <li class="nav-notification__single nav-notification__single--unread d-flex flex-wrap"><div class="nav-notification__type nav-notification__type--secondary"><img class="svg" alt="" src="/img/svg/upload.svg"/></div> <div class="nav-notification__details"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">James</a> <span>sent you a message</span></p> <p><span class="time-posted">5 hours ago</span></p></div></li> <li class="nav-notification__single nav-notification__single--unread d-flex flex-wrap"><div class="nav-notification__type nav-notification__type--success"><img class="svg" alt="" src="/img/svg/log-in.svg"/></div> <div class="nav-notification__details"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">James</a> <span>sent you a message</span></p> <p><span class="time-posted">5 hours ago</span></p></div></li> <li class="nav-notification__single nav-notification__single d-flex flex-wrap"><div class="nav-notification__type nav-notification__type--info"><img class="svg" alt="" src="/img/svg/at-sign.svg"/></div> <div class="nav-notification__details"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">James</a> <span>sent you a message</span></p> <p><span class="time-posted">5 hours ago</span></p></div></li> <li class="nav-notification__single nav-notification__single d-flex flex-wrap"><div class="nav-notification__type nav-notification__type--danger"><img class="svg" alt="" src="/img/svg/heart.svg"/></div> <div class="nav-notification__details"><p><a href="#" class="subject stretched-link text-truncate" style="max-width: 180px;">James</a> <span>sent you a message</span></p> <p><span class="time-posted">5 hours ago</span></p></div></li></ul> <a href="#" class="dropdown-wrapper__more">See all incoming activity</a></div></div></div>`);
}
function NavSettings($$renderer) {
  $$renderer.push(`<div class="dropdown-custom"><a href="#" class="nav-item-toggle"><img src="/img/setting.png" alt="setting"/></a> <div class="dropdown-parent-wrapper"><div class="dropdown-wrapper dropdown-wrapper--large"><ul class="list-settings"><li class="d-flex"><div class="me-3"><img src="/img/mail.png" alt=""/></div> <div class="flex-grow-1"><h6><a href="#" class="stretched-link">All Features</a></h6> <p>Introducing Increment subscriptions</p></div></li> <li class="d-flex"><div class="me-3"><img src="/img/color-palette.png" alt=""/></div> <div class="flex-grow-1"><h6><a href="#" class="stretched-link">Themes</a></h6> <p>Third party themes that are compatible</p></div></li> <li class="d-flex"><div class="me-3"><img src="/img/home.png" alt=""/></div> <div class="flex-grow-1"><h6><a href="#" class="stretched-link">Payments</a></h6> <p>We handle billions of dollars</p></div></li> <li class="d-flex"><div class="me-3"><img src="/img/video-camera.png" alt=""/></div> <div class="flex-grow-1"><h6><a href="#" class="stretched-link">Design Mockups</a></h6> <p>Share planning visuals with clients</p></div></li> <li class="d-flex"><div class="me-3"><img src="/img/document.png" alt=""/></div> <div class="flex-grow-1"><h6><a href="#" class="stretched-link">Content Planner</a></h6> <p>Centralize content gethering and editing</p></div></li> <li class="d-flex"><div class="me-3"><img src="/img/microphone.png" alt=""/></div> <div class="flex-grow-1"><h6><a href="#" class="stretched-link">Diagram Maker</a></h6> <p>Plan user flows &amp; test scenarios</p></div></li></ul></div></div></div>`);
}
function NavFlags($$renderer) {
  $$renderer.push(`<div class="dropdown-custom"><a href="#" class="nav-item-toggle"><img src="/img/flag.png" alt="" class="rounded-circle"/></a> <div class="dropdown-parent-wrapper"><div class="dropdown-wrapper dropdown-wrapper--small"><a href="#"><img src="/img/eng.png" alt=""/> English</a> <a href="#"><img src="/img/ger.png" alt=""/> German</a> <a href="#"><img src="/img/spa.png" alt=""/> Spanish</a> <a href="#"><img src="/img/tur.png" alt=""/> Turkish</a> <a href="#"><img src="/img/iraq.png" alt=""/> Arabic</a></div></div></div>`);
}
function NavAuthor($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    $$renderer2.push(`<div class="dropdown-custom"><a href="#" class="nav-item-toggle"><img src="/img/author-nav.png" alt="" class="rounded-circle"/> <span class="nav-item__title">Danial<i class="las la-angle-down nav-item__arrow"></i></span></a> <div class="dropdown-parent-wrapper"><div class="dropdown-wrapper"><div class="nav-author__info"><div class="author-img"><img src="/img/author-nav.png" alt="" class="rounded-circle"/></div> <div><h6>Danial</h6> <span>Support Engineer</span></div></div> <div class="nav-author__options"><ul><li><a href="#"><i class="uil uil-user"></i> Profile</a></li> <li><a href="#"><i class="uil uil-setting"></i>Settings</a></li> <li><a href="#"><i class="uil uil-key-skeleton"></i> Billing</a></li> <li><a href="#"><i class="uil uil-users-alt"></i> Activity</a></li> <li><a href="#"><i class="uil uil-bell"></i> Help</a></li></ul> <a href="#" class="nav-author__signout"><i class="uil uil-sign-out-alt"></i> Sign Out</a></div></div></div></div>`);
  });
}
function Sidebar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    store_get($$store_subs ??= {}, "$page", page).url.pathname;
    $$renderer2.push(`<aside class="sidebar">`);
    Svroller($$renderer2, {
      width: "100%",
      height: "100%",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="sidebar__menu-group"><ul class="sidebar_nav"><li class="has-child open"><a href="#" class="has-child__toggle active"><span class="nav-icon uil uil-create-dashboard"></span> <span class="menu-text">Dashboard</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item active"><a href="/home-one">Demo 1</a></li> <li class="menu-item"><a href="/home-two">Demo 2</a></li> <li class="menu-item"><a href="/home-three">Demo 3</a></li> <li class="menu-item"><a href="/home-four">Demo 4</a></li> <li class="menu-item"><a href="/home-five">Demo 5</a></li> <li class="menu-item"><a href="/home-six">Demo 6</a></li> <li class="menu-item"><a href="/home-seven">Demo 7</a></li> <li class="menu-item"><a href="/home-eight">Demo 8</a></li> <li class="menu-item"><a href="/home-nine">Demo 9</a></li> <li class="menu-item"><a href="/home-ten">Demo 10</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-window-section"></span> <span class="menu-text">Layouts</span> <span class="toggle-icon"></span></a> <ul><li class="l_navbar"><a href="#" class="menu-type-js" data-layout="top">Top Menu</a></li></ul></li> <li class="menu-item"><a href="/pages/changelog"><span class="nav-icon uil uil-arrow-growth"></span> <span class="menu-text">Changelogs</span> <span class="badge badge-info-10 menuItem rounded-pill">2.0.0</span></a></li> <li class="menu-title mt-30"><span>Applications</span></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-envelope"></span> <span class="menu-text">Email</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/email/inbox">Inbox</a></li> <li class="menu-item"><a href="/email/single">Read Email</a></li></ul></li> <li class="menu-item"><a href="/chat"><span class="nav-icon uil uil-chat"></span> <span class="menu-text">Chat</span> <span class="badge badge-success menuItem rounded-circle">3</span></a></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-bag"></span> <span class="menu-text text-initial">eCommerce</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/ecommerce/product-grid">Products</a></li> <li class="menu-item"><a href="/ecommerce/productDetails">Product Details</a></li> <li class="menu-item"><a href="/ecommerce/product-add">Product Add</a></li> <li class="menu-item"><a href="/ecommerce/product-add">Product Edit</a></li> <li class="menu-item"><a href="/ecommerce/cart">Cart</a></li> <li class="menu-item"><a href="/ecommerce/orders">Orders</a></li> <li class="menu-item"><a href="/ecommerce/sellers">Sellers</a></li> <li class="menu-item"><a href="/ecommerce/invoice">Invoices</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-folder"></span> <span class="menu-text">Project</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/projects/all-projects">Project</a></li> <li class="menu-item"><a href="/projects/project-single">Project Details</a></li></ul></li> <li class="menu-item"><a href="/calendar/day" class="has-child__toggle"><span class="nav-icon uil uil-calendar-alt"></span> <span class="menu-text">Calendar</span></a></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-users-alt"></span> <span class="menu-text">Users</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/users/team">Team</a></li> <li class="menu-item"><a href="/users/grid">Users Grid</a></li> <li class="menu-item"><a href="/users/list">Users List</a></li> <li class="menu-item"><a href="/users/grid-two">Users Grid style</a></li> <li class="menu-item"><a href="/users/group">Users Group</a></li> <li class="menu-item"><a href="/users/add-user">Add User</a></li> <li class="menu-item"><a href="/users/table">Users Table</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-at"></span> <span class="menu-text">Contacts</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/contacts/grid">Contacts Grid</a></li> <li class="menu-item"><a href="/contacts/list">Contacts List</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-apps"></span> <span class="menu-text">Social App</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/social/profile">My Profile</a></li> <li class="menu-item"><a href="/social/settings">Profile Settings</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-user"></span> <span class="menu-text">Support</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/support/tickets">Support Ticket</a></li> <li class="menu-item"><a href="/support/details">Ticket Details</a></li> <li class="menu-item"><a href="/support/create-ticket">New Ticket</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-clipboard-alt"></span> <span class="menu-text">Note</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/note/all">All</a></li> <li class="menu-item"><a href="/note/favorite">Favorite</a></li></ul></li> <li class="menu-item"><a href="/todo"><span class="nav-icon uil uil-check-square"></span> <span class="menu-text">Todo</span></a></li> <li class="menu-item"><a href="/task"><span class="nav-icon uil uil-lightbulb-alt"></span> <span class="menu-text">Task App</span></a></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-clipboard-alt"></span> <span class="menu-text">Import Export</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/import">Import</a></li> <li class="menu-item"><a href="/import/export">Export</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-books"></span> <span class="menu-text">learning App</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/course">Course</a></li> <li class="menu-item"><a href="/course/details">Details</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-search"></span> <span class="menu-text">Job Search</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/job/job-grid">Grid View</a></li> <li class="menu-item"><a href="/job/job-list">List View</a></li> <li class="menu-item"><a href="/job/job-details">Job Details</a></li> <li class="menu-item"><a href="/job/job-apply">Job Apply</a></li></ul></li> <li class="menu-title mt-30"><span>Features</span></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-layers"></span> <span class="menu-text">UI Elements</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/components/alerts">Alert</a></li> <li class="menu-item"><a href="/components/avatars">Avatar</a></li> <li class="menu-item"><a href="/components/badges">Badge</a></li> <li class="menu-item"><a href="/components/breadcrumbs">Breadcrumb</a></li> <li class="menu-item"><a href="/components/buttons">Button</a></li> <li class="menu-item"><a href="/components/cards">Cards</a></li> <li class="menu-item"><a href="/components/carousels">Carousel</a></li> <li class="menu-item"><a href="/components/checkbox">Checkbox</a></li> <li class="menu-item"><a href="/components/collapse">Collapse</a></li> <li class="menu-item"><a href="/components/comments">Comments</a></li> <li class="menu-item"><a href="/components/datepicker">DatePicker</a></li> <li class="menu-item"><a href="/components/drawer">Drawer</a></li> <li class="menu-item"><a href="/components/draggable-list">Draggable List</a></li> <li class="menu-item"><a href="/components/dropdown">Dropdown</a></li> <li class="menu-item"><a href="/components/empty">Empty</a></li> <li class="menu-item"><a href="/components/grid">Grid</a></li> <li class="menu-item"><a href="/components/input">Input</a></li> <li class="menu-item"><a href="/components/list">List</a></li> <li class="menu-item"><a href="/components/menu">Menu</a></li> <li class="menu-item"><a href="/components/message">Message</a></li> <li class="menu-item"><a href="/components/modals">Modals</a></li> <li class="menu-item"><a href="/components/notifications">Notifications</a></li> <li class="menu-item"><a href="/components/page-headers">Page Headers</a></li> <li class="menu-item"><a href="/components/paginations">Paginations</a></li> <li class="menu-item"><a href="/components/progress">Progress</a></li> <li class="menu-item"><a href="/components/radio">Radio</a></li> <li class="menu-item"><a href="/components/rate">Rate</a></li> <li class="menu-item"><a href="/components/result">Result</a></li> <li class="menu-item"><a href="/components/select">Select</a></li> <li class="menu-item"><a href="/components/skeleton">Skeleton</a></li> <li class="menu-item"><a href="/components/slider">Slider</a></li> <li class="menu-item"><a href="/components/spinner">Spinner</a></li> <li class="menu-item"><a href="/components/statistic">Statistic</a></li> <li class="menu-item"><a href="/components/steps">Steps</a></li> <li class="menu-item"><a href="/components/switch">Switch</a></li> <li class="menu-item"><a href="/components/tabs">Tabs</a></li> <li class="menu-item"><a href="/components/tags">Tags</a></li> <li class="menu-item"><a href="/components/timeline">Timeline</a></li> <li class="menu-item"><a href="/components/timepicker">Timepicker</a></li> <li class="menu-item"><a href="/components/typography">Typography</a></li> <li class="menu-item"><a href="/components/upload">Upload</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-chart"></span> <span class="menu-text">Charts</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/features/charts/chartjs">Chart JS</a></li> <li class="menu-item"><a href="/features/charts/apex-charts">Apex Charts</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-keyhole-circle"></span> <span class="menu-text">Forms</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/features/forms/basic">Basics</a></li> <li class="menu-item"><a href="/features/forms/layout">Layouts</a></li> <li class="menu-item"><a href="/features/forms/elements">Elements</a></li> <li class="menu-item"><a href="/features/forms/components">Components</a></li> <li class="menu-item"><a href="/features/forms/validations">Validations</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-server"></span> <span class="menu-text">Widget</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/features/widgets/charts">Chart</a></li> <li class="menu-item"><a href="/features/widgets/cards">Cards</a></li> <li class="menu-item"><a href="/features/widgets/mixed">Mixed</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-square"></span> <span class="menu-text">Wizards</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/features/wizard">Wizard 1</a></li></ul></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-grid"></span> <span class="menu-text">Icons</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/features/icons/unicons">Unicon Icons</a></li> <li class="menu-item"><a href="/features/icons/lineawesome">Line Awesome</a></li></ul></li> <li class="menu-item"><a href="/features/editor"><span class="nav-icon uil uil-edit"></span> <span class="menu-text">Editors</span></a></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-map"></span> <span class="menu-text">Maps</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/features/maps/google-maps">Google Maps</a></li> <li class="menu-item"><a href="/features/maps/leaflet-maps">Leaflet Maps</a></li> <li class="menu-item"><a href="/features/maps/vector-maps">Vector Maps</a></li></ul></li> <li class="menu-title mt-30"><span>Pages</span></li> <li class="menu-item"><a href="/pages/gallery"><span class="nav-icon uil uil-images"></span> <span class="menu-text">Gallery</span></a></li> <li class="menu-item"><a href="/pages/pricing"><span class="nav-icon uil uil-bill"></span> <span class="menu-text">Pricing</span></a></li> <li class="menu-item"><a href="/pages/banner"><span class="nav-icon uil uil-thumbs-up"></span> <span class="menu-text">Banners</span></a></li> <li class="menu-item"><a href="/pages/testimonial"><span class="nav-icon uil uil-book-open"></span> <span class="menu-text">Testimonial</span></a></li> <li class="menu-item"><a href="/pages/faqs"><span class="nav-icon uil uil-question-circle"></span> <span class="menu-text">FAQ's</span></a></li> <li class="menu-item"><a href="/pages/search-result"><span class="nav-icon uil uil-credit-card-search"></span> <span class="menu-text">Search Results</span></a></li> <li class="menu-item"><a href="/pages/blank"><span class="nav-icon uil uil-circle"></span> <span class="menu-text">Blank Page</span></a></li> <li class="menu-item"><a href="/pages/support"><span class="nav-icon uil uil-headphones"></span> <span class="menu-text">Support Center</span></a></li> <li class="has-child"><a href="#" class="has-child__toggle"><span class="nav-icon uil uil-images"></span> <span class="menu-text">Blog</span> <span class="toggle-icon"></span></a> <ul><li class="menu-item"><a href="/pages/blog/style-one">style 1</a></li> <li class="menu-item"><a href="/pages/blog/style-two">Style 2</a></li> <li class="menu-item"><a href="/pages/blog/style-three">Style 3</a></li> <li class="menu-item"><a href="/pages/blog/details">Details</a></li></ul></li> <li class="menu-item"><a href="/pages/terms"><span class="nav-icon uil uil-question-circle"></span> <span class="menu-text">Terms &amp; Conditions</span></a></li> <li class="menu-item"><a href="/pages/maintenance"><span class="nav-icon uil uil-airplay"></span> <span class="menu-text">Maintenance</span></a></li> <li class="menu-item"><a href="/pages/404"><span class="nav-icon uil uil-exclamation-triangle"></span> <span class="menu-text">404</span></a></li> <li class="menu-item"><a href="/pages/coming-soon"><span class="nav-icon uil uil-sync"></span> <span class="menu-text">Coming Soon</span></a></li></ul></div>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></aside>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function Footer($$renderer) {
  $$renderer.push(`<footer class="footer-wrapper"><div class="footer-wrapper__inside"><div class="container-fluid"><div class="row"><div class="col-md-6"><div class="footer-copyright"><p><span>© 2024</span><a href="#">SovWare</a></p></div></div> <div class="col-md-6"><div class="footer-menu text-end svelte-1b4fnhr"><ul class="svelte-1b4fnhr"><li class="svelte-1b4fnhr"><a href="#" class="svelte-1b4fnhr">About</a></li> <li class="svelte-1b4fnhr"><a href="#" class="svelte-1b4fnhr">Team</a></li> <li class="svelte-1b4fnhr"><a href="#" class="svelte-1b4fnhr">Contact</a></li></ul></div></div></div></div></div></footer>`);
}
export {
  Footer as F,
  LogoArea as L,
  NavSearch as N,
  Sidebar as S,
  NavMessage as a,
  NavNotification as b,
  NavSettings as c,
  NavFlags as d,
  NavAuthor as e
};
