import { a1 as store_get, ag as ensure_array_like, ad as attr_class, a8 as clsx, ac as attr, aa as escape_html, a3 as unsubscribe_stores, a9 as bind_props, ae as stringify } from "./index2.js";
import { B as Badge } from "./Badge.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { m as mailList, M as MailTop, a as MailBox } from "./MailTop.js";
function EmailList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let mailType = $$props["mailType"];
    const inboxMail = store_get($$store_subs ??= {}, "$mailList", mailList).allMails.filter((signleMail) => signleMail.type === mailType);
    $$renderer2.push(`<div class="mailbox-container"><div class="mailbar-toggle d-md-none"><span></span> <span></span> <span></span></div> <div class="mailbox-list">`);
    Card($$renderer2, {
      children: ($$renderer3) => {
        CardBody($$renderer3, {
          children: ($$renderer4) => {
            MailTop($$renderer4);
            $$renderer4.push(`<!----> <div class="mailbox-list__content"><!--[-->`);
            const each_array = ensure_array_like(inboxMail);
            for (let i = 0, $$length = each_array.length; i < $$length; i++) {
              let { username, img, subject, attach, body, stared, unread } = each_array[i];
              $$renderer4.push(`<div${attr_class(clsx(unread ? "mailbox-list__single d-flex justify-content-between active" : "mailbox-list__single d-flex justify-content-between"))}><div class="mail-authorBox d-flex"><div class="checkbox-theme-default custom-checkbox"><input class="checkbox" type="checkbox"${attr("id", `mail-${stringify(i)}`)}/> <label${attr("for", `mail-${stringify(i)}`)}></label></div> <a href="#" class="star-toggle"><i class="lar la-star"></i></a> <span class="author-info"><img${attr("src", `/img/chat-author/${stringify(img)}`)} alt="Admin Dashboard Template"/> <span class="author-name">${escape_html(username)}</span></span></div> <div class="mail-content"><div class="mail-content__top"><a href="/email/single"><h6 class="mail-title">${escape_html(subject)} `);
              Badge($$renderer4, {
                class: "badge-round",
                color: "transpaarent",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(mailType)}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></h6> <p>${escape_html(body)}</p></a></div> `);
              if (attach.length !== 0) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="mail-content__bottom"><!--[-->`);
                const each_array_1 = ensure_array_like(attach);
                for (let i2 = 0, $$length2 = each_array_1.length; i2 < $$length2; i2++) {
                  let attachItem = each_array_1[i2];
                  $$renderer4.push(`<a href="#" class="mail-attatchment"><i class="las la-paperclip"></i> <span class="attatched-file">${escape_html(attachItem)}</span></a>`);
                }
                $$renderer4.push(`<!--]--></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--></div> <span class="time-meta">8:30 PM</span></div>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          },
          $$slots: { default: true }
        });
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----></div></div> `);
    MailBox($$renderer2);
    $$renderer2.push(`<!---->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { mailType });
  });
}
export {
  EmailList as E
};
