import { a6 as fallback, aa as escape_html, ad as attr_class, ac as attr, a9 as bind_props, al as attr_style, ag as ensure_array_like, ae as stringify, ab as store_mutate, a1 as store_get, $ as setContext, a3 as unsubscribe_stores } from "./index2.js";
import { g as get, w as writable } from "./index.js";
import { h as html } from "./html.js";
let t = {};
const exec = (command, value = null) => {
  document.execCommand(command, false, value);
};
const saveRange = (editor) => {
  const documentSelection = document.getSelection();
  t.range = null;
  if (documentSelection.rangeCount) {
    let savedRange = t.range = documentSelection.getRangeAt(0);
    let range = document.createRange();
    let rangeStart;
    range.selectNodeContents(editor);
    range.setEnd(savedRange.startContainer, savedRange.startOffset);
    rangeStart = (range + "").length;
    t.metaRange = {
      start: rangeStart,
      end: rangeStart + (savedRange + "").length
    };
  }
};
const restoreRange = (editor) => {
  let metaRange = t.metaRange;
  let savedRange = t.range;
  let documentSelection = document.getSelection();
  let range;
  if (!savedRange) {
    return;
  }
  if (metaRange && metaRange.start !== metaRange.end) {
    let charIndex = 0, nodeStack = [editor], node, foundStart = false, stop = false;
    range = document.createRange();
    while (!stop && (node = nodeStack.pop())) {
      if (node.nodeType === 3) {
        let nextCharIndex = charIndex + node.length;
        if (!foundStart && metaRange.start >= charIndex && metaRange.start <= nextCharIndex) {
          range.setStart(node, metaRange.start - charIndex);
          foundStart = true;
        }
        if (foundStart && metaRange.end >= charIndex && metaRange.end <= nextCharIndex) {
          range.setEnd(node, metaRange.end - charIndex);
          stop = true;
        }
        charIndex = nextCharIndex;
      } else {
        let cn = node.childNodes;
        let i = cn.length;
        while (i > 0) {
          i -= 1;
          nodeStack.push(cn[i]);
        }
      }
    }
  }
  documentSelection.removeAllRanges();
  documentSelection.addRange(range || savedRange);
};
const unwrap = (wrapper) => {
  const docFrag = document.createDocumentFragment();
  while (wrapper.firstChild) {
    const child = wrapper.removeChild(wrapper.firstChild);
    docFrag.appendChild(child);
  }
  wrapper.parentNode.replaceChild(docFrag, wrapper);
};
const removeBlockTagsRecursive = (elements, tagsToRemove) => {
  Array.from(elements).forEach((item) => {
    if (tagsToRemove.some((tag) => tag === item.tagName.toLowerCase())) {
      if (item.children.length) {
        removeBlockTagsRecursive(item.children, tagsToRemove);
      }
      unwrap(item);
    }
  });
};
const getActionBtns = (actions) => {
  return Object.keys(actions).map((action) => actions[action]);
};
const getNewActionObj = (actions, userActions = []) => {
  if (userActions && userActions.length) {
    const newActions = {};
    userActions.forEach((action) => {
      if (typeof action === "string") {
        newActions[action] = Object.assign({}, actions[action]);
      } else if (actions[action.name]) {
        newActions[action.name] = Object.assign(actions[action.name], action);
      } else {
        newActions[action.name] = Object.assign({}, action);
      }
    });
    return newActions;
  } else {
    return actions;
  }
};
const removeBadTags = (html2) => {
  ["style", "script", "applet", "embed", "noframes", "noscript"].forEach((badTag) => {
    html2 = html2.replace(new RegExp(`<${badTag}.*?${badTag}(.*?)>`, "gi"), "");
  });
  return html2;
};
const linkSvg = '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M31.1 48.9l-6.7 6.7c-.8.8-1.6.9-2.1.9s-1.4-.1-2.1-.9L15 50.4c-1.1-1.1-1.1-3.1 0-4.2l6.1-6.1.2-.2 6.5-6.5c-1.2-.6-2.5-.9-3.8-.9-2.3 0-4.6.9-6.3 2.6L11 41.8c-3.5 3.5-3.5 9.2 0 12.7l5.2 5.2c1.7 1.7 4 2.6 6.3 2.6s4.6-.9 6.3-2.6l6.7-6.7c2.5-2.6 3.1-6.7 1.5-10l-5.9 5.9zM38.7 22.5l6.7-6.7c.8-.8 1.6-.9 2.1-.9s1.4.1 2.1.9l5.2 5.2c1.1 1.1 1.1 3.1 0 4.2l-6.1 6.1-.2.2L42 38c1.2.6 2.5.9 3.8.9 2.3 0 4.6-.9 6.3-2.6l6.7-6.7c3.5-3.5 3.5-9.2 0-12.7l-5.2-5.2c-1.7-1.7-4-2.6-6.3-2.6s-4.6.9-6.3 2.6l-6.7 6.7c-2.7 2.7-3.3 6.9-1.7 10.2l6.1-6.1c0 .1 0 .1 0 0z"></path><path d="M44.2 30.5c.2-.2.4-.6.4-.9 0-.3-.1-.6-.4-.9l-2.3-2.3c-.3-.2-.6-.4-.9-.4-.3 0-.6.1-.9.4L25.9 40.6c-.2.2-.4.6-.4.9 0 .3.1.6.4.9l2.3 2.3c.2.2.6.4.9.4.3 0 .6-.1.9-.4l14.2-14.2zM49.9 55.4h-8.5v-5h8.5v-8.9h5.2v8.9h8.5v5h-8.5v8.9h-5.2v-8.9z"></path></svg>';
const unlinkSvg = '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M30.9 49.1l-6.7 6.7c-.8.8-1.6.9-2.1.9s-1.4-.1-2.1-.9l-5.2-5.2c-1.1-1.1-1.1-3.1 0-4.2l6.1-6.1.2-.2 6.5-6.5c-1.2-.6-2.5-.9-3.8-.9-2.3 0-4.6.9-6.3 2.6L10.8 42c-3.5 3.5-3.5 9.2 0 12.7l5.2 5.2c1.7 1.7 4 2.6 6.3 2.6s4.6-.9 6.3-2.6l6.7-6.7C38 50.5 38.6 46.3 37 43l-6.1 6.1zM38.5 22.7l6.7-6.7c.8-.8 1.6-.9 2.1-.9s1.4.1 2.1.9l5.2 5.2c1.1 1.1 1.1 3.1 0 4.2l-6.1 6.1-.2.2-6.5 6.5c1.2.6 2.5.9 3.8.9 2.3 0 4.6-.9 6.3-2.6l6.7-6.7c3.5-3.5 3.5-9.2 0-12.7l-5.2-5.2c-1.7-1.7-4-2.6-6.3-2.6s-4.6.9-6.3 2.6l-6.7 6.7c-2.7 2.7-3.3 6.9-1.7 10.2l6.1-6.1z"></path><path d="M44.1 30.7c.2-.2.4-.6.4-.9 0-.3-.1-.6-.4-.9l-2.3-2.3c-.2-.2-.6-.4-.9-.4-.3 0-.6.1-.9.4L25.8 40.8c-.2.2-.4.6-.4.9 0 .3.1.6.4.9l2.3 2.3c.2.2.6.4.9.4.3 0 .6-.1.9-.4l14.2-14.2zM41.3 55.8v-5h22.2v5H41.3z"></path></svg>';
const defaultActions = {
  viewHtml: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path fill="none" stroke="currentColor" stroke-width="8" stroke-miterlimit="10" d="M26.9 17.9L9 36.2 26.9 54M45 54l17.9-18.3L45 17.9"></path></svg>',
    title: "View HTML",
    result: function() {
      let refs = get(this.references);
      let actionObj = get(this.state).actionObj;
      let helper = get(this.helper);
      helper.showEditor = !helper.showEditor;
      refs.editor.style.display = helper.showEditor ? "block" : "none";
      refs.raw.style.display = helper.showEditor ? "none" : "block";
      if (helper.showEditor) {
        refs.editor.innerHTML = refs.raw.value;
      } else {
        refs.raw.value = refs.editor.innerHTML;
      }
      setTimeout(() => {
        Object.keys(actionObj).forEach(
          (action) => actionObj[action].disabled = !helper.showEditor
        );
        actionObj.viewHtml.disabled = false;
        actionObj.viewHtml.active = !helper.showEditor;
        this.state.update((state2) => {
          state2.actionBtns = getActionBtns(actionObj);
          state2.actionObj = actionObj;
          return state2;
        });
      });
    }
  },
  undo: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M61.2 51.2c0-5.1-2.1-9.7-5.4-13.1-3.3-3.3-8-5.4-13.1-5.4H26.1v-12L10.8 36l15.3 15.3V39.1h16.7c3.3 0 6.4 1.3 8.5 3.5 2.2 2.2 3.5 5.2 3.5 8.5h6.4z"></path></svg>',
    title: "Undo",
    result: () => exec("undo")
  },
  redo: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M10.8 51.2c0-5.1 2.1-9.7 5.4-13.1 3.3-3.3 8-5.4 13.1-5.4H46v-12L61.3 36 45.9 51.3V39.1H29.3c-3.3 0-6.4 1.3-8.5 3.5-2.2 2.2-3.5 5.2-3.5 8.5h-6.5z"></path></svg>',
    title: "Redo",
    result: () => exec("redo")
  },
  b: {
    icon: "<b>B</b>",
    title: "Bold",
    result: () => exec("bold")
  },
  i: {
    icon: "<i>I</i>",
    title: "Italic",
    result: () => exec("italic")
  },
  u: {
    icon: "<u>U</u>",
    title: "Underline",
    result: () => exec("underline")
  },
  strike: {
    icon: "<strike>S</strike>",
    title: "Strike-through",
    result: () => exec("strikeThrough")
  },
  sup: {
    icon: "A<sup>2</sup>",
    title: "Superscript",
    result: () => exec("superscript")
  },
  sub: {
    icon: "A<sub>2</sub>",
    title: "Subscript",
    result: () => exec("subscript")
  },
  h1: {
    icon: "<b>H<sub>1</sub></b>",
    title: "Heading 1",
    result: () => exec("formatBlock", "<H1>")
  },
  h2: {
    icon: "<b>H<sub>2</sub></b>",
    title: "Heading 2",
    result: () => exec("formatBlock", "<H2>")
  },
  p: {
    icon: "&#182;",
    title: "Paragraph",
    result: () => exec("formatBlock", "<P>")
  },
  blockquote: {
    icon: "&#8220; &#8221;",
    title: "Quote",
    result: () => exec("formatBlock", "<BLOCKQUOTE>")
  },
  ol: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M27 14h36v8H27zM27 50h36v8H27zM27 32h36v8H27zM11.8 15.8V22h1.8v-7.8h-1.5l-2.1 1 .3 1.3zM12.1 38.5l.7-.6c1.1-1 2.1-2.1 2.1-3.4 0-1.4-1-2.4-2.7-2.4-1.1 0-2 .4-2.6.8l.5 1.3c.4-.3 1-.6 1.7-.6.9 0 1.3.5 1.3 1.1 0 .9-.9 1.8-2.6 3.3l-1 .9V40H15v-1.5h-2.9zM13.3 53.9c1-.4 1.4-1 1.4-1.8 0-1.1-.9-1.9-2.6-1.9-1 0-1.9.3-2.4.6l.4 1.3c.3-.2 1-.5 1.6-.5.8 0 1.2.3 1.2.8 0 .7-.8.9-1.4.9h-.7v1.3h.7c.8 0 1.6.3 1.6 1.1 0 .6-.5 1-1.4 1-.7 0-1.5-.3-1.8-.5l-.4 1.4c.5.3 1.3.6 2.3.6 2 0 3.2-1 3.2-2.4 0-1.1-.8-1.8-1.7-1.9z"></path></svg>',
    title: "Ordered List",
    result: () => exec("insertOrderedList")
  },
  ul: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M27 14h36v8H27zM27 50h36v8H27zM9 50h9v8H9zM9 32h9v8H9zM9 14h9v8H9zM27 32h36v8H27z"></path></svg>',
    title: "Unordered List",
    result: () => exec("insertUnorderedList")
  },
  hr: {
    icon: "&#8213;",
    title: "Horizontal Line",
    result: () => exec("insertHorizontalRule")
  },
  left: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M9 14h54v8H9zM9 50h54v8H9zM9 32h36v8H9z"></path></svg>',
    title: "Justify left",
    result: () => exec("justifyLeft")
  },
  right: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M9 14h54v8H9zM9 50h54v8H9zM27 32h36v8H27z"></path></svg>',
    title: "Justify right",
    result: () => exec("justifyRight")
  },
  center: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M9 14h54v8H9zM9 50h54v8H9zM18 32h36v8H18z"></path></svg>',
    title: "Justify center",
    result: () => exec("justifyCenter")
  },
  justify: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M9 14h54v8H9zM9 50h54v8H9zM9 32h54v8H9z"></path></svg>',
    title: "Justify full",
    result: () => exec("justifyFull")
  },
  a: {
    icon: linkSvg,
    title: "Insert link",
    result: function() {
      const actionObj = get(this.state).actionObj;
      const refs = get(this.references);
      if (actionObj.a.active) {
        const selection = window.getSelection();
        const range = document.createRange();
        range.selectNodeContents(document.getSelection().focusNode);
        selection.removeAllRanges();
        selection.addRange(range);
        exec("unlink");
        actionObj.a.title = "Insert link";
        actionObj.a.icon = linkSvg;
        this.state.update((state2) => {
          state2.actionBtn = getActionBtns(actionObj);
          state2.actionObj = actionObj;
          return state2;
        });
      } else {
        saveRange(refs.editor);
        refs.modal.$set({
          show: true,
          event: "linkUrl",
          title: "Insert link",
          label: "Url"
        });
        if (!get(this.helper).link) {
          this.helper.update((state2) => {
            state2.link = true;
            return state2;
          });
          refs.modal.$on("linkUrl", (event) => {
            restoreRange(refs.editor);
            exec("createLink", event.detail);
            actionObj.a.title = "Unlink";
            actionObj.a.icon = unlinkSvg;
            this.state.update((state2) => {
              state2.actionBtn = getActionBtns(actionObj);
              state2.actionObj = actionObj;
              return state2;
            });
          });
        }
      }
    }
  },
  image: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M64 17v38H8V17h56m8-8H0v54h72V9z"></path><path d="M17.5 22C15 22 13 24 13 26.5s2 4.5 4.5 4.5 4.5-2 4.5-4.5-2-4.5-4.5-4.5zM16 50h27L29.5 32zM36 36.2l8.9-8.5L60.2 50H45.9S35.6 35.9 36 36.2z"></path></svg>',
    title: "Image",
    result: function() {
      const refs = get(this.references);
      saveRange(refs.editor);
      refs.modal.$set({
        show: true,
        event: "imageUrl",
        title: "Insert image",
        label: "Url"
      });
      if (!get(this.helper).image) {
        this.helper.update((state2) => {
          state2.image = true;
          return state2;
        });
        refs.modal.$on("imageUrl", (event) => {
          restoreRange(refs.editor);
          exec("insertImage", event.detail);
        });
      }
    }
  },
  forecolor: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M32 15h7.8L56 57.1h-7.9l-4-11.1H27.4l-4 11.1h-7.6L32 15zm-2.5 25.4h12.9L36 22.3h-.2l-6.3 18.1z"></path></svg>',
    title: "Text color",
    colorPicker: true,
    result: function() {
      showColorPicker.call(this, "foreColor");
    }
  },
  backcolor: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M36.5 22.3l-6.3 18.1H43l-6.3-18.1z"></path><path d="M9 8.9v54.2h54.1V8.9H9zm39.9 48.2L45 46H28.2l-3.9 11.1h-7.6L32.8 15h7.8l16.2 42.1h-7.9z"></path></svg>',
    title: "Background color",
    colorPicker: true,
    result: function() {
      showColorPicker.call(this, "backColor");
    }
  },
  removeFormat: {
    icon: '<svg viewBox="0 0 72 72" width="17px" height="100%"><path d="M58.2 54.6L52 48.5l3.6-3.6 6.1 6.1 6.4-6.4 3.8 3.8-6.4 6.4 6.1 6.1-3.6 3.6-6.1-6.1-6.4 6.4-3.7-3.8 6.4-6.4zM21.7 52.1H50V57H21.7zM18.8 15.2h34.1v6.4H39.5v24.2h-7.4V21.5H18.8v-6.3z"></path></svg>',
    title: "Remove format",
    result: function() {
      const refs = get(this.references);
      const selection = window.getSelection();
      if (!selection.toString().length) {
        removeBlockTagsRecursive(
          refs.editor.children,
          this.removeFormatTags
        );
        const range = document.createRange();
        range.selectNodeContents(refs.editor);
        selection.removeAllRanges();
        selection.addRange(range);
      }
      exec("removeFormat");
      selection.removeAllRanges();
    }
  }
};
const showColorPicker = function(cmd) {
  const refs = get(this.references);
  saveRange(refs.editor);
  refs.colorPicker.$set({ show: true, event: cmd });
  if (!get(this.helper)[cmd]) {
    this.helper.update((state2) => {
      state2[cmd] = true;
      return state2;
    });
    refs.colorPicker.$on(cmd, (event) => {
      let item = event.detail;
      if (item.modal) {
        refs.modal.$set({
          show: true,
          event: `${cmd}Changed`,
          title: "Text color",
          label: cmd === "foreColor" ? "Text color" : "Background color"
        });
        const command = cmd;
        if (!get(this.helper)[`${command}Modal`]) {
          get(this.helper)[`${command}Modal`] = true;
          refs.modal.$on(`${command}Changed`, (event2) => {
            let color = event2.detail;
            restoreRange(refs.editor);
            exec(command, color);
          });
        }
      } else {
        restoreRange(refs.editor);
        exec(cmd, item.color);
      }
    });
  }
};
function EditorModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let show = fallback($$props["show"], false);
    let text = fallback($$props["text"], "");
    let event = fallback($$props["event"], "");
    let title = fallback($$props["title"], "");
    let label = fallback($$props["label"], "");
    let error = fallback($$props["error"], false);
    let refs = {};
    {
      if (show) {
        setTimeout(() => {
          refs.text.focus();
        });
      }
    }
    if (show) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="cl-editor-overlay svelte-1pmf9fg"></div> <div class="cl-editor-modal svelte-1pmf9fg"><div class="modal-box svelte-1pmf9fg"><span class="modal-title svelte-1pmf9fg">${escape_html(title)}</span> <form><label${attr_class("modal-label svelte-1pmf9fg", void 0, { "input-error": error })}><input name="text"${attr("value", text)} class="svelte-1pmf9fg"/> <span class="input-info svelte-1pmf9fg"><span class="svelte-1pmf9fg">${escape_html(label)}</span> `);
      if (error) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span class="msg-error svelte-1pmf9fg">Required</span>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></span></label> <button class="modal-button modal-submit svelte-1pmf9fg" type="submit">Confirm</button> <button class="modal-button modal-reset svelte-1pmf9fg" type="reset">Cancel</button></form></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { show, text, event, title, label, error });
  });
}
function EditorColorPicker($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let show = fallback($$props["show"], false);
    let btns = fallback($$props["btns"], () => [], true);
    let event = fallback($$props["event"], "");
    let colors = fallback($$props["colors"], () => [], true);
    btns = colors.map((color) => ({ color })).concat([{ text: "#", modal: true }]);
    $$renderer2.push(`<div${attr_style(`display: ${stringify(show ? "block" : "none")}`)}><div class="color-picker-overlay svelte-1kc3tg8"></div> <div class="color-picker-wrapper svelte-1kc3tg8"><!--[-->`);
    const each_array = ensure_array_like(btns);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let btn = each_array[$$index];
      $$renderer2.push(`<button type="button" class="color-picker-btn svelte-1kc3tg8"${attr_style(`background-color:${stringify(btn.color)};`)}>${escape_html(btn.text || "")}</button>`);
    }
    $$renderer2.push(`<!--]--></div></div>`);
    bind_props($$props, { show, btns, event, colors });
  });
}
const state = (function(name) {
  let state2 = {
    actionBtns: [],
    actionObj: {}
  };
  const { subscribe, set, update } = writable(state2);
  return {
    name,
    set,
    update,
    subscribe
  };
});
const createStateStore = state;
const editors = [];
function Editor($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let actions = fallback($$props["actions"], () => [], true);
    let height = fallback($$props["height"], "300px");
    let html$1 = fallback($$props["html"], "");
    let contentId = fallback($$props["contentId"], "");
    let colors = fallback(
      $$props["colors"],
      () => [
        "#ffffff",
        "#000000",
        "#eeece1",
        "#1f497d",
        "#4f81bd",
        "#c0504d",
        "#9bbb59",
        "#8064a2",
        "#4bacc6",
        "#f79646",
        "#ffff00",
        "#f2f2f2",
        "#7f7f7f",
        "#ddd9c3",
        "#c6d9f0",
        "#dbe5f1",
        "#f2dcdb",
        "#ebf1dd",
        "#e5e0ec",
        "#dbeef3",
        "#fdeada",
        "#fff2ca",
        "#d8d8d8",
        "#595959",
        "#c4bd97",
        "#8db3e2",
        "#b8cce4",
        "#e5b9b7",
        "#d7e3bc",
        "#ccc1d9",
        "#b7dde8",
        "#fbd5b5",
        "#ffe694",
        "#bfbfbf",
        "#3f3f3f",
        "#938953",
        "#548dd4",
        "#95b3d7",
        "#d99694",
        "#c3d69b",
        "#b2a2c7",
        "#b7dde8",
        "#fac08f",
        "#f2c314",
        "#a5a5a5",
        "#262626",
        "#494429",
        "#17365d",
        "#366092",
        "#953734",
        "#76923c",
        "#5f497a",
        "#92cddc",
        "#e36c09",
        "#c09100",
        "#7f7f7f",
        "#0c0c0c",
        "#1d1b10",
        "#0f243e",
        "#244061",
        "#632423",
        "#4f6128",
        "#3f3151",
        "#31859b",
        "#974806",
        "#7f6000"
      ],
      true
    );
    let removeFormatTags = fallback($$props["removeFormatTags"], () => ["h1", "h2", "blockquote"], true);
    let helper = writable({
      foreColor: false,
      backColor: false,
      foreColorModal: false,
      backColorModal: false,
      image: false,
      link: false,
      showEditor: true,
      blurActive: false
    });
    editors.push({});
    let contextKey = "editor_" + editors.length;
    let state2 = createStateStore(contextKey);
    let references = writable({});
    store_mutate($$store_subs ??= {}, "$state", state2, store_get($$store_subs ??= {}, "$state", state2).actionObj = getNewActionObj(defaultActions, actions));
    let context = {
      exec: exec$1,
      getHtml,
      getText,
      setHtml,
      saveRange: saveRange$1,
      restoreRange: restoreRange$1,
      helper,
      references,
      state: state2,
      removeFormatTags
    };
    setContext(contextKey, context);
    function exec$1(cmd, value) {
      exec(cmd, value);
    }
    function getHtml(sanitize) {
      return sanitize ? removeBadTags(store_get($$store_subs ??= {}, "$references", references).editor.innerHTML) : store_get($$store_subs ??= {}, "$references", references).editor.innerHTML;
    }
    function getText() {
      return store_get($$store_subs ??= {}, "$references", references).editor.innerText;
    }
    function setHtml(html2, sanitize) {
      const htmlData = sanitize ? removeBadTags(html2) : html2 || "";
      store_mutate($$store_subs ??= {}, "$references", references, store_get($$store_subs ??= {}, "$references", references).editor.innerHTML = htmlData);
      store_mutate($$store_subs ??= {}, "$references", references, store_get($$store_subs ??= {}, "$references", references).raw.value = htmlData);
    }
    function saveRange$1() {
      saveRange(store_get($$store_subs ??= {}, "$references", references).editor);
    }
    function restoreRange$1() {
      restoreRange(store_get($$store_subs ??= {}, "$references", references).editor);
    }
    const refs = store_get($$store_subs ??= {}, "$references", references);
    $$renderer2.push(`<div class="cl svelte-1jghbpn"><div class="cl-actionbar svelte-1jghbpn"><!--[-->`);
    const each_array = ensure_array_like(store_get($$store_subs ??= {}, "$state", state2).actionBtns);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let action = each_array[$$index];
      $$renderer2.push(`<button type="button"${attr_class(`cl-button ${stringify(action.active ? "active" : "")}`, "svelte-1jghbpn")}${attr("title", action.title)}${attr("disabled", action.disabled, true)}>${html(action.icon)}</button>`);
    }
    $$renderer2.push(`<!--]--></div> <div${attr("id", contentId)} class="cl-content svelte-1jghbpn"${attr_style(`height: ${stringify(height)}`)} contenteditable="true"></div> <textarea class="cl-textarea svelte-1jghbpn"${attr_style(`max-height: ${stringify(height)}; min-height: ${stringify(height)}`)}></textarea> `);
    EditorModal($$renderer2, {});
    $$renderer2.push(`<!----> `);
    EditorColorPicker($$renderer2, { colors });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      actions,
      height,
      html: html$1,
      contentId,
      colors,
      removeFormatTags,
      exec: exec$1,
      getHtml,
      getText,
      setHtml,
      saveRange: saveRange$1,
      restoreRange: restoreRange$1,
      refs
    });
  });
}
export {
  Editor as E
};
