import { a4 as sanitize_props, a5 as rest_props, $ as setContext, am as getContext, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props, a1 as store_get, a3 as unsubscribe_stores, aa as escape_html } from "./index2.js";
import { o as onDestroy } from "./index-server.js";
import { createPopper } from "@popperjs/core";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
import { w as writable } from "./index.js";
function createPopperActions(initOptions) {
  let contentNode;
  let options = initOptions;
  let popperInstance = null;
  let referenceNode;
  const initPopper = () => {
    if (referenceNode && contentNode) {
      popperInstance = createPopper(referenceNode, contentNode, options);
    }
  };
  const deinitPopper = () => {
    if (popperInstance) {
      popperInstance.destroy();
      popperInstance = null;
    }
  };
  const referenceAction = (node) => {
    referenceNode = node;
    initPopper();
    return {
      destroy() {
        deinitPopper();
      }
    };
  };
  const contentAction = (node, contentOptions) => {
    contentNode = node;
    options = Object.assign(Object.assign({}, initOptions), contentOptions);
    initPopper();
    return {
      update(newContentOptions) {
        options = Object.assign(Object.assign({}, initOptions), newContentOptions);
        if (popperInstance && options) {
          popperInstance.setOptions(options);
        }
      },
      destroy() {
        deinitPopper();
      }
    };
  };
  return [referenceAction, contentAction, () => popperInstance];
}
const createContext = () => writable({});
function Dropdown($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "active",
    "autoClose",
    "direction",
    "dropup",
    "group",
    "inNavbar",
    "isOpen",
    "nav",
    "setActiveFromChild",
    "size",
    "theme",
    "toggle"
  ]);
  $$renderer.component(($$renderer2) => {
    let subItemIsActive, handleToggle, classes;
    const noop = () => void 0;
    let context = createContext();
    setContext("dropdownContext", context);
    const navbarContext = getContext("navbar");
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    let autoClose = fallback($$props["autoClose"], true);
    let direction = fallback($$props["direction"], "down");
    let dropup = fallback($$props["dropup"], false);
    let group = fallback($$props["group"], false);
    let inNavbar = fallback($$props["inNavbar"], () => navbarContext ? navbarContext.inNavbar : false, true);
    let isOpen = fallback($$props["isOpen"], false);
    let nav = fallback($$props["nav"], false);
    let setActiveFromChild = fallback($$props["setActiveFromChild"], false);
    let size = fallback($$props["size"], "");
    let theme = fallback($$props["theme"], null);
    let toggle = fallback($$props["toggle"], void 0);
    const [popperRef, popperContent] = createPopperActions();
    const validDirections = ["up", "down", "left", "right", "start", "end"];
    if (validDirections.indexOf(direction) === -1) {
      throw new Error(`Invalid direction sent: '${direction}' is not one of 'up', 'down', 'left', 'right', 'start', 'end'`);
    }
    let component;
    let dropdownDirection;
    function handleDocumentClick(e) {
      if (e && (e.which === 3 || e.type === "keyup" && e.which !== 9)) return;
      if (component.contains(e.target) && component !== e.target && (e.type !== "keyup" || e.which === 9)) {
        return;
      }
      if (autoClose === true || autoClose === "outside") {
        handleToggle(e);
      }
    }
    onDestroy(() => {
      if (typeof document !== "undefined") {
        ["click", "touchstart", "keyup"].forEach((event) => document.removeEventListener(event, handleDocumentClick, true));
      }
    });
    subItemIsActive = false;
    {
      if (direction === "left") dropdownDirection = "start";
      else if (direction === "right") dropdownDirection = "end";
      else dropdownDirection = direction;
    }
    handleToggle = toggle || (() => isOpen = !isOpen);
    classes = classnames(className, direction !== "down" && `drop${dropdownDirection}`, nav && active ? "active" : false, setActiveFromChild && subItemIsActive ? "active" : false, {
      "btn-group": group,
      [`btn-group-${size}`]: !!size,
      dropdown: !group,
      show: isOpen,
      "nav-item": nav
    });
    {
      if (typeof document !== "undefined") {
        if (isOpen) {
          ["click", "touchstart", "keyup"].forEach((event) => document.addEventListener(event, handleDocumentClick, true));
        } else {
          ["click", "touchstart", "keyup"].forEach((event) => document.removeEventListener(event, handleDocumentClick, true));
        }
      }
    }
    {
      context.update(() => {
        return {
          toggle: handleToggle,
          isOpen,
          autoClose,
          direction: direction === "down" && dropup ? "up" : direction,
          inNavbar: nav || inNavbar,
          popperRef: nav ? noop : popperRef,
          popperContent: nav ? noop : popperContent
        };
      });
    }
    if (nav) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<li${attributes({
        ...$$restProps,
        class: clsx(classes),
        "data-bs-theme": theme
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></li>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div${attributes({
        ...$$restProps,
        class: clsx(classes),
        "data-bs-theme": theme
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      class: className,
      active,
      autoClose,
      direction,
      dropup,
      group,
      inNavbar,
      isOpen,
      nav,
      setActiveFromChild,
      size,
      theme,
      toggle
    });
  });
}
function DropdownMenu($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "end", "right"]);
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let classes;
    const context = getContext("dropdownContext");
    let className = fallback($$props["class"], "");
    let end = fallback($$props["end"], false);
    let right = fallback($$props["right"], false);
    const popperPlacement = (direction, end2) => {
      let prefix = direction;
      if (direction === "up") {
        prefix = "top";
      }
      if (direction === "down") {
        prefix = "bottom";
      }
      let suffix = end2 ? "end" : "start";
      return `${prefix}-${suffix}`;
    };
    ({
      modifiers: [
        { name: "flip" },
        { name: "offset", options: { offset: [0, 2] } }
      ],
      placement: popperPlacement(store_get($$store_subs ??= {}, "$context", context).direction, end || right)
    });
    classes = classnames(className, "dropdown-menu", {
      "dropdown-menu-end": end || right,
      show: store_get($$store_subs ??= {}, "$context", context).isOpen
    });
    $$renderer2.push(`<ul${attributes({
      ...$$restProps,
      class: clsx(classes),
      "data-bs-popper": store_get($$store_subs ??= {}, "$context", context).inNavbar ? "static" : void 0
    })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></ul>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { class: className, end, right });
  });
}
function DropdownToggle($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "ariaLabel",
    "active",
    "block",
    "caret",
    "color",
    "disabled",
    "inner",
    "nav",
    "outline",
    "size",
    "split",
    "tag"
  ]);
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let classes, btnClasses;
    const context = getContext("dropdownContext");
    let className = fallback($$props["class"], "");
    let ariaLabel = fallback($$props["ariaLabel"], "Toggle Dropdown");
    let active = fallback($$props["active"], false);
    let block = fallback($$props["block"], false);
    let caret = fallback($$props["caret"], false);
    let color = fallback($$props["color"], "secondary");
    let disabled = fallback($$props["disabled"], false);
    let inner = fallback($$props["inner"], void 0);
    let nav = fallback($$props["nav"], false);
    let outline = fallback($$props["outline"], false);
    let size = fallback($$props["size"], "");
    let split = fallback($$props["split"], false);
    let tag = fallback($$props["tag"], null);
    classes = classnames(className, {
      "dropdown-toggle": caret || split,
      "dropdown-toggle-split": split,
      "nav-link": nav,
      show: store_get($$store_subs ??= {}, "$context", context).isOpen
    });
    btnClasses = classnames(classes, "btn", `btn${outline ? "-outline" : ""}-${color}`, size ? `btn-${size}` : false, block ? "d-block w-100" : false, { active });
    if (nav) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a${attributes({
        ...$$restProps,
        href: "#nav",
        "aria-expanded": store_get($$store_subs ??= {}, "$context", context).isOpen,
        class: clsx(classes)
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, () => {
        $$renderer2.push(`<span class="visually-hidden">${escape_html(ariaLabel)}</span>`);
      });
      $$renderer2.push(`<!--]--></a>`);
    } else if (tag === "div") {
      $$renderer2.push("<!--[1-->");
      $$renderer2.push(`<div${attributes({
        ...$$restProps,
        "aria-expanded": store_get($$store_subs ??= {}, "$context", context).isOpen,
        class: clsx(classes)
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, () => {
        $$renderer2.push(`<span class="visually-hidden">${escape_html(ariaLabel)}</span>`);
      });
      $$renderer2.push(`<!--]--></div>`);
    } else if (tag === "span") {
      $$renderer2.push("<!--[2-->");
      $$renderer2.push(`<span${attributes({
        ...$$restProps,
        "aria-expanded": store_get($$store_subs ??= {}, "$context", context).isOpen,
        class: clsx(classes)
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, () => {
        $$renderer2.push(`<span class="visually-hidden">${escape_html(ariaLabel)}</span>`);
      });
      $$renderer2.push(`<!--]--></span>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button${attributes({
        ...$$restProps,
        type: "button",
        "aria-expanded": store_get($$store_subs ??= {}, "$context", context).isOpen,
        class: clsx(btnClasses)
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, () => {
        $$renderer2.push(`<span class="visually-hidden">${escape_html(ariaLabel)}</span>`);
      });
      $$renderer2.push(`<!--]--></button>`);
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      class: className,
      ariaLabel,
      active,
      block,
      caret,
      color,
      disabled,
      inner,
      nav,
      outline,
      size,
      split,
      tag
    });
  });
}
export {
  Dropdown as D,
  DropdownToggle as a,
  DropdownMenu as b
};
