import { a4 as sanitize_props, a5 as rest_props, am as getContext, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function DropdownItem($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "active",
    "disabled",
    "divider",
    "header",
    "toggle",
    "href"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    getContext("dropdownContext");
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    let disabled = fallback($$props["disabled"], false);
    let divider = fallback($$props["divider"], false);
    let header = fallback($$props["header"], false);
    let toggle = fallback($$props["toggle"], true);
    let href = fallback($$props["href"], "");
    classes = classnames(className, {
      disabled,
      "dropdown-item": !divider && !header,
      active,
      "dropdown-header": header,
      "dropdown-divider": divider
    });
    $$renderer2.push(`<li>`);
    if (header) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<h6${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></h6>`);
    } else if (divider) {
      $$renderer2.push("<!--[1-->");
      $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></div>`);
    } else if (href) {
      $$renderer2.push("<!--[2-->");
      $$renderer2.push(`<a${attributes({ ...$$restProps, click: true, href, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></a>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button${attributes({ type: "button", ...$$restProps, class: clsx(classes) })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, null);
      $$renderer2.push(`<!--]--></button>`);
    }
    $$renderer2.push(`<!--]--></li>`);
    bind_props($$props, {
      class: className,
      active,
      disabled,
      divider,
      header,
      toggle,
      href
    });
  });
}
export {
  DropdownItem as D
};
