import { am as getContext, a0 as slot, ad as attr_class, a1 as store_get, al as attr_style, a3 as unsubscribe_stores, a9 as bind_props, ae as stringify, ag as ensure_array_like, ac as attr, aa as escape_html, a6 as fallback, $ as setContext } from "./index2.js";
import { d as derived, w as writable } from "./index.js";
import dayjs from "dayjs";
import localeData from "dayjs/plugin/localeData.js";
import minMax from "dayjs/plugin/minMax.js";
import isSameOrBefore from "dayjs/plugin/isSameOrBefore.js";
import isSameOrAfter from "dayjs/plugin/isSameOrAfter.js";
import { c as createEventDispatcher } from "./index-server.js";
import "clsx";
function createFormatter(selectedStartDate, selectedEndDate, config) {
  const formatter = derived([selectedStartDate, selectedEndDate], ([$selectedStartDate, $selectedEndDate]) => {
    const formattedSelected = $selectedStartDate && $selectedStartDate.format(config.format);
    const formattedSelectedEnd = config.isRangePicker && $selectedEndDate && $selectedEndDate.format(config.format);
    return {
      formattedSelected,
      formattedSelectedEnd,
      formattedCombined: config.isRangePicker ? `${formattedSelected} - ${formattedSelectedEnd}` : formattedSelected
    };
  });
  return { formatter };
}
dayjs.extend(localeData);
dayjs.extend(minMax);
dayjs.extend(isSameOrBefore);
dayjs.extend(isSameOrAfter);
function ensureFutureMonth(firstDate, secondDate) {
  return firstDate.isSame(secondDate, "month") ? secondDate.add(1, "month") : secondDate;
}
function buildDaySelectionValidator(start, end, selectableCallback) {
  return (date) => {
    const isInRange = date.isSameOrAfter(start, "day") && date.isSameOrBefore(end, "day");
    return {
      isInRange,
      selectable: isInRange && (!selectableCallback || selectableCallback(date.toDate())),
      isToday: date.isSame(dayjs(), "day")
    };
  };
}
function getCalendarPage(date, dayValidator) {
  const displayedRangeStart = date.startOf("month").startOf("week");
  const displayedRangeEnd = date.endOf("month").endOf("week").add(1, "day");
  const weeks = [];
  let currentDay = displayedRangeStart;
  while (currentDay.isBefore(displayedRangeEnd, "day")) {
    const weekOfMonth = Math.floor(currentDay.diff(displayedRangeStart, "days") / 7);
    const isRequestedMonth = currentDay.isSame(date, "month");
    weeks[weekOfMonth] = weeks[weekOfMonth] || { days: [], id: `${currentDay.format("YYYYMMYYYY")}${weekOfMonth}` };
    weeks[weekOfMonth].days.push(
      Object.assign({
        partOfMonth: isRequestedMonth,
        firstOfMonth: isRequestedMonth && currentDay.date() === 1,
        lastOfMonth: isRequestedMonth && currentDay.date() === date.daysInMonth(),
        day: currentDay.date(),
        month: currentDay.month(),
        year: currentDay.year(),
        date: currentDay
      }, dayValidator(currentDay))
    );
    currentDay = currentDay.add(1, "day");
  }
  return { month: date.month(), year: date.year(), weeks };
}
function getMonths(config) {
  const { start, end, selectableCallback } = config;
  const firstMonth = start.startOf("month").startOf("day");
  const lastMonth = ensureFutureMonth(firstMonth, end.startOf("month").startOf("day"));
  const months = [];
  const validator = buildDaySelectionValidator(start, end, selectableCallback);
  let date = dayjs(firstMonth);
  while (date.isSameOrBefore(lastMonth)) {
    months.push(getCalendarPage(date, validator));
    date = date.add(1, "month");
  }
  return months;
}
function moveDateWithinAllowedRange(date, config, isStart) {
  const isOutsideRange = date.valueOf() < config.start.valueOf() || date.valueOf() > config.end.valueOf();
  if (isOutsideRange) {
    console.warn("Provided date", date.format(), "is outside specified start-and-end range", config.start.format(), "to", config.end.format());
    return isStart ? config.start : config.end;
  }
  return date;
}
function sanitizeInitialValue(value, config) {
  let isDateChosen = false;
  let chosen;
  if (config.isRangePicker) {
    const [from2, to2] = value || [];
    isDateChosen = Boolean(from2).valueOf() && Boolean(to2).valueOf();
    chosen = isDateChosen ? value.map(dayjs) : [dayjs.max(dayjs(), config.start), dayjs.min(dayjs().add(...config.defaultRange), config.end)];
  } else {
    isDateChosen = Boolean(value).valueOf();
    chosen = [isDateChosen ? dayjs(value) : dayjs.max(dayjs(), config.start)];
  }
  const [from, to] = chosen;
  return {
    isDateChosen,
    chosen: [
      moveDateWithinAllowedRange(from, config, true),
      ...config.isRangePicker ? [moveDateWithinAllowedRange(to, config, false)] : []
    ]
  };
}
const contextKey = {};
function setup(given, config) {
  const today = dayjs().startOf("day");
  const { isDateChosen, chosen: [preSelectedStart, preSelectedEnd] } = sanitizeInitialValue(given, config);
  const selectedStartDate = writable(preSelectedStart);
  const selectedEndDate = writable(preSelectedEnd);
  const { formatter } = createFormatter(selectedStartDate, selectedEndDate, config);
  const component = writable("date-view");
  const leftDate = preSelectedStart.subtract(
    config.isRangePicker && preSelectedStart.isSame(config.end, "month") ? 1 : 0,
    "month"
  ).startOf("month");
  const rightDate = config.isRangePicker ? ensureFutureMonth(leftDate, preSelectedEnd).startOf("month") : null;
  return {
    months: getMonths(config),
    component,
    today,
    selectedStartDate,
    selectedEndDate,
    leftCalendarDate: writable(leftDate),
    rightCalendarDate: writable(rightDate),
    config,
    shouldShakeDate: writable(false),
    isOpen: writable(false),
    isClosing: writable(false),
    highlighted: writable(today),
    formatter,
    isDateChosen: writable(isDateChosen),
    resetView: () => {
      component.set("date-view");
    },
    isSelectingFirstDate: writable(true)
  };
}
function Popover($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const { isOpen, isClosing, config, resetView } = getContext(contextKey);
    let isFullscreen = false;
    let translateY = 0;
    let translateX = 0;
    let trigger = $$props["trigger"];
    function close() {
      isClosing.set(true);
    }
    $$renderer2.push(`<div class="sc-popover svelte-1wxclo0"><div class="trigger svelte-1wxclo0"><!--[-->`);
    slot($$renderer2, $$props, "trigger", {}, () => {
    });
    $$renderer2.push(`<!--]--></div> <div${attr_class("contents-wrapper svelte-1wxclo0", void 0, {
      "visible": store_get($$store_subs ??= {}, "$isOpen", isOpen),
      "shrink": store_get($$store_subs ??= {}, "$isClosing", isClosing),
      "is-fullscreen": isFullscreen
    })}${attr_style(`top: ${stringify(translateY)}px; left: ${stringify(translateX)}px`)}><div class="wrapper svelte-1wxclo0"><div class="contents-inner svelte-1wxclo0"><!--[-->`);
    slot($$renderer2, $$props, "contents", {}, null);
    $$renderer2.push(`<!--]--></div></div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { trigger, close });
  });
}
class CalendarStyle {
  constructor(overrides = {}) {
    this.style = "";
    this.buttonBackgroundColor = "#fff";
    this.buttonBorderColor = "#eee";
    this.buttonTextColor = "#333";
    this.buttonWidth = "300px";
    this.highlightColor = "#f7901e";
    this.passiveHighlightColor = "#FCD9B1";
    this.dayBackgroundColor = "none";
    this.dayBackgroundColorIsNight = "none";
    this.dayTextColor = "#4a4a4a";
    this.dayTextColorIsNight = "#4a4a4a";
    this.dayTextColorInRange = "white";
    this.dayHighlightedBackgroundColor = "#efefef";
    this.dayHighlightedTextColor = "#4a4a4a";
    this.currentDayTextColor = "#000";
    this.selectedDayTextColor = "white";
    this.timeNightModeTextColor = "white";
    this.timeNightModeBackgroundColor = "#808080";
    this.timeDayModeTextColor = "white";
    this.timeDayModeBackgroundColor = "white";
    this.timeSelectedTextColor = "#3d4548";
    this.timeInputTextColor = "#3d4548";
    this.timeConfirmButtonColor = "#2196F3";
    this.timeConfirmButtonTextColor = "white";
    this.toolbarBorderColor = "#888";
    this.contentBackground = "white";
    this.monthYearTextColor = "#3d4548";
    this.legendTextColor = "#4a4a4a";
    this.datepickerWidth = "auto";
    Object.entries(overrides).forEach(([prop, value]) => {
      this[prop] = value;
    });
  }
  toWrapperStyle() {
    return `
      --button-background-color: ${this.buttonBackgroundColor};
      --button-border-color: ${this.buttonBorderColor};
      --button-text-color: ${this.buttonTextColor};
      --button-width: ${this.buttonWidth};
      --highlight-color: ${this.highlightColor};
      --passive-highlight-color: ${this.passiveHighlightColor};

      --day-background-color: ${this.dayBackgroundColor};
      --day-background-color-is-night: ${this.dayBackgroundColorIsNight};
      --day-text-color: ${this.dayTextColor};
      --day-text-color-in-range: ${this.dayTextColorInRange};
      --day-text-color-is-night: ${this.dayTextColorIsNight};
      --day-highlighted-background-color: ${this.dayHighlightedBackgroundColor};
      --day-highlighted-text-color: ${this.dayHighlightedTextColor};

      --current-day-text-color: ${this.currentDayTextColor};
      --selected-day-text-color: ${this.selectedDayTextColor};

      --time-night-mode-text-color: ${this.timeNightModeTextColor};
      --time-night-mode-background-color: ${this.timeNightModeBackgroundColor};
      --time-day-mode-text-color: ${this.timeDayModeTextColor};
      --time-day-mode-background-color: ${this.timeDayModeBackgroundColor};

      --time-selected-text-color: ${this.timeSelectedTextColor};
      --time-input-text-color: ${this.timeInputTextColor};
      --time-confirm-button-text-color: ${this.timeConfirmButtonTextColor};
      --time-confirm-button-color: ${this.timeConfirmButtonColor};

      --toolbar-border-color: ${this.toolbarBorderColor};

      --content-background: ${this.contentBackground};

      --month-year-text-color: ${this.monthYearTextColor};
      --legend-text-color: ${this.legendTextColor};
      --datepicker-width: ${this.datepickerWidth};

      ${this.style}
    `;
  }
}
function isDateBetweenSelected(a, b, c) {
  const start = a.startOf("day").toDate();
  const stop = b.startOf("day").toDate();
  const day = c.startOf("day").toDate();
  return day > start && day < stop;
}
function Week($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let viewContextKey = $$props["viewContextKey"];
    let days = $$props["days"];
    let direction = $$props["direction"];
    const {
      config,
      shouldShakeDate,
      highlighted,
      selectedStartDate,
      selectedEndDate
    } = getContext(contextKey);
    const { isDaytime } = getContext(viewContextKey);
    $$renderer2.push(`<div class="week svelte-15ow80w"><!--[-->`);
    const each_array = ensure_array_like(days);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let day = each_array[$$index];
      $$renderer2.push(`<div${attr_class("day svelte-15ow80w", void 0, {
        "is-night": !store_get($$store_subs ??= {}, "$isDaytime", isDaytime),
        "is-range-picker": config.isRangePicker,
        "outside-month": !day.partOfMonth,
        "first-of-month": day.firstOfMonth,
        "last-of-month": day.lastOfMonth,
        "selection-start": day.date.isSame(store_get($$store_subs ??= {}, "$selectedStartDate", selectedStartDate), "day"),
        "selection-end": config.isRangePicker && day.date.isSame(store_get($$store_subs ??= {}, "$selectedEndDate", selectedEndDate), "day"),
        "part-of-range": config.isRangePicker && isDateBetweenSelected(store_get($$store_subs ??= {}, "$selectedStartDate", selectedStartDate), store_get($$store_subs ??= {}, "$selectedEndDate", selectedEndDate), day.date),
        "is-today": day.isToday,
        "is-disabled": !day.selectable
      })}><button${attr_class("day--label svelte-15ow80w", void 0, {
        "highlighted": day.date.isSame(store_get($$store_subs ??= {}, "$highlighted", highlighted), "day"),
        "shake-date": store_get($$store_subs ??= {}, "$shouldShakeDate", shouldShakeDate) && day.date.isSame(store_get($$store_subs ??= {}, "$shouldShakeDate", shouldShakeDate), "day"),
        "disabled": !day.selectable
      })} type="button"${attr("aria-label", day.date.format("YYYY-MM-DD"))}>${escape_html(day.date.date())}</button></div>`);
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey, days, direction });
  });
}
function Month($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let viewContextKey = $$props["viewContextKey"];
    let id = $$props["id"];
    const { monthView } = getContext(viewContextKey);
    let lastId = id;
    let direction;
    {
      direction = lastId < id ? 1 : -1;
      lastId = id;
    }
    $$renderer2.push(`<div class="month-container svelte-8bvgs2"><div class="month-dates svelte-8bvgs2"><div class="legend svelte-8bvgs2"><div class="month-week svelte-8bvgs2"><!--[-->`);
    const each_array = ensure_array_like(dayjs.weekdaysShort());
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let day = each_array[$$index];
      $$renderer2.push(`<span class="svelte-8bvgs2">${escape_html(day)}</span>`);
    }
    $$renderer2.push(`<!--]--></div></div> <!--[-->`);
    const each_array_1 = ensure_array_like(store_get($$store_subs ??= {}, "$monthView", monthView).visibleMonth.weeks);
    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
      let week = each_array_1[$$index_1];
      Week($$renderer2, { viewContextKey, days: week.days, direction });
    }
    $$renderer2.push(`<!--]--></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey, id });
  });
}
function NavBar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let myPosition, startPosition, endPosition, canIncrementMonth, canDecrementMonth;
    let viewContextKey = $$props["viewContextKey"];
    const {
      months,
      config,
      highlighted,
      leftCalendarDate,
      rightCalendarDate
    } = getContext(contextKey);
    const { isStart, displayedDate, monthView } = getContext(viewContextKey);
    let monthSelectorOpen = false;
    let availableMonths;
    {
      const isOnLowerBoundary = config.start.isSame(store_get($$store_subs ??= {}, "$displayedDate", displayedDate), "year");
      const isOnUpperBoundary = config.end.isSame(store_get($$store_subs ??= {}, "$displayedDate", displayedDate), "year");
      availableMonths = dayjs.months().map((m, i) => {
        return Object.assign({}, { name: m, abbrev: dayjs.monthsShort()[i] }, {
          selectable: !isOnLowerBoundary && !isOnUpperBoundary || (!isOnLowerBoundary || i >= config.start.month()) && (!isOnUpperBoundary || i <= config.end.year())
        });
      });
    }
    myPosition = dayjs(store_get($$store_subs ??= {}, "$displayedDate", displayedDate)).diff("0000-00-00", "month");
    startPosition = dayjs(store_get($$store_subs ??= {}, "$leftCalendarDate", leftCalendarDate)).diff("0000-00-00", "month");
    endPosition = dayjs(store_get($$store_subs ??= {}, "$rightCalendarDate", rightCalendarDate)).diff("0000-00-00", "month");
    canIncrementMonth = store_get($$store_subs ??= {}, "$monthView", monthView).monthIndex < months.length - 1 && (config.isRangePicker && isStart ? myPosition < endPosition - 1 : true);
    canDecrementMonth = store_get($$store_subs ??= {}, "$monthView", monthView).monthIndex > 0 && (config.isRangePicker && !isStart ? myPosition > startPosition + 1 : true);
    $$renderer2.push(`<div class="title svelte-ungsay"><div class="heading-section svelte-ungsay"><button class="control svelte-ungsay" type="button" aria-label="Previous month"${attr("disabled", !canDecrementMonth, true)}><i class="arrow left svelte-ungsay"></i></button> <button type="button" class="label svelte-ungsay"><span>${escape_html(store_get($$store_subs ??= {}, "$displayedDate", displayedDate).format("MMMM YYYY"))}</span></button> <button class="control svelte-ungsay" type="button" aria-label="Next month"${attr("disabled", !canIncrementMonth, true)}><i class="arrow right svelte-ungsay"></i></button></div> <div${attr_class("month-selector svelte-ungsay", void 0, { "open": monthSelectorOpen })}><!--[-->`);
    const each_array = ensure_array_like(availableMonths);
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let monthDefinition = each_array[index];
      $$renderer2.push(`<button${attr_class("month-selector--month svelte-ungsay", void 0, {
        "selected": index === store_get($$store_subs ??= {}, "$displayedDate", displayedDate).month()
      })}${attr("disabled", !monthDefinition.selectable, true)}><span class="svelte-ungsay">${escape_html(monthDefinition.abbrev)}</span></button>`);
    }
    $$renderer2.push(`<!--]--></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey });
  });
}
function DateView($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let visibleMonthsId;
    let viewContextKey = $$props["viewContextKey"];
    const { displayedDate } = getContext(viewContextKey);
    const { months, shouldShakeDate } = getContext(contextKey);
    visibleMonthsId = store_get($$store_subs ??= {}, "$displayedDate", displayedDate).unix();
    $$renderer2.push(`<div class="svelte-1otmzxf">`);
    NavBar($$renderer2, { viewContextKey });
    $$renderer2.push(`<!----> `);
    Month($$renderer2, { viewContextKey, id: visibleMonthsId });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey });
  });
}
function createMonthView(months, displayedDate) {
  return derived([displayedDate], ([$displayedDate]) => {
    let monthIndex = 0;
    const month = $displayedDate.month();
    const year = $displayedDate.year();
    for (let i = 0; i < months.length; i += 1) {
      if (months[i].month === month && months[i].year === year) {
        monthIndex = i;
      }
    }
    return {
      monthIndex,
      visibleMonth: months[monthIndex]
    };
  });
}
function createViewContext(isStart, mainContext) {
  const { config, months, leftCalendarDate, rightCalendarDate, selectedStartDate, selectedEndDate } = mainContext;
  const [date, displayedDate] = isStart ? [selectedStartDate, leftCalendarDate] : [selectedEndDate, rightCalendarDate];
  const isDaytime = derived(date, ($date) => {
    if (!$date) {
      return true;
    }
    const [h] = dayjs($date).format("HH:mm").split(":").map((d) => parseInt(d));
    return h > config.morning && h < config.night;
  });
  return {
    isStart,
    date,
    view: DateView,
    isDaytime,
    displayedDate,
    monthView: createMonthView(months, displayedDate)
  };
}
function Toolbar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let continueText = $$props["continueText"];
    const { config, component, isDateChosen } = getContext(contextKey);
    $$renderer2.push(`<div class="toolbar svelte-2dtfnm"><button type="button" class="button svelte-2dtfnm">${escape_html(continueText)}</button></div>`);
    bind_props($$props, { continueText });
  });
}
function Chevron($$renderer, $$props) {
  let up = fallback($$props["up"], true);
  $$renderer.push(`<span${attr_class("chevron svelte-19fig00", void 0, { "bottom": !up })}></span>`);
  bind_props($$props, { up });
}
function format(h, m) {
  return [
    String(h).padStart(2, "0"),
    String(m).padStart(2, "0")
  ].join(":");
}
function createStore(date, config) {
  const time = writable(dayjs(date).format("HH:mm"));
  function increment(segment) {
    time.update((t) => {
      let [h, m] = t.split(":");
      if (segment === "hour" && h < 23) {
        ++h;
      }
      if (segment === "minute" && m < 59) {
        m = Math.min(59, parseInt(m) + config.minuteStep);
      }
      return format(h, m);
    });
  }
  function decrement(segment) {
    time.update((t) => {
      let [h, m] = t.split(":");
      if (segment === "hour" && h > 0) {
        --h;
      }
      if (segment === "minute" && m > 0) {
        m = Math.max(0, parseInt(m) - config.minuteStep);
      }
      return format(h, m);
    });
  }
  function set(t) {
    time.set(t);
  }
  return {
    increment,
    decrement,
    time,
    set
  };
}
function TimeInput($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let viewContextKey = $$props["viewContextKey"];
    const { config } = getContext(contextKey);
    const { date, isDaytime } = getContext(viewContextKey);
    createStore(store_get($$store_subs ??= {}, "$date", date), config);
    $$renderer2.push(`<div${attr_class("time-picker svelte-qfnaao", void 0, {
      "is-night": !store_get($$store_subs ??= {}, "$isDaytime", isDaytime)
    })}><div class="controls svelte-qfnaao">`);
    Chevron($$renderer2, { up: true });
    $$renderer2.push(`<!----> `);
    Chevron($$renderer2, { up: true });
    $$renderer2.push(`<!----></div> <input type="text" class="svelte-qfnaao"/> <div class="controls svelte-qfnaao">`);
    Chevron($$renderer2, { up: false });
    $$renderer2.push(`<!----> `);
    Chevron($$renderer2, { up: false });
    $$renderer2.push(`<!----></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey });
  });
}
function TimeView($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let viewContextKey = $$props["viewContextKey"];
    const { date, isDaytime } = getContext(viewContextKey);
    const { config } = getContext(contextKey);
    $$renderer2.push(`<div${attr_class("time-container svelte-dh89zf", void 0, {
      "is-night": !store_get($$store_subs ??= {}, "$isDaytime", isDaytime)
    })}><span class="chosen-date svelte-dh89zf">${escape_html(dayjs(store_get($$store_subs ??= {}, "$date", date)).format(config.format))}</span> `);
    TimeInput($$renderer2, { viewContextKey });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey });
  });
}
function View($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let viewContextKey = $$props["viewContextKey"];
    const { config, component } = getContext(contextKey);
    const { isDaytime } = getContext(viewContextKey);
    $$renderer2.push(`<div${attr_class("calendar svelte-1pg1ocu", void 0, {
      "is-range-picker": config.isRangePicker,
      "day": store_get($$store_subs ??= {}, "$isDaytime", isDaytime),
      "night": !store_get($$store_subs ??= {}, "$isDaytime", isDaytime)
    })}>`);
    $$renderer2.push("<!---->");
    (store_get($$store_subs ??= {}, "$component", component) === "date-view" ? DateView : TimeView)?.($$renderer2, { viewContextKey });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { viewContextKey });
  });
}
function DatePicker($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let range = fallback($$props["range"], false);
    let defaultRange = fallback($$props["defaultRange"], () => [1, "month"], true);
    let placeholder = fallback($$props["placeholder"], "Choose Date");
    let format2 = fallback($$props["format"], "DD / MM / YYYY");
    let start = fallback($$props["start"], () => dayjs().subtract(1, "year"), true);
    let end = fallback($$props["end"], () => dayjs().add(1, "year"), true);
    let trigger = fallback($$props["trigger"], null);
    let selectableCallback = fallback($$props["selectableCallback"], null);
    let styling = fallback($$props["styling"], () => new CalendarStyle(), true);
    let selected = $$props["selected"];
    let closeOnFocusLoss = fallback($$props["closeOnFocusLoss"], true);
    let time = fallback($$props["time"], false);
    let morning = fallback($$props["morning"], 7);
    let night = fallback($$props["night"], 19);
    let minuteStep = fallback($$props["minuteStep"], 5);
    let continueText = fallback($$props["continueText"], "Continue");
    const dispatch = createEventDispatcher();
    const startContextKey = {};
    const endContextKey = {};
    const config = {
      start: dayjs(start),
      end: dayjs(end),
      isRangePicker: range,
      defaultRange,
      isTimePicker: time,
      closeOnFocusLoss,
      format: format2,
      morning,
      night,
      selectableCallback,
      minuteStep: parseInt(minuteStep)
    };
    setContext(contextKey, setup(selected, config));
    const {
      selectedStartDate,
      selectedEndDate,
      isOpen,
      isClosing,
      highlighted,
      formatter,
      isDateChosen,
      isSelectingFirstDate
    } = getContext(contextKey);
    setContext(startContextKey, createViewContext(true, getContext(contextKey)));
    if (config.isRangePicker) {
      setContext(endContextKey, createViewContext(false, getContext(contextKey)));
    }
    function setRangeValue() {
      selected = [
        store_get($$store_subs ??= {}, "$selectedStartDate", selectedStartDate),
        store_get($$store_subs ??= {}, "$selectedEndDate", selectedEndDate)
      ];
      dispatch("range-selected", {
        from: store_get($$store_subs ??= {}, "$selectedStartDate", selectedStartDate).toDate(),
        to: store_get($$store_subs ??= {}, "$selectedEndDate", selectedEndDate).toDate()
      });
    }
    function setDateValue() {
      selected = store_get($$store_subs ??= {}, "$selectedStartDate", selectedStartDate).toDate();
      dispatch("date-selected", {
        date: store_get($$store_subs ??= {}, "$selectedStartDate", selectedStartDate).toDate()
      });
    }
    {
      if (store_get($$store_subs ??= {}, "$isDateChosen", isDateChosen)) {
        config.isRangePicker ? setRangeValue() : setDateValue();
      }
    }
    $$renderer2.push(`<div${attr_class("datepicker svelte-11ijsa9", void 0, {
      "open": store_get($$store_subs ??= {}, "$isOpen", isOpen),
      "closing": store_get($$store_subs ??= {}, "$isClosing", isClosing)
    })}${attr_style(styling.toWrapperStyle())}>`);
    Popover($$renderer2, {
      trigger,
      $$slots: {
        trigger: ($$renderer3) => {
          $$renderer3.push(`<div slot="trigger" class="svelte-11ijsa9"><!--[-->`);
          slot(
            $$renderer3,
            $$props,
            "default",
            {
              formatted: store_get($$store_subs ??= {}, "$formatter", formatter)
            },
            () => {
              if (!trigger) {
                $$renderer3.push("<!--[-->");
                $$renderer3.push(`<button class="calendar-button svelte-11ijsa9" type="button">`);
                if (store_get($$store_subs ??= {}, "$isDateChosen", isDateChosen)) {
                  $$renderer3.push("<!--[-->");
                  $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$formatter", formatter).formattedCombined)}`);
                } else {
                  $$renderer3.push("<!--[!-->");
                  $$renderer3.push(`${escape_html(placeholder)}`);
                }
                $$renderer3.push(`<!--]--></button>`);
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]-->`);
            }
          );
          $$renderer3.push(`<!--]--></div>`);
        },
        contents: ($$renderer3) => {
          $$renderer3.push(`<div${attr_class("contents svelte-11ijsa9", void 0, { "is-range-picker": config.isRangePicker })} slot="contents"><div class="view svelte-11ijsa9">`);
          View($$renderer3, { viewContextKey: startContextKey });
          $$renderer3.push(`<!----> `);
          if (config.isRangePicker) {
            $$renderer3.push("<!--[-->");
            View($$renderer3, { viewContextKey: endContextKey });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div> `);
          Toolbar($$renderer3, { continueText });
          $$renderer3.push(`<!----></div>`);
        }
      }
    });
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, {
      range,
      defaultRange,
      placeholder,
      format: format2,
      start,
      end,
      trigger,
      selectableCallback,
      styling,
      selected,
      closeOnFocusLoss,
      time,
      morning,
      night,
      minuteStep,
      continueText
    });
  });
}
export {
  DatePicker as D
};
