import { a6 as fallback, ad as attr_class, a8 as clsx, ac as attr, al as attr_style, a9 as bind_props } from "./index2.js";
function Chartjs($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let type = fallback($$props["type"], "bar");
    let className = fallback($$props["className"], "line");
    let id = fallback($$props["id"], "bar");
    let style = fallback($$props["style"], 'margin-bottom: "20px"');
    let labels = fallback(
      $$props["labels"],
      () => [
        "Jan",
        "Feb",
        "Mar",
        "Apr",
        "May",
        "Jun",
        "Jul",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec"
      ],
      true
    );
    let height = fallback($$props["height"], 479);
    let scales = fallback(
      $$props["scales"],
      () => ({
        y: {
          beginAtZero: true,
          border: { display: false },
          grid: {
            color: "#485e9029",
            borderDash: [3, 3],
            zeroLineColor: "#485e9029",
            zeroLineWidth: 1,
            drawTicks: false,
            drawBorder: false,
            borderWidth: 0,
            lineWidth: 0.5
          },
          ticks: {
            beginAtZero: true,
            font: { size: 14, family: "'Jost', sans-serif" },
            color: "#747474",
            max: 80,
            stepStartValue: 5,
            stepSize: 20,
            padding: 10,
            callback(label) {
              return `${label}k`;
            }
          }
        },
        x: {
          border: { display: false },
          grid: {
            display: true,
            zeroLineWidth: 0,
            drawTicks: true,
            drawBorder: false,
            color: "#485e9029",
            z: 1,
            lineWidth: 0.5
          },
          ticks: {
            beginAtZero: true,
            font: { size: 14, family: "'Jost', sans-serif" },
            color: "#747474"
          }
        }
      }),
      true
    );
    let datasets = fallback(
      $$props["datasets"],
      () => [
        {
          data: [20, 60, 50, 45, 50, 60, 70, 40, 45, 35, 25, 30],
          backgroundColor: "#001737",
          barPercentage: 0.6,
          label: "Profit"
        },
        {
          data: [10, 40, 30, 40, 60, 55, 45, 35, 30, 20, 15, 20],
          backgroundColor: "#1ce1ac",
          barPercentage: 0.6,
          label: "Lose"
        }
      ],
      true
    );
    let layout = fallback($$props["layout"], () => ({}), true);
    let legend = fallback(
      $$props["legend"],
      () => ({
        display: false,
        labels: { display: false, position: "center" }
      }),
      true
    );
    let elements = fallback(
      $$props["elements"],
      () => ({
        line: {
          tension: 0.4,
          borderCapStyle: "round",
          borderJoinStyle: "round",
          capBezierPoints: true
        },
        point: { radius: 0, z: 5 }
      }),
      true
    );
    let options = fallback($$props["options"], () => ({}), true);
    let tooltip = fallback(
      $$props["tooltip"],
      () => ({
        callbacks: {
          label(t) {
            const dstLabel = t.dataset.label;
            const { formattedValue } = t;
            return `  ${formattedValue} ${dstLabel}`;
          },
          labelColor(t) {
            return {
              backgroundColor: t.dataset.hoverBackgroundColor,
              borderColor: "transparent"
            };
          }
        }
      }),
      true
    );
    $$renderer2.push(`<canvas${attr_class(clsx(className))}${attr("id", id)}${attr_style(style)}${attr("height", height)}></canvas>`);
    bind_props($$props, {
      type,
      className,
      id,
      style,
      labels,
      height,
      scales,
      datasets,
      layout,
      legend,
      elements,
      options,
      tooltip
    });
  });
}
export {
  Chartjs as C
};
