import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Card($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "body", "color", "inverse", "outline", "theme"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let body = fallback($$props["body"], false);
    let color = fallback($$props["color"], "");
    let inverse = fallback($$props["inverse"], false);
    let outline = fallback($$props["outline"], false);
    let theme = fallback($$props["theme"], void 0);
    classes = classnames(className, "card", inverse ? "text-white" : false, body ? "card-body" : false, color ? `${outline ? "border" : "bg"}-${color}` : false);
    $$renderer2.push(`<div${attributes({
      ...$$restProps,
      "data-bs-theme": theme,
      class: clsx(classes)
    })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, body, color, inverse, outline, theme });
  });
}
export {
  Card as C
};
