import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function ButtonGroup($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, ["class", "size", "vertical"]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let className = fallback($$props["class"], "");
    let size = fallback($$props["size"], "");
    let vertical = fallback($$props["vertical"], false);
    classes = classnames(className, size ? `btn-group-${size}` : false, vertical ? "btn-group-vertical" : "btn-group");
    $$renderer2.push(`<div${attributes({ ...$$restProps, class: clsx(classes) })}><!--[-->`);
    slot($$renderer2, $$props, "default", {}, null);
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, { class: className, size, vertical });
  });
}
export {
  ButtonGroup as B
};
