import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, aa as escape_html, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Button($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "active",
    "block",
    "content",
    "close",
    "color",
    "disabled",
    "href",
    "inner",
    "outline",
    "size",
    "value"
  ]);
  $$renderer.component(($$renderer2) => {
    let ariaLabel, classes, defaultAriaLabel;
    let className = fallback($$props["class"], "");
    let active = fallback($$props["active"], false);
    let block = fallback($$props["block"], false);
    let content = fallback($$props["content"], "");
    let close = fallback($$props["close"], false);
    let color = fallback($$props["color"], "secondary");
    let disabled = fallback($$props["disabled"], false);
    let href = fallback($$props["href"], "");
    let inner = fallback($$props["inner"], void 0);
    let outline = fallback($$props["outline"], false);
    let size = fallback($$props["size"], "");
    let value = fallback($$props["value"], "");
    ariaLabel = $$sanitized_props["aria-label"];
    classes = classnames(className, close ? "btn-close" : "btn", close || `btn${outline ? "-outline" : ""}-${color}`, size ? `btn-${size}` : false, block ? "d-block w-100" : false, { active });
    defaultAriaLabel = close ? "Close" : null;
    if (href) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a${attributes(
        {
          ...$$restProps,
          class: clsx(classes),
          href,
          "aria-label": ariaLabel || defaultAriaLabel
        },
        void 0,
        { disabled }
      )}>`);
      if (content) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(content)}`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></a>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<button${attributes({
        ...$$restProps,
        class: clsx(classes),
        disabled,
        value,
        "aria-label": ariaLabel || defaultAriaLabel
      })}><!--[-->`);
      slot($$renderer2, $$props, "default", {}, () => {
        if (content) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`${escape_html(content)}`);
        } else {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`<!--[-->`);
          slot($$renderer2, $$props, "default", {}, null);
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]-->`);
      });
      $$renderer2.push(`<!--]--></button>`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      class: className,
      active,
      block,
      content,
      close,
      color,
      disabled,
      href,
      inner,
      outline,
      size,
      value
    });
  });
}
export {
  Button as B
};
