import { a6 as fallback, aa as escape_html, ag as ensure_array_like, ac as attr, a9 as bind_props, ae as stringify } from "./index2.js";
import { B as Button } from "./Button.js";
import { F as Form } from "./Form.js";
import { F as FormGroup } from "./FormGroup.js";
import { I as Input } from "./Input.js";
import { L as Label } from "./Label.js";
import { M as Modal, a as ModalBody } from "./Modal.js";
import { M as ModalHeader } from "./ModalHeader.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { D as DatePicker } from "./DatePicker.js";
function BreadcrumbTwo($$renderer, $$props) {
  let pageTitle = fallback($$props["pageTitle"], "Dashboard");
  let pageLabel = fallback($$props["pageLabel"], "Home");
  let open = false;
  const toggle = () => open = !open;
  const team = ["tm1.png", "tm2.png", "tm3.png", "tm4.png", "tm5.png"];
  $$renderer.push(`<div class="breadcrumb-main user-member justify-content-sm-between"><div class="d-flex flex-wrap justify-content-center breadcrumb-main__wrapper"><div class="d-flex align-items-center user-member__title justify-content-center me-sm-25"><h4 class="text-capitalize fw-500 breadcrumb-title">${escape_html(pageTitle)}</h4> <span class="sub-title ms-sm-25 ps-sm-25">${escape_html(pageLabel)}</span></div> `);
  Form($$renderer, {
    class: "d-flex align-items-center user-member__form my-sm-0 my-2",
    children: ($$renderer2) => {
      $$renderer2.push(`<img class="svg" alt="" src="/img/svg/search.svg"/> `);
      Input($$renderer2, {
        class: "form-control me-sm-2 border-0 box-shadow-none",
        type: "search",
        placeholder: "Search by Name",
        "aria-label": "Search"
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div> <div class="action-btn">`);
  Button($$renderer, {
    color: "primary",
    class: "px-15",
    children: ($$renderer2) => {
      $$renderer2.push(`<i class="uil uil-plus fs-16"></i> Add Member`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----> `);
  Modal($$renderer, {
    isOpen: open,
    toggle,
    class: "new-member modal-dialog-centered",
    children: ($$renderer2) => {
      ModalHeader($$renderer2, {
        toggle,
        children: ($$renderer3) => {
          $$renderer3.push(`<h6 class="modal-title fw-500">Create project</h6>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      ModalBody($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="new-member-modal"><form>`);
          FormGroup($$renderer3, {
            class: "mb-20",
            children: ($$renderer4) => {
              Input($$renderer4, {
                type: "text",
                class: "form-control",
                placeholder: "Duran Clayton"
              });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          FormGroup($$renderer3, {
            class: "mb-20",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="category-member">`);
              Input($$renderer4, {
                type: "select",
                class: "js-example-basic-single js-states form-control",
                children: ($$renderer5) => {
                  $$renderer5.option({ value: "JAN" }, ($$renderer6) => {
                    $$renderer6.push(`1`);
                  });
                  $$renderer5.push(` `);
                  $$renderer5.option({ value: "FBR" }, ($$renderer6) => {
                    $$renderer6.push(`2`);
                  });
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          FormGroup($$renderer3, {
            class: "mb-20",
            children: ($$renderer4) => {
              Input($$renderer4, {
                type: "textarea",
                class: "form-control",
                rows: "3",
                placeholder: "Project description"
              });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          FormGroup($$renderer3, {
            class: "textarea-group",
            children: ($$renderer4) => {
              Label($$renderer4, {
                class: "mb-15",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->status`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="d-flex"><div class="project-task-list__left d-flex align-items-center"><div class="checkbox-group d-flex me-50 pe-10"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex">`);
              Input($$renderer4, {
                class: "checkbox",
                type: "checkbox",
                id: "check-grp-1",
                checked: true,
                label: "Status"
              });
              $$renderer4.push(`<!----></div></div> <div class="checkbox-group d-flex me-50 pe-10"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex">`);
              Input($$renderer4, {
                class: "checkbox",
                type: "checkbox",
                id: "check-grp-2",
                label: "Deactivated"
              });
              $$renderer4.push(`<!----></div></div> <div class="checkbox-group d-flex"><div class="checkbox-theme-default custom-checkbox checkbox-group__single d-flex">`);
              Input($$renderer4, {
                class: "checkbox",
                type: "checkbox",
                id: "check-grp-3",
                label: "Bloked"
              });
              $$renderer4.push(`<!----></div></div></div></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <div class="mb-25">`);
          FormGroup($$renderer3, {
            class: "mb-10",
            children: ($$renderer4) => {
              Label($$renderer4, {
                for: "name47",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->project member`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Input($$renderer4, {
                type: "text",
                class: "form-control",
                id: "name47",
                placeholder: "Search members"
              });
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <ul class="d-flex flex-wrap mb-20 user-group-people__parent"><!--[-->`);
          const each_array = ensure_array_like(team);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let img = each_array[$$index];
            $$renderer3.push(`<li><a href="#"><img class="rounded-circle wh-34"${attr("src", `/img/${stringify(img)}`)} alt="author"/></a></li>`);
          }
          $$renderer3.push(`<!--]--></ul></div> <div class="d-flex new-member-calendar custom-date-ranger custom-date-ranger__sm">`);
          FormGroup($$renderer3, {
            class: "w-100 me-sm-15 form-group-calender",
            children: ($$renderer4) => {
              Label($$renderer4, {
                for: "datepicker",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->start Date`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="position-relative">`);
              DatePicker($$renderer4, { format: "MMMM DD, YYYY" });
              $$renderer4.push(`<!----> <a href="#"><img class="svg" alt="" src="/img/svg/chevron-right.svg"/></a></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          FormGroup($$renderer3, {
            class: "w-100 form-group-calender",
            children: ($$renderer4) => {
              Label($$renderer4, {
                for: "datepicker2",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->End Date`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> <div class="position-relative">`);
              DatePicker($$renderer4, { format: "MMMM DD, YYYY" });
              $$renderer4.push(`<!----> <a href="#"><img class="svg" alt="" src="/img/svg/chevron-right.svg"/></a></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div> <div class="button-group d-flex pt-25">`);
          Button($$renderer3, {
            color: "primary",
            size: "default",
            class: "btn-squared text-capitalize",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->add new project`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          Button($$renderer3, {
            color: "light",
            size: "default",
            class: "btn-squared fw-400 text-capitalize b-light color-light",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->cancel`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----></div></form></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    },
    $$slots: { default: true }
  });
  $$renderer.push(`<!----></div></div>`);
  bind_props($$props, { pageTitle, pageLabel });
}
export {
  BreadcrumbTwo as B
};
