import { aa as escape_html, ac as attr, ae as stringify, a9 as bind_props, ag as ensure_array_like, ad as attr_class } from "./index2.js";
import { C as Card } from "./Card.js";
import { C as CardBody } from "./CardBody.js";
import "./Theme.svelte_svelte_type_style_lang.js";
import { C as CardExtra } from "./CardExtra.js";
import "clsx";
import { C as CardHeader } from "./CardHeader.js";
import daygridPlugin from "@fullcalendar/daygrid";
import interactionPlugin from "@fullcalendar/interaction";
import timegridPlugin from "@fullcalendar/timegrid";
import { F as FullCalendar } from "./FullCalendar.js";
import { P as Progress } from "./Progress.js";
function PageHeaderBanner($$renderer, $$props) {
  let cardClass = $$props["cardClass"];
  let imgPath = $$props["imgPath"];
  let title = $$props["title"];
  Card($$renderer, {
    class: `banner-page-header d-flex border-0 ${stringify(cardClass)}`,
    children: ($$renderer2) => {
      CardBody($$renderer2, {
        class: "p-0",
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="banner-feature__content"><h1 class="banner-feature__heading">${escape_html(title)}</h1> <p class="banner-feature__para">There are many variations of passages of Lorem Ipsum available, <br/> ut the majority have suffered
				passages of Lorem Ipsum available alteration in some form</p> <div class="d-flex justify-content-sm-start justify-content-center"><button class="banner-feature__btn btn btn-primary color-white btn-md px-20 radius-xs fs-15" type="button">Learn More</button></div></div> <div class="banner-feature__shape"><img${attr("src", imgPath)} alt="img"/></div>`);
        },
        $$slots: { default: true }
      });
    },
    $$slots: { default: true }
  });
  bind_props($$props, { cardClass, imgPath, title });
}
function Calendar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let withoutHeader = $$props["withoutHeader"];
    const dayNames = ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"];
    let options = {
      plugins: [daygridPlugin, timegridPlugin, interactionPlugin],
      initialView: "dayGridMonth",
      selectable: true,
      dayNamesShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      headerToolbar: { left: "prev", center: "title", right: "next" },
      height: "100%",
      weekends: true,
      showNonCurrentDates: false,
      contentHeight: "auto",
      dateClick: (info) => {
        let daySiblings = info.dayEl.closest("tbody").querySelectorAll(".fc-daygrid-day");
        daySiblings.forEach((el) => {
          el.classList.remove("fc-day_selected");
        });
        info.dayEl.classList.add("fc-day_selected");
      },
      dayHeaderContent(arg) {
        return dayNames[arg.date.getDay()];
      }
    };
    Card($$renderer2, {
      class: `border-0 date-picker__calendar-height h-100 ${withoutHeader} ${withoutHeader !== "withoutHeader" ? "" : ""}`,
      children: ($$renderer3) => {
        if (withoutHeader === "withoutHeader") {
          $$renderer3.push("<!--[-->");
          CardBody($$renderer3, {
            class: "px-10 pt-xxl-35 pb-xxl-40",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="date-picker date-picker--demo5">`);
              FullCalendar($$renderer4, { options, class: "date-picker__calendar" });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          CardHeader($$renderer3, {
            children: ($$renderer4) => {
              $$renderer4.push(`<h6>Calendar 2023</h6> `);
              CardExtra($$renderer4);
              $$renderer4.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          CardBody($$renderer3, {
            class: "px-10 pt-xxl-35 pb-xxl-40",
            children: ($$renderer4) => {
              $$renderer4.push(`<div class="date-picker date-picker--demo5">`);
              FullCalendar($$renderer4, { options, class: "date-picker__calendar" });
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!---->`);
        }
        $$renderer3.push(`<!--]-->`);
      },
      $$slots: { default: true }
    });
    bind_props($$props, { withoutHeader });
  });
}
function KnowledgeBase($$renderer) {
  Card($$renderer, {
    class: "knowledge-base border-0 h-100",
    children: ($$renderer2) => {
      $$renderer2.push(`<img src="/img/book-open.png" alt="book"/> <h1>Knowledge Base</h1> <p>There are many variations of passages of Lorem Ipsum available but the majority have suffered
		alteration</p> <button type="button" class="btn btn-primary">Browse Article</button>`);
    },
    $$slots: { default: true }
  });
}
function MembersProgress($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  $$renderer.push(`<div class="selling-table-wrap selling-table-wrap--source selling-table-wrap--member table-responsive svelte-17r9kjm"><table class="table table--default table-borderless svelte-17r9kjm"><tbody class="svelte-17r9kjm"><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="svelte-17r9kjm"><td class="svelte-17r9kjm"><div class="selling-product-img d-flex align-items-center svelte-17r9kjm"><div${attr_class(`selling-product-img-wrapper order-bg-opacity-${stringify(data.progress)}`, "svelte-17r9kjm")}><img class="img-fluid svelte-17r9kjm"${attr("src", `/img/author/${stringify(data.userImg)}`)} alt="img"/></div> <span class="svelte-17r9kjm">${escape_html(data.title)}</span></div></td><td class="svelte-17r9kjm">$${escape_html(data.salary)}</td><td class="svelte-17r9kjm"><div class="status svelte-17r9kjm"><ul class="svelte-17r9kjm"><li class="svelte-17r9kjm">${escape_html(data.workOn)}</li></ul></div></td><td class="svelte-17r9kjm"><div class="d-flex align-center justify-content-end"><div class="progress-wrap mb-0 me-15"><div class="progress svelte-17r9kjm">`);
    Progress($$renderer, { bar: true, color: data.progress, value: data.status });
    $$renderer.push(`<!----></div></div> <div class="ratio-percentage svelte-17r9kjm">${escape_html(data.status)}%</div></div></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
function Events($$renderer, $$props) {
  let dataPeriod = $$props["dataPeriod"];
  $$renderer.push(`<div class="project-task table-responsive"><table class="table table-borderless"><tbody><!--[-->`);
  const each_array = ensure_array_like(dataPeriod);
  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
    let data = each_array[$$index];
    $$renderer.push(`<tr class="project-task-list svelte-fxhng3"><td><div class="event-Wrapper svelte-fxhng3"><div class="event-Wrapper__left"><div${attr_class(`event-wrapper-item bg-${stringify(data.type)}`, "svelte-fxhng3")}><span class="svelte-fxhng3">${escape_html(data.date)}</span> <span class="svelte-fxhng3">${escape_html(data.month)}</span></div></div> <div class="event-Wrapper__right svelte-fxhng3"><h6 class="svelte-fxhng3">${escape_html(data.title)}</h6> <span class="svelte-fxhng3">${escape_html(data.time)}</span></div></div></td><td><div class="project-task-list__right svelte-fxhng3"><ul class="d-flex align-content-center justify-content-end svelte-fxhng3"><li class="svelte-fxhng3"><a href="#" aria-label="Edit" class="edit svelte-fxhng3" title="Edit"><i class="uil uil-edit svelte-fxhng3"></i></a></li> <li class="svelte-fxhng3"><a href="#" aria-label="Delete" class="cross svelte-fxhng3" title="Delete"><i class="uil uil-times svelte-fxhng3"></i></a></li></ul></div></td></tr>`);
  }
  $$renderer.push(`<!--]--></tbody></table></div>`);
  bind_props($$props, { dataPeriod });
}
const today = [{ "id": 1, "type": "primary", "title": "Planning for new dashboard wireframe and prototype design", "date": "19", "month": "Mar", "time": "08:30 AM" }, { "id": 2, "type": "secondary", "title": "International Web Conference 2021", "date": "19", "month": "May", "time": "09:30 AM" }, { "id": 3, "type": "info", "title": "Dribble Designer Meetup", "date": "19", "month": "Jan", "time": "10:30 AM" }, { "id": 4, "type": "warning", "title": "Dribble Designer Meetup", "date": "19", "month": "Jul", "time": "11:30 AM" }];
const week = [{ "id": 1, "type": "primary", "title": "Wordcamp 2050 in Dhaka", "date": "10", "month": "Aug", "time": "10:00 AM" }, { "id": 2, "type": "info", "title": "Days grief himnot brow tales.", "date": "12", "month": "Dec", "time": "09:30 AM" }, { "id": 3, "type": "secondary", "title": "Dribble Designer MeetupWas herz ich.", "date": "05", "month": "Feb", "time": "03:30 PM" }, { "id": 4, "type": "warning", "title": "Taste might chill had been.", "date": "15", "month": "Jan", "time": "01:00 PM" }];
const month = [{ "id": 1, "type": "primary", "title": "Mien bird violet nevermore the", "date": "26", "month": "Apr", "time": "10:30 AM" }, { "id": 2, "type": "secondary", "title": "International Web Conference 2021", "date": "17", "month": "May", "time": "09:30 AM" }, { "id": 3, "type": "info", "title": "Him superstition seek with joyless", "date": "24", "month": "Oct", "time": "10:30 AM" }, { "id": 4, "type": "warning", "title": "Son faudra et de que.", "date": "28", "month": "Nov", "time": "08:00 PM" }];
const eventData = {
  today,
  week,
  month
};
function BlogCard($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let content = $$props["content"];
    $$renderer2.push(`<div class="blog-card"><div class="blog-card__thumbnail"><a href="#"><img${attr("src", content.thumbnail)} alt=""/></a></div> <div class="blog-card__details"><div class="blog-card__content"><div class="blog-card__title--top">${escape_html(content.postedOn)}</div> <h4 class="blog-card__title"><a href="/pages/blog/details" class="entry-title" rel="bookmark">${escape_html(content.title)}</a></h4> <p>${escape_html(content.excerpt)}</p></div> <div class="blog-card__meta"><div class="blog-card__meta-profile"><img${attr("src", content.authorImg)} alt=""/> <span>${escape_html(content.authorName)}</span></div> <div class="blog-card__meta-count"><ul><li><div class="blog-card__meta-reaction"><img class="svg" alt="" src="/img/svg/heart.svg"/> <span class="blog-card__meta-reaction-like">${escape_html(content.likes)}</span></div></li> <li><div class="blog-card__meta-doc-wrapper"><img class="svg" alt="" src="/img/svg/file-text.svg"/> <span class="blog-card__meta-doc">${escape_html(content.comments)}</span></div></li></ul></div></div></div></div>`);
    bind_props($$props, { content });
  });
}
export {
  BlogCard as B,
  Calendar as C,
  Events as E,
  KnowledgeBase as K,
  MembersProgress as M,
  PageHeaderBanner as P,
  eventData as e
};
