import { a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, aa as escape_html, a0 as slot, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Badge($$renderer, $$props) {
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "ariaLabel",
    "border",
    "class",
    "content",
    "color",
    "href",
    "indicator",
    "pill",
    "positioned",
    "placement",
    "shadow",
    "theme"
  ]);
  $$renderer.component(($$renderer2) => {
    let classes;
    let ariaLabel = fallback($$props["ariaLabel"], "");
    let border = fallback($$props["border"], false);
    let className = fallback($$props["class"], "");
    let content = fallback($$props["content"], "");
    let color = fallback($$props["color"], "secondary");
    let href = fallback($$props["href"], "");
    let indicator = fallback($$props["indicator"], false);
    let pill = fallback($$props["pill"], false);
    let positioned = fallback($$props["positioned"], false);
    let placement = fallback($$props["placement"], "top-0 start-100");
    let shadow = fallback($$props["shadow"], false);
    let theme = fallback($$props["theme"], void 0);
    classes = classnames(
      "badge",
      `text-bg-${color}`,
      pill ? "rounded-pill" : false,
      positioned ? "position-absolute translate-middle" : false,
      positioned ? placement : false,
      indicator ? "p-2" : false,
      border ? typeof border === "string" ? border : "border" : false,
      shadow ? typeof shadow === "string" ? shadow : "shadow" : false,
      className
    );
    if (href) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a${attributes({
        ...$$restProps,
        href,
        class: clsx(classes),
        "data-bs-theme": theme
      })}>`);
      if (content) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(content)}`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--> `);
      if (positioned || indicator) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span class="visually-hidden">${escape_html(ariaLabel)}</span>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></a>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<span${attributes({
        ...$$restProps,
        class: clsx(classes),
        "data-bs-theme": theme
      })}>`);
      if (content) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(content)}`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--> `);
      if (positioned || indicator) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span class="visually-hidden">${escape_html(ariaLabel)}</span>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></span>`);
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      ariaLabel,
      border,
      class: className,
      content,
      color,
      href,
      indicator,
      pill,
      positioned,
      placement,
      shadow,
      theme
    });
  });
}
export {
  Badge as B
};
