import { ao as sanitize_slots, a4 as sanitize_props, a5 as rest_props, a6 as fallback, a7 as attributes, a8 as clsx, aa as escape_html, a0 as slot, ad as attr_class, ac as attr, a9 as bind_props } from "./index2.js";
import { c as classnames } from "./Theme.svelte_svelte_type_style_lang.js";
function Alert($$renderer, $$props) {
  const $$slots = sanitize_slots($$props);
  const $$sanitized_props = sanitize_props($$props);
  const $$restProps = rest_props($$sanitized_props, [
    "class",
    "content",
    "closeAriaLabel",
    "closeClassName",
    "color",
    "dismissible",
    "fade",
    "heading",
    "isOpen",
    "toggle",
    "theme",
    "transition"
  ]);
  $$renderer.component(($$renderer2) => {
    let showClose, classes, closeClassNames;
    let className = fallback($$props["class"], "");
    let content = fallback($$props["content"], void 0);
    let closeAriaLabel = fallback($$props["closeAriaLabel"], "Close");
    let closeClassName = fallback($$props["closeClassName"], "");
    let color = fallback($$props["color"], "success");
    let dismissible = fallback($$props["dismissible"], false);
    let fade = fallback($$props["fade"], true);
    let heading = fallback($$props["heading"], "");
    let isOpen = fallback($$props["isOpen"], true);
    let toggle = fallback($$props["toggle"], void 0);
    let theme = fallback($$props["theme"], void 0);
    let transition = fallback($$props["transition"], () => ({ duration: fade ? 400 : 0 }), true);
    showClose = dismissible || toggle;
    classes = classnames(className, "alert", `alert-${color}`, { "alert-dismissible": showClose });
    closeClassNames = classnames("btn-close", closeClassName);
    if (isOpen) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attributes({
        ...$$restProps,
        "data-bs-theme": theme,
        class: clsx(classes),
        role: "alert"
      })}>`);
      if (heading || $$slots.heading) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<h4 class="alert-heading">${escape_html(heading)}<!--[-->`);
        slot($$renderer2, $$props, "heading", {}, null);
        $$renderer2.push(`<!--]--></h4>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (showClose) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button type="button"${attr_class(clsx(closeClassNames))}${attr("aria-label", closeAriaLabel)}></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (content) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(content)}`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<!--[-->`);
        slot($$renderer2, $$props, "default", {}, null);
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, {
      class: className,
      content,
      closeAriaLabel,
      closeClassName,
      color,
      dismissible,
      fade,
      heading,
      isOpen,
      toggle,
      theme,
      transition
    });
  });
}
export {
  Alert as A
};
