import { a1 as store_get, ag as ensure_array_like, ac as attr, ad as attr_class, a8 as clsx, aa as escape_html, a3 as unsubscribe_stores, a9 as bind_props } from "./index2.js";
import { p as page } from "./stores.js";
import "clsx";
import "./Theme.svelte_svelte_type_style_lang.js";
function EmailNav($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let navList = $$props["navList"];
    let urlPath;
    urlPath = store_get($$store_subs ??= {}, "$page", page).url.pathname.substring(store_get($$store_subs ??= {}, "$page", page).url.pathname.lastIndexOf("/") + 1);
    $$renderer2.push(`<nav class="dm-mail-navbar"><ul class="dm-mail-list"><!--[-->`);
    const each_array = ensure_array_like(
      // console.log(unreadCount);
      navList
    );
    for (let i = 0, $$length = each_array.length; i < $$length; i++) {
      let { text, icon, path, unread } = each_array[i];
      $$renderer2.push(`<li><a${attr("href", path)}${attr_class(clsx(urlPath === path ? "dm-mailbox-navlink active" : "dm-mailbox-navlink"))}${attr("id", i)}><i${attr_class("uil uil-" + icon)}></i> <div class="dm-mailbox-navlink__text"><span>${escape_html(text)}</span> `);
      if (unread !== 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span class="badge badge-primary">${escape_html(unread)}</span>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div></a></li>`);
    }
    $$renderer2.push(`<!--]--></ul></nav>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { navList });
  });
}
function EmailLabel($$renderer, $$props) {
  let labelList = $$props["labelList"];
  $$renderer.push(`<ul class="dm-mail-label-list mt-0"><!--[-->`);
  const each_array = ensure_array_like(labelList);
  for (let i = 0, $$length = each_array.length; i < $$length; i++) {
    let { text } = each_array[i];
    $$renderer.push(`<li><a href="#"><i class="uil uil-list-ul"></i>${escape_html(text)}</a></li>`);
  }
  $$renderer.push(`<!--]--> <li></li></ul>`);
  bind_props($$props, { labelList });
}
function AddLabel($$renderer) {
  $$renderer.push(`<div class="btn-add-label"><a href="#" class="btn-add-label__text"><i class="uil uil-plus"></i> <span>Add New</span></a> `);
  {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--></div>`);
}
export {
  AddLabel as A,
  EmailNav as E,
  EmailLabel as a
};
